/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.connect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.refactor.connect.IRefactorConnectAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementAlgorithm;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementUtils;

public class VlogRefactorConnectAlgorithm
extends VlogRefactorDesignElementAlgorithm
implements IRefactorConnectAlgorithm {
    private DVTRefactorConnectWizardInput refactorInput;
    protected List<String> scalars = Arrays.asList("wire", "byte", "shortint", "int", "longint", "integer", "time", "bit", "logic", "reg", "shortreal", "real", "realtime", "shortreal", "real", "realtime", "supply0", "supply1", "tri", "triand", "trior", "trireg", "tri0", "tri1", "uwire", "wand", "wor", "reg");

    public void setRefactorInput(DVTRefactorConnectWizardInput user) {
        this.refactorInput = user;
    }

    public Set<RefactorInputWrapper> computeChangeWrappers(DVTNode srcNode, IRfPortElement srcPort, DVTNode dstNode, IRfPortElement dstPort) {
        HashSet<RefactorInputWrapper> changeWrappers = new HashSet<RefactorInputWrapper>();
        DVTNode junctionNode = DVTRefactorDesignElementUtils.computeCommonAncestor((DVTNode)srcNode, (DVTNode)dstNode);
        if (junctionNode == null) {
            return null;
        }
        DVTNode rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((DVTNode)junctionNode);
        RefactorInputWrapper wireChg = this.wrappersFactory.makeWireChangeWrapper(rootNode, this.refactorInput.getVlogParentSignal(), this.refactorInput.getVlogSignalType(), this.refactorInput.getVlogSignalWidth());
        if (wireChg != null) {
            changeWrappers.add(wireChg);
        }
        List<RefactorInputWrapper> selectedInstancesWrappers = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput, srcPort, dstPort);
        changeWrappers.addAll(selectedInstancesWrappers);
        boolean excludeSrcModule = srcPort != null;
        boolean excludeDstModule = dstPort != null;
        List<RefactorInputWrapper> selectedModuleWrappers = this.wrappersFactory.makeConnectedModulesChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput, selectedInstancesWrappers, excludeSrcModule, excludeDstModule);
        changeWrappers.addAll(selectedModuleWrappers);
        List allDirectInstanceChgs = DVTRefactorDesignElementUtils.getAllDirectConnectedInstances((DVTNode)rootNode, (DVTNode)srcNode, (DVTNode)dstNode);
        List<RefactorInputWrapper> allDirectModuleOrEntityDesigns = this.wrappersFactory.makeAllDirectConnectedModuleOrEntityDesignsChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput.getVlogInputPortName(), this.refactorInput.getVlogOutputPortName(), this.refactorInput.getVlogSignalType(), this.refactorInput.getVlogSignalWidth());
        List<IRfDesignElement> excludedMods = VlogRefactorDesignElementUtils.computeExcludedModulesConnectAction((DVTNode)(excludeSrcModule ? srcNode : null), (DVTNode)(excludeDstModule ? dstNode : null));
        List<RefactorInputWrapper> remainingInstancesWrappers = this.wrappersFactory.makeIndirectConnectInstanceChangeWrappers(this.rfProject, allDirectInstanceChgs, allDirectModuleOrEntityDesigns, excludedMods, (IProgressMonitor)new NullProgressMonitor());
        changeWrappers.addAll(remainingInstancesWrappers);
        return changeWrappers;
    }

    public String validateWrappers(DVTNode srcNode, IRfPortElement srcPort, DVTNode dstNode, IRfPortElement dstPort, DVTRefactorConnectWizardInput input) {
        String fail1 = VlogRefactorDesignElementUtils.validNoInternalLoops(srcNode, dstNode);
        if (fail1 != null) {
            return fail1;
        }
        String fail2 = this.wrappersFactory.validTreeChanges(this.computeChangeWrappers(srcNode, srcPort, dstNode, dstPort), input, (IProgressMonitor)new NullProgressMonitor());
        if (fail2 != null) {
            return fail2;
        }
        return null;
    }

    public String validateWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, DVTRefactorConnectWizardInput input, IProgressMonitor monitor) {
        String fail1 = VlogRefactorDesignElementUtils.validNoInternalLoops(srcNode, dstNode, project, monitor);
        if (fail1 != null) {
            return fail1;
        }
        String fail2 = this.wrappersFactory.validTreeChanges(this.computeChangeWrappers(srcNode, srcPort, dstNode, dstPort, project, monitor), input, monitor);
        if (fail2 != null) {
            return fail2;
        }
        return null;
    }

    public Set<TextChange> computeChangesFromWrappers(Set<RefactorInputWrapper> changeWrappers, IProgressMonitor pm) {
        HashSet<TextChange> allTextChanges = new HashSet<TextChange>();
        ArrayList<RefactorInputWrapper> instances = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper changeWrapper : changeWrappers) {
            IRfNamedElement targetElement = changeWrapper.getTargetElement();
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (targetElement instanceof RfModule) {
                List<TextChange> moduleTextChanges = this.textChangeFactory.makeModuleTextChanges(changeWrapper);
                if (moduleTextChanges.isEmpty()) continue;
                allTextChanges.addAll(moduleTextChanges);
                continue;
            }
            if (!(targetElement instanceof RfInstance)) continue;
            if (changeWrapper.getRefactorOperation() == RefactorDesignElementOperation.USE_EXISTING_PORT) {
                List<TextChange> connectExistingInstanceChanges = this.textChangeFactory.makeConnectExistingTextChanges(changeWrapper);
                if (connectExistingInstanceChanges.isEmpty()) continue;
                allTextChanges.addAll(connectExistingInstanceChanges);
                continue;
            }
            instances.add(changeWrapper);
        }
        List<TextChange> textInstChgs = this.textChangeFactory.makeInstancesTextChanges(instances, pm);
        allTextChanges.addAll(textInstChgs);
        return allTextChanges;
    }

    public String[] getSignalTypeContentAssistSuggestions(IProject project) {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.addAll(this.scalars);
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        if (rfProj == null) {
            return suggestions.toArray(new String[suggestions.size()]);
        }
        RfInterface[] allExistingInterfaces = rfProj.getAllInterfaces();
        RfModport[] allExistingModports = rfProj.getAllModports();
        suggestions.addAll(this.scalars);
        RfMembersHolder[] rfMembersHolderArray = allExistingInterfaces;
        int n = allExistingInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            RfInterface intf = rfMembersHolderArray[n2];
            suggestions.add(intf.getName());
            ++n2;
        }
        rfMembersHolderArray = allExistingModports;
        n = allExistingModports.length;
        n2 = 0;
        while (n2 < n) {
            RfMembersHolder modport = rfMembersHolderArray[n2];
            suggestions.add(modport.getName());
            ++n2;
        }
        return suggestions.toArray(new String[suggestions.size()]);
    }

    public Set<RefactorInputWrapper> computeChangeWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        HashSet<RefactorInputWrapper> changeWrappers = new HashSet<RefactorInputWrapper>();
        String[] junctionNode = DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode);
        if (junctionNode == null) {
            return null;
        }
        String[] rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])junctionNode, (IProject)project);
        RefactorInputWrapper wireChg = this.wrappersFactory.makeWireChangeWrapper(rootNode, srcNode, dstNode, this.refactorInput.getVlogParentSignal(), this.refactorInput.getVlogSignalType(), this.refactorInput.getVlogSignalWidth(), project);
        if (wireChg != null) {
            changeWrappers.add(wireChg);
        }
        List<RefactorInputWrapper> selectedInstancesWrappers = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput, srcPort, dstPort, project, monitor);
        changeWrappers.addAll(selectedInstancesWrappers);
        boolean excludeSrcModule = srcPort != null;
        boolean excludeDstModule = dstPort != null;
        List<RefactorInputWrapper> selectedModuleWrappers = this.wrappersFactory.makeConnectedModulesChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput, selectedInstancesWrappers, excludeSrcModule, excludeDstModule, project, monitor);
        changeWrappers.addAll(selectedModuleWrappers);
        List allDirectInstanceChgs = DVTRefactorDesignElementUtils.getAllDirectConnectedInstances((String[])rootNode, (String[])srcNode, (String[])dstNode, (IProject)project, (IProgressMonitor)monitor);
        List<RefactorInputWrapper> allDirectModuleOrEntityDesigns = this.wrappersFactory.makeAllDirectConnectedModuleOrEntityDesignsChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput.getVlogInputPortName(), this.refactorInput.getVlogOutputPortName(), this.refactorInput.getVlogSignalType(), this.refactorInput.getVlogSignalWidth(), project, monitor);
        List<IRfDesignElement> excludedMods = VlogRefactorDesignElementUtils.computeExcludedModulesConnectAction((String[])(excludeSrcModule ? srcNode : null), (String[])(excludeDstModule ? dstNode : null), project);
        List<RefactorInputWrapper> remainingInstancesWrappers = this.wrappersFactory.makeIndirectConnectInstanceChangeWrappers(this.rfProject, allDirectInstanceChgs, allDirectModuleOrEntityDesigns, excludedMods, monitor);
        changeWrappers.addAll(remainingInstancesWrappers);
        return changeWrappers;
    }

    public Set<RefactorInputWrapper> computeDirectChangeWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        HashSet<RefactorInputWrapper> changeWrappers = new HashSet<RefactorInputWrapper>();
        String[] junctionNode = DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode);
        if (junctionNode == null) {
            return null;
        }
        String[] rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])junctionNode, (IProject)project);
        RefactorInputWrapper wireChg = this.wrappersFactory.makeWireChangeWrapper(rootNode, srcNode, dstNode, this.refactorInput.getVlogParentSignal(), this.refactorInput.getVlogSignalType(), this.refactorInput.getVlogSignalWidth(), project);
        if (wireChg != null) {
            changeWrappers.add(wireChg);
        }
        List<RefactorInputWrapper> selectedInstancesWrappers = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput, srcPort, dstPort, project, monitor);
        changeWrappers.addAll(selectedInstancesWrappers);
        boolean excludeSrcModule = srcPort != null;
        boolean excludeDstModule = dstPort != null;
        List<RefactorInputWrapper> selectedModuleWrappers = this.wrappersFactory.makeConnectedModulesChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput, selectedInstancesWrappers, excludeSrcModule, excludeDstModule, project, monitor);
        changeWrappers.addAll(selectedModuleWrappers);
        return changeWrappers;
    }

    public Set<RefactorInputWrapper> computeIndirectChangeWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        HashSet<RefactorInputWrapper> changeWrappers = new HashSet<RefactorInputWrapper>();
        String[] junctionNode = DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode);
        if (junctionNode == null) {
            return null;
        }
        String[] rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])junctionNode, (IProject)project);
        boolean excludeSrcModule = srcPort != null;
        boolean excludeDstModule = dstPort != null;
        List allDirectInstanceChgs = DVTRefactorDesignElementUtils.getAllDirectConnectedInstances((String[])rootNode, (String[])srcNode, (String[])dstNode, (IProject)project, (IProgressMonitor)monitor);
        List<RefactorInputWrapper> allDirectModuleOrEntityDesigns = this.wrappersFactory.makeAllDirectConnectedModuleOrEntityDesignsChangeWrappers(rootNode, srcNode, dstNode, this.refactorInput.getVlogInputPortName(), this.refactorInput.getVlogOutputPortName(), this.refactorInput.getVlogSignalType(), this.refactorInput.getVlogSignalWidth(), project, monitor);
        List<IRfDesignElement> excludedMods = VlogRefactorDesignElementUtils.computeExcludedModulesConnectAction((String[])(excludeSrcModule ? srcNode : null), (String[])(excludeDstModule ? dstNode : null), project);
        List<RefactorInputWrapper> remainingInstancesWrappers = this.wrappersFactory.makeIndirectConnectInstanceChangeWrappers(this.rfProject, allDirectInstanceChgs, allDirectModuleOrEntityDesigns, excludedMods, monitor);
        changeWrappers.addAll(remainingInstancesWrappers);
        return changeWrappers;
    }
}

