/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorRfInstanceWrapper;

public class VlogRefactorDesignElementUtils
extends DVTRefactorDesignElementUtils {
    public static IRfNamedElement getDuplicateElement(String elementName, IRfDesignElement scope) {
        Object duplicate = null;
        duplicate = scope.getPortWithPrefix(elementName, 1);
        if (duplicate != null) {
            return duplicate;
        }
        duplicate = scope.getParameterWithPrefix(elementName, 1);
        if (duplicate != null) {
            return duplicate;
        }
        duplicate = scope.getInstanceWithPrefix(elementName, 1);
        if (duplicate != null) {
            return duplicate;
        }
        if (scope instanceof RfModule && (duplicate = ((RfModule)scope).getFieldWithPrefix(elementName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null) {
            return duplicate;
        }
        return duplicate;
    }

    public static List<IRfDesignElement> computeExcludedModulesConnectAction(DVTNode srcNode, DVTNode dstNode) {
        ArrayList<IRfDesignElement> excluded = new ArrayList<IRfDesignElement>();
        if (srcNode != null && VlogRefactorDesignElementUtils.getDesignElementFromInstance(srcNode.element) != null) {
            excluded.add(VlogRefactorDesignElementUtils.getDesignElementFromInstance(srcNode.element));
        }
        if (dstNode != null && VlogRefactorDesignElementUtils.getDesignElementFromInstance(dstNode.element) != null) {
            excluded.add(VlogRefactorDesignElementUtils.getDesignElementFromInstance(dstNode.element));
        }
        return excluded;
    }

    public static List<IRfDesignElement> computeExcludedModulesConnectAction(String[] srcNode, String[] dstNode, IProject project) {
        IRfNamedElement elementFromSegments;
        IRfDesignElement designElementFromInstance;
        ArrayList<IRfDesignElement> excluded = new ArrayList<IRfDesignElement>();
        if (srcNode != null && (designElementFromInstance = VlogRefactorDesignElementUtils.getDesignElementFromInstance(elementFromSegments = VlogRefactorDesignElementUtils.getElementFromSegments((String[])srcNode, (IProject)project))) != null) {
            excluded.add(designElementFromInstance);
        }
        if (dstNode != null && VlogRefactorDesignElementUtils.getDesignElementFromInstance(elementFromSegments = VlogRefactorDesignElementUtils.getElementFromSegments((String[])dstNode, (IProject)project)) != null) {
            excluded.add(VlogRefactorDesignElementUtils.getDesignElementFromInstance(elementFromSegments));
        }
        return excluded;
    }

    public static IRfDesignElement getDesignElementFromInstance(Object o) {
        if (o instanceof IRfInstanceElement) {
            IRfNamedElement b;
            IRfNamedElement a = ((IRfInstanceElement)o).getAssociatedType();
            if (a instanceof IRfDesignElement) {
                return (IRfDesignElement)a;
            }
            if (a instanceof RfListType && (b = ((RfListType)a).getAssociatedType()) instanceof IRfDesignElement) {
                return (IRfDesignElement)b;
            }
        } else if (o instanceof IRfDesignElement) {
            return (IRfDesignElement)o;
        }
        return null;
    }

    public static List<IRfInstanceElement> getAllInstancesOfDesignElement(RfProject rfProject, IRfDesignElement moduleOrEntity) {
        return rfProject.collectInstances(moduleOrEntity);
    }

    public static boolean hasEmptyPort(VlogRefactorRfInstanceWrapper vlogRefactorInstanceWrapper, String portName, boolean experimentalNonExisting) {
        List portConnections = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)vlogRefactorInstanceWrapper.getInstance());
        if (portConnections == null || portConnections.isEmpty()) {
            return true;
        }
        if (vlogRefactorInstanceWrapper.hasNamedPortConnections()) {
            boolean dotStar = false;
            for (IHidOperator pc : portConnections) {
                if (!PortConnectionUtils.getPortName((IHidOperator)pc).equals(portName)) continue;
                if (PortConnectionUtils.isDotStarConnected((IHidOperator)pc)) {
                    dotStar = true;
                    continue;
                }
                return PortConnectionUtils.isFullNamedUnconnected((IHidOperator)pc);
            }
            if (dotStar) {
                return false;
            }
        } else {
            IRfNamedElement type = vlogRefactorInstanceWrapper.getInstance().getAssociatedType();
            if (vlogRefactorInstanceWrapper.getInstance().getAssociatedType() instanceof RfModule) {
                IHidOperator pc;
                RfModule mod = (RfModule)type;
                List<RfPort> ports = mod.getPortsWithPrefix("", 2);
                int index = 0;
                boolean found = false;
                int i = 0;
                while (i < ports.size()) {
                    if (ports.get(i).getName().equals(portName)) {
                        index = i;
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found && portConnections.size() > index && (PortConnectionUtils.isOrderedUnconnected((IHidOperator)(pc = (IHidOperator)portConnections.get(index))) || PortConnectionUtils.isFullNamedUnconnected((IHidOperator)pc) || PortConnectionUtils.isImplicitNamedConnected((IHidOperator)pc))) {
                    return true;
                }
            }
        }
        return experimentalNonExisting;
    }

    public static String matchPortDirectionWidth(VlogRefactorRfInstanceWrapper vlogRefactorInstanceWrapper, String portName, String portDir, String portType, String dimension) {
        String defaultError = "Internal error while computing matchPortDirectionWidth";
        IRfNamedElement type = vlogRefactorInstanceWrapper.getInstance().getAssociatedType();
        RfModule mod = null;
        if (type instanceof RfModule) {
            mod = (RfModule)type;
        } else if (type instanceof RfListType) {
            mod = (RfModule)((RfListType)type).getAssociatedType();
        } else {
            return defaultError;
        }
        List<RfPort> ports = mod.getPortsWithPrefix("", 2);
        int index = 0;
        boolean found = false;
        int i = 0;
        while (i < ports.size()) {
            if (ports.get(i).getName().equals(portName)) {
                index = i;
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            boolean equalDim;
            boolean equalDir;
            RfPort port = ports.get(index);
            String definitionDir = port.getDirectionString();
            boolean bl = equalDir = portDir.equals(definitionDir.trim()) || definitionDir.trim().equals("inout");
            if (!equalDir) {
                return "cannot be assigned a direction of \"" + portDir + "\"";
            }
            DataTypeDimensions dimensionFromRfPort = new DataTypeDimensions(port);
            DataTypeDimensions dimensionFromString = new DataTypeDimensions(null);
            if (dimension != null && !dimension.isEmpty() && dimension.startsWith("[") && dimension.endsWith("]")) {
                dimensionFromString.packed = new ArrayList<IndexType>();
                dimensionFromString.packed.add(new IndexType(dimension.substring(1, dimension.length() - 1)));
            }
            if (!(equalDim = dimensionFromRfPort.comparePackedDimension(dimensionFromString))) {
                return "cannot be assigned a dimension of \"" + dimension + "\"";
            }
            return null;
        }
        return defaultError;
    }

    public static String validNoInternalLoops(DVTNode srcNode, DVTNode dstNode) {
        if (srcNode == dstNode) {
            return "Can not connect to self";
        }
        DVTNode rootNode = VlogRefactorDesignElementUtils.computeCommonAncestor((DVTNode)srcNode, (DVTNode)dstNode);
        ArrayList<DVTNode> allpath = new ArrayList<DVTNode>();
        DVTNode p = srcNode;
        while (true) {
            allpath.add(p);
            if (p == rootNode) break;
            p = p.fParent;
        }
        p = dstNode;
        while (p != rootNode) {
            allpath.add(p);
            p = p.fParent;
        }
        int i = 0;
        while (i < allpath.size() - 1) {
            DVTNode p2 = (DVTNode)allpath.get(i);
            int j = i + 1;
            while (j < allpath.size()) {
                DVTNode q = (DVTNode)allpath.get(j);
                IRfDesignElement pModule = VlogRefactorDesignElementUtils.getDesignElementFromInstance(p2.element);
                IRfDesignElement qModule = VlogRefactorDesignElementUtils.getDesignElementFromInstance(q.element);
                if (pModule != null && pModule == qModule) {
                    return "There is a reference to self for Module " + pModule.getName();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static String validNoInternalLoops(String[] srcNode, String[] dstNode, IProject project, IProgressMonitor monitor) {
        Object[] rootNode;
        if (Arrays.equals(srcNode, dstNode)) {
            return "Can not connect to self";
        }
        try {
            rootNode = VlogRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode);
        }
        catch (RuntimeException e) {
            return e.getMessage();
        }
        ArrayList<Object[]> allpath = new ArrayList<Object[]>();
        Object[] p = srcNode;
        while (true) {
            allpath.add(p);
            if (Arrays.equals(p, rootNode)) break;
            p = VlogRefactorDesignElementUtils.subList((String[])p);
        }
        p = dstNode;
        while (!Arrays.equals(p, rootNode)) {
            allpath.add(p);
            p = VlogRefactorDesignElementUtils.subList((String[])p);
        }
        int i = 0;
        while (i < allpath.size() - 1) {
            String[] p2 = (String[])allpath.get(i);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int j = i + 1;
            while (j < allpath.size()) {
                String[] q = (String[])allpath.get(j);
                IRfNamedElement pElement = VlogRefactorDesignElementUtils.getElementFromSegments((String[])p2, (IProject)project);
                IRfNamedElement qElement = VlogRefactorDesignElementUtils.getElementFromSegments((String[])q, (IProject)project);
                IRfDesignElement pModule = VlogRefactorDesignElementUtils.getDesignElementFromInstance(pElement);
                IRfDesignElement qModule = VlogRefactorDesignElementUtils.getDesignElementFromInstance(qElement);
                if (pModule != null && pModule == qModule) {
                    return "There is a reference to self for Module " + pModule.getName();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static boolean supports(Object namedElement) {
        return namedElement instanceof IRfInstanceElement || namedElement instanceof IRfDesignElement;
    }

    public static List<VlogRefactorRfInstanceWrapper> getInstancesWrappers(List<RfNamedElement> instances) {
        ArrayList<VlogRefactorRfInstanceWrapper> instancesWrapper = new ArrayList<VlogRefactorRfInstanceWrapper>();
        for (RfNamedElement instance : instances) {
            if (!(instance instanceof IRfInstanceElement)) continue;
            instancesWrapper.add(new VlogRefactorRfInstanceWrapper((IRfInstanceElement)instance));
        }
        return instancesWrapper;
    }
}

