/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorInputWrapperFactory;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementUtils;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorRfInstanceWrapper;

public class VlogRefactorInputWrapperFactory
extends DVTRefactorInputWrapperFactory {
    public List<RefactorInputWrapper> makeInstancesAddChangeWrappers(RfProject rfProject, RefactorInputWrapper moduleChangeWrapper) {
        ArrayList<RefactorInputWrapper> instancesWrappers = new ArrayList<RefactorInputWrapper>();
        RefactorDesignElementOperation refactorOperation = moduleChangeWrapper.getRefactorOperation();
        String newElementName = moduleChangeWrapper.getNewElementName();
        String type = moduleChangeWrapper.getType();
        String width = moduleChangeWrapper.getWidth();
        String connectionValue = "/*FIXME: not connected*/";
        String genericDefaultValue = moduleChangeWrapper.getGenericDefaultValue();
        List<IRfInstanceElement> allModInsts = VlogRefactorDesignElementUtils.getAllInstancesOfDesignElement(rfProject, (IRfDesignElement)moduleChangeWrapper.getTargetElement());
        for (IRfInstanceElement modInst : allModInsts) {
            RefactorInputWrapper instanceWrapper;
            if (refactorOperation == RefactorDesignElementOperation.ADD_PORT) {
                RefactorInputWrapper instanceAddPortWrapper;
                if (this.isDuplicatedPort(newElementName, modInst) || (instanceAddPortWrapper = this.makeInstancePortConnectionChangeWrapper(null, false, false, (IRfNamedElement)modInst, newElementName, connectionValue, moduleChangeWrapper.getDirection(), type, width, false)) == null) continue;
                instancesWrappers.add(instanceAddPortWrapper);
                continue;
            }
            if (refactorOperation != RefactorDesignElementOperation.ADD_GENERIC || this.isDuplicatedGeneric(newElementName, modInst) || (instanceWrapper = this.makeInstanceParameterConnectionChangeWrapper(null, false, false, (IRfNamedElement)modInst, newElementName, type, width, connectionValue, genericDefaultValue, false)) == null) continue;
            instancesWrappers.add(instanceWrapper);
        }
        return instancesWrappers;
    }

    private boolean isDuplicatedPort(String newElementName, IRfInstanceElement modInst) {
        if (newElementName == null) {
            return false;
        }
        List instancePCs = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)modInst);
        if (instancePCs == null) {
            return false;
        }
        for (IHidOperator portConnection : instancePCs) {
            if (!newElementName.equals(PortConnectionUtils.getPortName((IHidOperator)portConnection))) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicatedGeneric(String newElementName, IRfInstanceElement modInst) {
        if (!(modInst instanceof RfInstance) || newElementName == null) {
            return false;
        }
        DataType instanceDataType = ((RfInstance)modInst).getDataType();
        if (instanceDataType == null) {
            return false;
        }
        HidOperatorVisitor visitor = new HidOperatorVisitor(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY);
        RfHidHolder paramValuesHolder = instanceDataType.getParamValuesHolder();
        if (paramValuesHolder == null) {
            return false;
        }
        paramValuesHolder.visitHidObject(null, (IHidVisitor)visitor);
        List parameterValueOperators = visitor.getObjects();
        if (parameterValueOperators == null) {
            return false;
        }
        for (IHidOperator op : parameterValueOperators) {
            IHidObject hid = op.getLHValue();
            if (hid == null || !(hid instanceof RfHidImplicit) || !newElementName.equals(((RfHidImplicit)hid).getName())) continue;
            return true;
        }
        return false;
    }

    public Map<IRfInstanceElement, List<RefactorInputWrapper>> makeInstancesAddMultiplePortsChangeWrappers(List<RefactorInputWrapper> allChangeWrappers, RfModule enclosingModule, RfProject rfProject) {
        HashMap<IRfInstanceElement, List<RefactorInputWrapper>> instancesMultiplePortsChangeWrappers = new HashMap<IRfInstanceElement, List<RefactorInputWrapper>>();
        List<IRfInstanceElement> allModInsts = VlogRefactorDesignElementUtils.getAllInstancesOfDesignElement(rfProject, enclosingModule);
        for (IRfInstanceElement modInst : allModInsts) {
            ArrayList<RefactorInputWrapper> instancesWrappers = new ArrayList<RefactorInputWrapper>();
            for (RefactorInputWrapper moduleChangeWrapper : allChangeWrappers) {
                RefactorInputWrapper instanceAddPortWrapper;
                String newElementName = moduleChangeWrapper.getNewElementName();
                String type = moduleChangeWrapper.getType();
                String width = moduleChangeWrapper.getWidth();
                String connectionValue = "/*FIXME: not connected*/";
                if (this.isDuplicatedPort(newElementName, modInst) || (instanceAddPortWrapper = this.makeInstanceForwardPortConnectionChangeWrapper(null, false, false, (IRfNamedElement)modInst, newElementName, connectionValue, moduleChangeWrapper.getDirection(), type, width, false)) == null) continue;
                instancesWrappers.add(instanceAddPortWrapper);
            }
            instancesMultiplePortsChangeWrappers.put(modInst, instancesWrappers);
        }
        return instancesMultiplePortsChangeWrappers;
    }

    public RefactorInputWrapper makeWireChangeWrapper(DVTNode designElementNode, String signalName, String signalType, String signalWidth) {
        IRfNamedElement element = ((DVTNode)designElementNode.fChildren.get((int)0)).element;
        if (!VlogRefactorDesignElementUtils.supports(element)) {
            return null;
        }
        RfModule mod = (RfModule)DVTRefactorDesignElementUtils.getFirstSupportedScopeT((IRfScopeElement)element, RfModule.class);
        if (mod == null) {
            return null;
        }
        return new RefactorInputWrapper(RefactorDesignElementOperation.ADD_WIRE, (IRfNamedElement)mod, null, false, signalName, "", signalType, signalName, signalWidth, "", false, false);
    }

    public RefactorInputWrapper makeWireChangeWrapper(String[] designElementNode, String[] srcNode, String[] dstNode, String signalName, String signalType, String signalWidth, IProject project) {
        IRfNamedElement element = DVTRefactorDesignElementUtils.getElementFromSegments((String[])DVTRefactorDesignElementUtils.computeCommonAncestorChild((String[])designElementNode, (String[])srcNode, (String[])dstNode), (IProject)project);
        if (element instanceof DummyInstance) {
            element = ((DummyInstance)element).design;
        }
        if (!VlogRefactorDesignElementUtils.supports(element)) {
            return null;
        }
        RfModule mod = (RfModule)DVTRefactorDesignElementUtils.getFirstSupportedScopeT((IRfScopeElement)element, RfModule.class);
        if (mod == null) {
            return null;
        }
        return new RefactorInputWrapper(RefactorDesignElementOperation.ADD_WIRE, (IRfNamedElement)mod, designElementNode, false, signalName, "", signalType, signalName, signalWidth, "", false, false);
    }

    public List<RefactorInputWrapper> makeIndirectConnectInstanceChangeWrappers(RfProject rfProject, List<IRfInstanceElement> allDirectInstanceChgs, List<RefactorInputWrapper> allDirectModuleOrEntityDesigns, List<IRfDesignElement> excludedMods, IProgressMonitor monitor) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper moduleOrEntityDesign : allDirectModuleOrEntityDesigns) {
            if (excludedMods.contains(moduleOrEntityDesign.getTargetElement())) continue;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<IRfInstanceElement> instancesOfModOrEnt = rfProject.collectInstances((IRfDesignElement)moduleOrEntityDesign.getTargetElement());
            for (IRfInstanceElement instanceOfModOrEnt : instancesOfModOrEnt) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!VlogRefactorDesignElementUtils.supports(instanceOfModOrEnt) || allDirectInstanceChgs.contains(instanceOfModOrEnt)) continue;
                result.add(this.makeInstancePortConnectionChangeWrapper(moduleOrEntityDesign.getPath(), moduleOrEntityDesign.isOutput(), moduleOrEntityDesign.isInitialGate(), (IRfNamedElement)instanceOfModOrEnt, moduleOrEntityDesign.getNewElementName(), "/*FIXME: not connected*/", moduleOrEntityDesign.getDirection(), moduleOrEntityDesign.getType(), moduleOrEntityDesign.getWidth(), false));
            }
        }
        return result;
    }

    public List<RefactorInputWrapper> makeSelectedInstancesConnectChangeWrappers(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode, DVTRefactorConnectWizardInput wizardInput, IRfPortElement srcPort, IRfPortElement dstPort) {
        String signalName;
        ArrayList<RefactorInputWrapper> instanceChgs = new ArrayList<RefactorInputWrapper>();
        String parentSignalName = wizardInput.getVlogParentSignal();
        String signalType = wizardInput.getVlogSignalType();
        String signalWidth = wizardInput.getVlogSignalWidth();
        String[] dirNames = new String[]{"output", "input"};
        String[] signalNames = new String[]{wizardInput.getVlogOutputPortName(), wizardInput.getVlogInputPortName()};
        String[] portNames = new String[]{wizardInput.getVlogOutputPortName(), wizardInput.getVlogInputPortName()};
        RefactorInputWrapper existingSrc = null;
        RefactorInputWrapper existingDst = null;
        if (srcPort != null) {
            signalName = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((DVTNode)srcNode.fParent) == rootNode ? parentSignalName : signalNames[0];
            existingSrc = new RefactorInputWrapper(RefactorDesignElementOperation.USE_EXISTING_PORT, srcNode.element, null, false, srcPort.getName(), "output", "", signalName, "", "", false, true);
            instanceChgs.add(existingSrc);
        }
        if (dstPort != null) {
            signalName = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((DVTNode)dstNode.fParent) == rootNode ? parentSignalName : signalNames[1];
            existingDst = new RefactorInputWrapper(RefactorDesignElementOperation.USE_EXISTING_PORT, dstNode.element, null, false, dstPort.getName(), "input", "", signalName, "", "", false, true);
            instanceChgs.add(existingDst);
        }
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                if (!(p == srcNode && srcPort != null || p == dstNode && dstPort != null)) {
                    if (DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((DVTNode)p.fParent) == rootNode) {
                        if (VlogRefactorDesignElementUtils.supports(p.element)) {
                            instanceChgs.add(this.makeInstancePortConnectionChangeWrapper(null, false, false, p.element, portNames[dir], parentSignalName, dirNames[dir], signalType, signalWidth, p.insideGenBlock));
                        }
                    } else if (VlogRefactorDesignElementUtils.supports(p.element)) {
                        instanceChgs.add(this.makeInstancePortConnectionChangeWrapper(null, false, false, p.element, portNames[dir], signalNames[dir], dirNames[dir], signalType, signalWidth, p.insideGenBlock));
                    }
                }
                p = p.fParent;
            }
            ++dir;
        }
        return instanceChgs;
    }

    public List<RefactorInputWrapper> makeConnectedModulesChangeWrappers(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode, DVTRefactorConnectWizardInput userInput, List<RefactorInputWrapper> instanceChgs, boolean excludeSrc, boolean excludeDst) {
        ArrayList<RefactorInputWrapper> modulesChgs = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper instanceChg : instanceChgs) {
            IRfDesignElement mod = VlogRefactorDesignElementUtils.getDesignElementFromInstance(instanceChg.getTargetElement());
            if (excludeSrc && VlogRefactorDesignElementUtils.getDesignElementFromInstance(srcNode.element) == mod || excludeDst && VlogRefactorDesignElementUtils.getDesignElementFromInstance(dstNode.element) == mod || mod == null) continue;
            modulesChgs.add(this.makeDesignElementPortChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), instanceChg.isInitialGate(), (IRfNamedElement)mod, instanceChg.getNewElementName(), instanceChg.getDirection(), userInput.getVlogSignalType(), userInput.getVlogSignalWidth()));
        }
        String[] dirNames = new String[]{"output", "input"};
        String[] portNames = new String[]{userInput.getVlogOutputPortName(), userInput.getVlogInputPortName()};
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                RefactorInputWrapper ch;
                if (!(!VlogRefactorDesignElementUtils.supports(p.instanceType) || excludeSrc && VlogRefactorDesignElementUtils.getDesignElementFromInstance(srcNode.element) == p.instanceType || excludeDst && VlogRefactorDesignElementUtils.getDesignElementFromInstance(dstNode.element) == p.instanceType || modulesChgs.contains(ch = this.makeDesignElementPortChangeWrapper(null, false, false, p.instanceType, portNames[dir], dirNames[dir], userInput.getVlogSignalType(), userInput.getVlogSignalWidth())))) {
                    modulesChgs.add(ch);
                }
                p = p.fParent;
            }
            ++dir;
        }
        return modulesChgs;
    }

    public List<RefactorInputWrapper> makeAllDirectConnectedModuleOrEntityDesignsChangeWrappers(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode, String inName, String outName, String signalType, String signalWidth) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        String[] dirNames = new String[]{"output", "input"};
        String[] portNames = new String[]{outName, inName};
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                if (p.instanceType != null) {
                    RefactorInputWrapper ch = this.makeDesignElementPortChangeWrapper(null, false, false, p.instanceType, portNames[dir], dirNames[dir], signalType, signalWidth);
                    result.add(ch);
                }
                p = p.fParent;
            }
            ++dir;
        }
        return result;
    }

    public String validTreeChanges(Set<RefactorInputWrapper> changes, DVTRefactorConnectWizardInput input, IProgressMonitor monitor) {
        for (RefactorInputWrapper change : changes) {
            IRfNamedElement member;
            IRfDesignElement designElement;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IRfNamedElement targetElement = change.getTargetElement();
            if (targetElement.isPrecompiledDB()) {
                return "Unable to perform changes in precompiled code";
            }
            if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_WIRE) {
                if (!(targetElement instanceof IRfDesignElement)) {
                    return "An internal error has occurred(add signal): target element is not a module";
                }
                designElement = (IRfDesignElement)targetElement;
                if (input == null || (member = designElement.getMember(input.getVlogParentSignal(), null, null, false, false, false, false, false)) == null) continue;
                return "An internal error has occurred: the signal already exists";
            }
            if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT || change.getRefactorOperation() == RefactorDesignElementOperation.ADD_GENERIC) {
                if (!(targetElement instanceof IRfDesignElement) && !(targetElement instanceof IRfInstanceElement)) {
                    return "An internal error has occurred(add port/parameter): target element is not a module/instance";
                }
                if (targetElement instanceof IRfDesignElement) {
                    designElement = (IRfDesignElement)targetElement;
                    if (input == null || (member = designElement.getMember(input.getVlogParentSignal(), null, null, false, false, false, false, false)) == null) continue;
                    return "An internal error has occurred: the signal already exists";
                }
                if (!(targetElement instanceof IRfInstanceElement)) continue;
                IRfNamedElement associatedBaseType = ((IRfInstanceElement)targetElement).getAssociatedType();
                if (input == null || (member = associatedBaseType.getMember(change.isOutput() ? input.getVlogOutputPortName() : input.getVlogInputPortName(), null, null, false, false, false, false, false)) == null) continue;
                return "An internal error has occurred: the signal/port already exists";
            }
            if (change.getRefactorOperation() == RefactorDesignElementOperation.USE_EXISTING_PORT) {
                RfInstance inst = (RfInstance)targetElement;
                List<VlogRefactorRfInstanceWrapper> rfInsts = VlogRefactorDesignElementUtils.getInstancesWrappers(new ArrayList<RfNamedElement>(Arrays.asList(inst)));
                boolean isEmpty = VlogRefactorDesignElementUtils.hasEmptyPort(rfInsts.get(0), change.getNewElementName(), true);
                if (!isEmpty) {
                    return "(validate SV) Port \"" + change.getNewElementName() + "\" of instance \"" + targetElement.getName() + "\" is already connected.";
                }
                String validReason = VlogRefactorDesignElementUtils.matchPortDirectionWidth(rfInsts.get(0), change.getNewElementName(), change.getDirection(), change.getType(), change.getWidth());
                if (validReason == null) continue;
                return "(validate SV) Port \"" + change.getNewElementName() + "\" of instance \"" + targetElement.getName() + "\" cannot have direction \"" + change.getDirection() + "\" or type \"" + change.getType() + "\" or width \"" + change.getWidth() + "\"" + " reason:" + validReason;
            }
            return "An internal error has occurred: unknown refactoring operation";
        }
        return null;
    }

    public List<RefactorInputWrapper> makeSelectedInstancesConnectChangeWrappers(String[] rootNode, String[] srcNode, String[] dstNode, DVTRefactorConnectWizardInput wizardInput, IRfPortElement srcPort, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        String signalName;
        ArrayList<RefactorInputWrapper> instanceChgs = new ArrayList<RefactorInputWrapper>();
        String parentSignalName = wizardInput.getVlogParentSignal();
        String signalType = wizardInput.getVlogSignalType();
        String signalWidth = wizardInput.getVlogSignalWidth();
        String[] dirNames = new String[]{"output", "input"};
        String[] signalNames = new String[]{wizardInput.getVlogOutputPortName(), wizardInput.getVlogInputPortName()};
        String[] portNames = new String[]{wizardInput.getVlogOutputPortName(), wizardInput.getVlogInputPortName()};
        RefactorInputWrapper existingSrc = null;
        RefactorInputWrapper existingDst = null;
        if (srcPort != null) {
            signalName = Arrays.equals(DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.subList((String[])srcNode), (IProject)project), rootNode) ? parentSignalName : signalNames[0];
            existingSrc = new RefactorInputWrapper(RefactorDesignElementOperation.USE_EXISTING_PORT, DVTRefactorDesignElementUtils.getElementFromSegments((String[])srcNode, (IProject)project), srcNode, DVTRefactorDesignElementUtils.isOutput((String[])srcNode, (String[])srcNode, (String[])dstNode), srcPort.getName(), "output", "", signalName, "", "", false, true);
            instanceChgs.add(existingSrc);
        }
        if (dstPort != null) {
            signalName = Arrays.equals(DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.subList((String[])dstNode), (IProject)project), rootNode) ? parentSignalName : signalNames[1];
            existingDst = new RefactorInputWrapper(RefactorDesignElementOperation.USE_EXISTING_PORT, DVTRefactorDesignElementUtils.getElementFromSegments((String[])dstNode, (IProject)project), dstNode, DVTRefactorDesignElementUtils.isOutput((String[])dstNode, (String[])srcNode, (String[])dstNode), dstPort.getName(), "input", "", signalName, "", "", false, true);
            instanceChgs.add(existingDst);
        }
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!(Arrays.equals(p, srcNode) && srcPort != null || Arrays.equals(p, dstNode) && dstPort != null)) {
                    IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, (IProject)project);
                    boolean generate = DVTRefactorDesignElementUtils.isGenerate((IRfNamedElement)((IRfNamedElement)elementFromSegments.getEnclosingScope()));
                    if (Arrays.equals(DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.subList((String[])p), (IProject)project), rootNode)) {
                        if (VlogRefactorDesignElementUtils.supports(elementFromSegments)) {
                            instanceChgs.add(this.makeInstancePortConnectionChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), elementFromSegments, portNames[dir], parentSignalName, dirNames[dir], signalType, signalWidth, generate));
                        }
                    } else if (VlogRefactorDesignElementUtils.supports(elementFromSegments)) {
                        instanceChgs.add(this.makeInstancePortConnectionChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), elementFromSegments, portNames[dir], signalNames[dir], dirNames[dir], signalType, signalWidth, generate));
                    }
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return instanceChgs;
    }

    public List<RefactorInputWrapper> makeConnectedModulesChangeWrappers(String[] rootNode, String[] srcNode, String[] dstNode, DVTRefactorConnectWizardInput userInput, List<RefactorInputWrapper> instanceChgs, boolean excludeSrc, boolean excludeDst, IProject project, IProgressMonitor monitor) {
        ArrayList<RefactorInputWrapper> modulesChgs = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper instanceChg : instanceChgs) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IRfDesignElement mod = VlogRefactorDesignElementUtils.getDesignElementFromInstance(instanceChg.getTargetElement());
            if (excludeSrc && VlogRefactorDesignElementUtils.getDesignElementFromInstance(DVTRefactorDesignElementUtils.getElementFromSegments((String[])srcNode, (IProject)project)) == mod || excludeDst && VlogRefactorDesignElementUtils.getDesignElementFromInstance(DVTRefactorDesignElementUtils.getElementFromSegments((String[])dstNode, (IProject)project)) == mod || mod == null) continue;
            modulesChgs.add(this.makeDesignElementPortChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), instanceChg.isInitialGate(), (IRfNamedElement)mod, instanceChg.getNewElementName(), instanceChg.getDirection(), userInput.getVlogSignalType(), userInput.getVlogSignalWidth()));
        }
        String[] dirNames = new String[]{"output", "input"};
        String[] portNames = new String[]{userInput.getVlogOutputPortName(), userInput.getVlogInputPortName()};
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IRfNamedElement instanceType = null;
                IRfNamedElement namedElement = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, (IProject)project);
                if (namedElement instanceof IRfInstanceElement) {
                    IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(project);
                    if (elMemory != null) {
                        instanceType = ((ELInstance)elMemory.getInstancesFor((IRfInstanceElement)namedElement, 1).get(0)).getBinding(true);
                    }
                } else {
                    instanceType = namedElement;
                }
                if (!(!VlogRefactorDesignElementUtils.supports(namedElement) || excludeSrc && VlogRefactorDesignElementUtils.getDesignElementFromInstance(DVTRefactorDesignElementUtils.getElementFromSegments((String[])srcNode, (IProject)project)) == instanceType || excludeDst && VlogRefactorDesignElementUtils.getDesignElementFromInstance(DVTRefactorDesignElementUtils.getElementFromSegments((String[])dstNode, (IProject)project)) == instanceType)) {
                    RefactorInputWrapper ch = this.makeDesignElementPortChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), instanceType, portNames[dir], dirNames[dir], userInput.getVlogSignalType(), userInput.getVlogSignalWidth());
                    if (!modulesChgs.contains(ch)) {
                        modulesChgs.add(ch);
                    }
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return modulesChgs;
    }

    public List<RefactorInputWrapper> makeAllDirectConnectedModuleOrEntityDesignsChangeWrappers(String[] rootNode, String[] srcNode, String[] dstNode, String inName, String outName, String signalType, String signalWidth, IProject project, IProgressMonitor monitor) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        String[] dirNames = new String[]{"output", "input"};
        String[] portNames = new String[]{outName, inName};
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                IRfNamedElement instanceType = null;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IRfNamedElement namedElement = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, (IProject)project);
                if (namedElement instanceof IRfInstanceElement) {
                    IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(project);
                    if (elMemory != null) {
                        instanceType = ((ELInstance)elMemory.getInstancesFor((IRfInstanceElement)namedElement, 1).get(0)).getBinding(true);
                    }
                } else {
                    instanceType = namedElement;
                }
                if (instanceType != null) {
                    RefactorInputWrapper ch = this.makeDesignElementPortChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), instanceType, portNames[dir], dirNames[dir], signalType, signalWidth);
                    result.add(ch);
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return result;
    }
}

