/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.designelement;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogPositionalTooltipUtils;
import ro.amiq.vlogdt.ui.refactor.designelement.ParametersInfo;

public class VlogRefactorRfInstanceWrapper {
    private IRfInstanceElement instance;
    private Map<IRfPortElement, Set<TCConnSignal>> portMap;
    private boolean hasOrderedPortConnections;
    private List<IHidOperator> portConnectionsOperators;
    private List<IHidOperator> parameterValueOperators;
    private boolean hasOrderedParameterConnections;
    private boolean hasParameterConnections;

    public VlogRefactorRfInstanceWrapper(IRfInstanceElement instance) {
        this.setInstance(instance);
        DesignUtils.DesignRequest request = DesignUtils.DesignRequest.of((IRfNamedElement)instance, (boolean)true);
        IdentityHashMap dummyPortCache = new IdentityHashMap();
        this.portMap = DesignUtils.mapAllInstancePortConnections((DesignUtils.DesignRequest)request, dummyPortCache, (Set)DesignUtils.PORT_CONNECTION_HID_FLATTENING);
        this.hasOrderedPortConnections = this.checkOrderedPortConnections();
        ParametersInfo paramInfo = VlogPositionalTooltipUtils.getOrderedParameterConnectionsInfo(instance, this.hasParameterConnections, this.parameterValueOperators);
        this.setHasParameters(paramInfo.hasParameters());
        this.hasOrderedParameterConnections = paramInfo.hasOrderedParameterConnections();
        this.parameterValueOperators = paramInfo.getParameterValueOperators();
    }

    private boolean checkOrderedPortConnections() {
        this.portConnectionsOperators = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)this.instance);
        if (this.portConnectionsOperators == null || this.portConnectionsOperators.isEmpty()) {
            return false;
        }
        for (IHidOperator operator : this.portConnectionsOperators) {
            if (!PortConnectionUtils.isOrderedConnected((IHidOperator)operator) && !PortConnectionUtils.isOrderedUnconnected((IHidOperator)operator)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPortConnections() {
        if (this.portConnectionsOperators != null && !this.portConnectionsOperators.isEmpty()) {
            return true;
        }
        if (this.portMap == null || this.portMap.isEmpty()) {
            return false;
        }
        for (Set<TCConnSignal> values : this.portMap.values()) {
            if (values == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamedPortConnections() {
        return !this.hasOrderedPortConnections;
    }

    public boolean hasNamedParameterConnections() {
        return !this.hasOrderedParameterConnections;
    }

    public IRfPortElement getPortByName(String portName) {
        if (this.portMap == null || this.portMap.isEmpty()) {
            return null;
        }
        for (IRfPortElement port : this.portMap.keySet()) {
            if (!port.getName().equals(portName)) continue;
            return port;
        }
        return null;
    }

    public IRfInstanceElement getInstance() {
        return this.instance;
    }

    public int getNamedPortConnectionOffsetByName(String name) {
        if (this.portConnectionsOperators == null || this.portConnectionsOperators.isEmpty()) {
            return -1;
        }
        int index = 0;
        for (IHidOperator operator : this.portConnectionsOperators) {
            String operatorName = PortConnectionUtils.getPortName((IHidOperator)operator);
            if (operatorName.equals(name)) break;
            ++index;
        }
        return Utils.getOperatorFirstOffset(this.portConnectionsOperators, (int)index);
    }

    public int getOrderPortConnectionOffsetByName(String portName) {
        if (this.portConnectionsOperators == null || this.portConnectionsOperators.isEmpty()) {
            return -1;
        }
        if (this.portMap == null || this.portMap.isEmpty()) {
            return -1;
        }
        int index = this.getPortIndexByName(portName);
        if (index < 0 || index > this.portConnectionsOperators.size() - 1) {
            return -1;
        }
        return Utils.getOperatorFirstOffset(this.portConnectionsOperators, (int)index);
    }

    public int getLastPortConnectionOffset() {
        if (this.portConnectionsOperators == null || this.portConnectionsOperators.isEmpty()) {
            return -1;
        }
        return Utils.getOperatorFirstOffset(this.portConnectionsOperators, (int)(this.portConnectionsOperators.size() - 1));
    }

    public int getLastParameterConnectionOffset() {
        if (this.parameterValueOperators == null || this.parameterValueOperators.isEmpty()) {
            return -1;
        }
        return Utils.getOperatorFirstOffset(this.parameterValueOperators, (int)(this.parameterValueOperators.size() - 1));
    }

    public Set<TCConnSignal> getConnectionsByPort(IRfPortElement port) {
        if (this.portMap == null || this.portMap.isEmpty()) {
            return Collections.emptySet();
        }
        return this.portMap.get(port);
    }

    public int getLastPortConnectionIndex() {
        if (this.portConnectionsOperators == null || this.portConnectionsOperators.isEmpty()) {
            return -1;
        }
        return this.portConnectionsOperators.size() - 1;
    }

    public int getPortIndexByName(String portName) {
        if (this.portMap == null || this.portMap.isEmpty()) {
            return -1;
        }
        int index = 0;
        for (IRfPortElement port : this.portMap.keySet()) {
            if (port.getName().equals(portName)) break;
            ++index;
        }
        return index;
    }

    public void setInstance(IRfInstanceElement instance) {
        this.instance = instance;
    }

    public Map<IRfPortElement, Set<TCConnSignal>> getPortMap() {
        return this.portMap;
    }

    public void setPortMap(Map<IRfPortElement, Set<TCConnSignal>> portMap) {
        this.portMap = portMap;
    }

    public boolean hasParameterConnections() {
        return this.hasParameterConnections;
    }

    public void setHasParameters(boolean hasParameterConnections) {
        this.hasParameterConnections = hasParameterConnections;
    }
}

