/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.connect.DocManager;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementUtils;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorRfInstanceWrapper;
import ro.amiq.vlogdt.utils.Utils;

public class VlogRefactorTextChangeFactory {
    DocManager fDocManager = new DocManager();

    public List<TextChange> makeConnectExistingTextChanges(RefactorInputWrapper wrapper) {
        List<TextChange> moduleChanges = this.makeModuleTextChanges(wrapper);
        TextChange tchg = this.makeConnectUsingExistingPortTextChange((RfInstance)wrapper.getTargetElement(), wrapper.getNewElementName(), wrapper.getConnectionExpression());
        if (tchg == null) {
            DVTLogger.INSTANCE.logDebug("Creating Use existing port for " + wrapper.getTargetElement().getName() + " failed");
            return Collections.emptyList();
        }
        moduleChanges.add(tchg);
        return moduleChanges;
    }

    public TextChange makeConnectUsingExistingPortTextChange(RfInstance instance, String portName, String newSignal) {
        try {
            TextChange ch;
            VlogRefactorRfInstanceWrapper refactorInstance = new VlogRefactorRfInstanceWrapper(instance);
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile((RfNamedElement)refactorInstance.getInstance()));
            if (document == null) {
                return null;
            }
            boolean found = false;
            int insertOffset = -1;
            String toInsert = "";
            if (refactorInstance.hasPortConnections()) {
                if (refactorInstance.hasNamedPortConnections()) {
                    IRfPortElement existingPort = refactorInstance.getPortByName(portName);
                    if (existingPort != null) {
                        found = true;
                    }
                    if (found && existingPort != null) {
                        Set<TCConnSignal> portConnections = refactorInstance.getConnectionsByPort(existingPort);
                        toInsert = newSignal;
                        if (portConnections == null) {
                            toInsert = ", ." + portName + "(" + newSignal + ")";
                            insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)refactorInstance.getInstance().getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
                        } else if (portConnections.isEmpty()) {
                            int existingPortOffset = refactorInstance.getNamedPortConnectionOffsetByName(portName);
                            insertOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)existingPortOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning") + 1;
                        }
                    } else {
                        toInsert = ", ." + portName + "(" + newSignal + ")";
                        insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)refactorInstance.getInstance().getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
                    }
                } else {
                    IRfNamedElement type = instance.getAssociatedType();
                    RfModule mod = null;
                    if (type instanceof RfModule) {
                        mod = (RfModule)type;
                    } else if (type instanceof RfListType) {
                        mod = (RfModule)((RfListType)type).getAssociatedType();
                    } else {
                        throw new RuntimeException("Internal error: Unknown instance container type");
                    }
                    if (mod == null) {
                        return null;
                    }
                    IRfPortElement existingPort = refactorInstance.getPortByName(portName);
                    if (existingPort != null) {
                        found = true;
                    }
                    if (found && existingPort != null) {
                        toInsert = newSignal;
                        Set<TCConnSignal> portConnections = refactorInstance.getConnectionsByPort(existingPort);
                        if (portConnections == null) {
                            int foundPortIndex;
                            insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)refactorInstance.getInstance().getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
                            int instanceLastPortIndex = refactorInstance.getLastPortConnectionIndex();
                            if (instanceLastPortIndex > (foundPortIndex = refactorInstance.getPortIndexByName(portName))) {
                                return null;
                            }
                            int i = instanceLastPortIndex;
                            while (i < foundPortIndex) {
                                toInsert = ", " + toInsert;
                                ++i;
                            }
                        } else if (portConnections.isEmpty()) {
                            toInsert = " " + toInsert;
                            insertOffset = refactorInstance.getOrderPortConnectionOffsetByName(portName) + 1;
                        } else {
                            insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)refactorInstance.getInstance().getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
                        }
                    } else {
                        toInsert = ", " + newSignal;
                        insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)refactorInstance.getInstance().getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
                    }
                }
            } else {
                toInsert = "." + portName + "(" + newSignal + ")";
                insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)refactorInstance.getInstance().getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
            }
            if (insertOffset < 0) {
                throw new RuntimeException("Internal error: bad parsing in addInstancePortConnectionSignal");
            }
            TextChange textChange = ch = new TextChange((IFile)refactorInstance.getInstance().getFileAdapter(), insertOffset, 0, toInsert);
            return textChange;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    public List<TextChange> makeModuleTextChanges(RefactorInputWrapper changeWrapper) {
        TextChange parameterChange;
        ArrayList<TextChange> result = new ArrayList<TextChange>();
        if (!(changeWrapper.getTargetElement() instanceof RfModule)) {
            return result;
        }
        RfModule module = (RfModule)changeWrapper.getTargetElement();
        if (changeWrapper.getRefactorOperation() == RefactorDesignElementOperation.ADD_WIRE) {
            String wireType = String.valueOf(changeWrapper.getType()) + " " + (changeWrapper.getWidth().isEmpty() ? "" : String.valueOf(VlogRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"[", (String)"]")) + " ");
            String wireText = String.valueOf(changeWrapper.getDirection()) + " " + wireType + changeWrapper.getNewElementName() + ";";
            TextChange wireChange = this.makeWireTextChange((RfNamedElement)changeWrapper.getTargetElement(), wireText);
            if (wireChange != null) {
                result.add(wireChange);
            }
        } else if (changeWrapper.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT) {
            if (module.isNonAnsi()) {
                TextChange nonAnsiModulePortChange = this.makeNonAnsiPortTextChange(module, changeWrapper.getNewElementName());
                if (nonAnsiModulePortChange != null) {
                    result.add(nonAnsiModulePortChange);
                }
                String wireType = String.valueOf(changeWrapper.getType()) + " " + (changeWrapper.getWidth().isEmpty() ? "" : String.valueOf(VlogRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"[", (String)"]")) + " ");
                String wireText = String.valueOf(changeWrapper.getDirection()) + " " + wireType + changeWrapper.getNewElementName() + ";";
                TextChange nonAnsiPortDeclarationChange = this.makeWireTextChange(module, wireText);
                if (nonAnsiPortDeclarationChange != null) {
                    result.add(nonAnsiPortDeclarationChange);
                }
            } else {
                String width = VlogRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"[", (String)"]");
                TextChange ansiModulePortChange = this.makeAnsiPortTextChange(module, changeWrapper.getNewElementName(), changeWrapper.getDirection(), changeWrapper.getType(), width);
                if (ansiModulePortChange != null) {
                    result.add(ansiModulePortChange);
                }
            }
        } else if (changeWrapper.getRefactorOperation() == RefactorDesignElementOperation.ADD_GENERIC && (parameterChange = this.makeParameterTextChange(module, changeWrapper)) != null) {
            result.add(parameterChange);
        }
        return result;
    }

    public List<TextChange> makeInstancesTextChanges(List<RefactorInputWrapper> wrappers, IProgressMonitor pm) {
        ArrayList<TextChange> textChanges = new ArrayList<TextChange>();
        HashMap<IFile, ArrayList<RfNamedElement>> instancesPerFile = new HashMap<IFile, ArrayList<RfNamedElement>>();
        for (RefactorInputWrapper change : wrappers) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFile file = (IFile)change.getTargetElement().getFileAdapter();
            ArrayList<RfNamedElement> val = (ArrayList<RfNamedElement>)instancesPerFile.get(change.getTargetElement().getFileAdapter());
            if (val == null) {
                val = new ArrayList<RfNamedElement>();
                instancesPerFile.put(file, val);
            }
            val.add((RfNamedElement)change.getTargetElement());
        }
        for (List instances : instancesPerFile.values()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<VlogRefactorRfInstanceWrapper> refactorInstaces = VlogRefactorDesignElementUtils.getInstancesWrappers(instances);
            for (VlogRefactorRfInstanceWrapper refactorInstance : refactorInstaces) {
                TextChange textChg;
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                RefactorInputWrapper change = this.getChangeByTarget(wrappers, refactorInstance.getInstance());
                if (change == null) continue;
                if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT) {
                    textChg = this.computeInstancePortConnectionChange(refactorInstance, Arrays.asList(change));
                    if (textChg == null) continue;
                    textChanges.add(textChg);
                    continue;
                }
                if (change.getRefactorOperation() != RefactorDesignElementOperation.ADD_GENERIC || (textChg = this.computeInstanceParameterValueChange(refactorInstance, change.getNewElementName(), change.getConnectionExpression())) == null) continue;
                textChanges.add(textChg);
            }
        }
        return textChanges;
    }

    public List<TextChange> makeMultiplePortsInstancesTextChanges(Map<IRfInstanceElement, List<RefactorInputWrapper>> changeWrapperByInstance, IProgressMonitor pm) {
        ArrayList<TextChange> textChanges = new ArrayList<TextChange>();
        Map<IFile, List<RfNamedElement>> instancesPerFile = this.computeInstancesUsingInstanceMapPerFile(changeWrapperByInstance.keySet(), pm);
        for (List<RfNamedElement> instances : instancesPerFile.values()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<VlogRefactorRfInstanceWrapper> refactorInstaces = VlogRefactorDesignElementUtils.getInstancesWrappers(instances);
            for (VlogRefactorRfInstanceWrapper refactorInstance : refactorInstaces) {
                TextChange textChg;
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                List<RefactorInputWrapper> changes = this.getChangesByTarget(changeWrapperByInstance.get(refactorInstance.getInstance()), refactorInstance.getInstance());
                if (changes.isEmpty() || (textChg = this.computeInstancePortConnectionChange(refactorInstance, changes)) == null) continue;
                textChanges.add(textChg);
            }
        }
        return textChanges;
    }

    private Map<IFile, List<RfNamedElement>> computeInstancesUsingInstanceMapPerFile(Set<IRfInstanceElement> instances, IProgressMonitor pm) {
        HashMap<IFile, List<RfNamedElement>> instancesPerFile = new HashMap<IFile, List<RfNamedElement>>();
        for (IRfInstanceElement instance : instances) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!(instance instanceof RfInstance)) continue;
            IFile file = (IFile)instance.getFileAdapter();
            ArrayList<RfInstance> val = (ArrayList<RfInstance>)instancesPerFile.get(file);
            if (val == null) {
                val = new ArrayList<RfInstance>();
                instancesPerFile.put(file, val);
            }
            val.add((RfInstance)instance);
        }
        return instancesPerFile;
    }

    private TextChange makeParameterTextChange(IRfDesignElement module, RefactorInputWrapper changeWrapper) {
        try {
            IRfNamedElement lastParameter = null;
            List moduleParameters = module.getLocalParameters();
            if (moduleParameters != null) {
                for (IRfNamedElement parameter : moduleParameters) {
                    if (parameter instanceof RfField && (!((RfField)parameter).isInParameterPortList() || !((RfField)parameter).isParameter())) continue;
                    lastParameter = parameter;
                }
            }
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile((RfNamedElement)module));
            int insertOffset = -1;
            String parameterWidth = changeWrapper.getWidth().isEmpty() ? "" : VlogRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"[", (String)"]");
            String parameterDefaultValue = changeWrapper.getGenericDefaultValue().isEmpty() ? "" : " = " + changeWrapper.getGenericDefaultValue();
            String parameterType = changeWrapper.getType().isEmpty() ? "" : String.valueOf(changeWrapper.getType()) + " ";
            String parameterString = String.valueOf(parameterType) + (parameterWidth.isEmpty() ? "" : String.valueOf(parameterWidth) + " ") + changeWrapper.getNewElementName() + parameterDefaultValue;
            String indent = "";
            IRfDefElement declaration = module.getDeclaration();
            if (declaration == null) {
                return null;
            }
            int moduleStartOffset = declaration.getStartOffset();
            int moduleEndOffset = declaration.getEndOffset();
            if (moduleStartOffset < 0 || moduleEndOffset < 0) {
                return null;
            }
            if (lastParameter != null) {
                insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)lastParameter.getDeclaration().getEndOffset(), (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
                if (insertOffset < 0) {
                    return null;
                }
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)lastParameter.getDeclaration().getStartOffset(), (int)moduleStartOffset, (String)"__vlog_partitioning");
                String insertionOffsetIndent = VlogRefactorDesignElementUtils.getBracketIndent((int)(insertOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                parameterString = String.valueOf(indent) + ", " + parameterString + insertionOffsetIndent;
            } else {
                int hashOffset = DVTDocumentUtils.getCharOffset((char)'#', (int)moduleStartOffset, (boolean)true, (int)Math.min(moduleEndOffset - moduleStartOffset, 100), (IDocument)document, (String)"__vlog_partitioning");
                if (hashOffset < 0) {
                    insertOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, module.getName(), moduleStartOffset, moduleEndOffset, false);
                    String newLine = System.lineSeparator();
                    indent = DVTDocumentUtils.getIndent((int)moduleStartOffset, (IDocument)document);
                    parameterString = String.valueOf(indent) + " #(" + parameterString + ") " + newLine;
                } else {
                    insertOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)moduleStartOffset, (boolean)true, (int)moduleEndOffset, (IDocument)document, (String)"__vlog_partitioning") + 1;
                }
            }
            TextChange textChange = new TextChange((IFile)module.getFileAdapter(), insertOffset, 0, parameterString);
            return textChange;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    private TextChange makeAnsiPortTextChange(RfNamedElement module, String portName, String direction, String type, String width) {
        return this.computeModulePortChangeInternal(module, portName, direction, type, width, true);
    }

    private TextChange makeNonAnsiPortTextChange(RfNamedElement module, String portName) {
        return this.computeModulePortChangeInternal(module, portName, "", "", "", false);
    }

    private TextChange computeModulePortChangeInternal(RfNamedElement module, String portName, String direction, String type, String width, boolean isAnsi) {
        try {
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile(module));
            if (document == null) {
                return null;
            }
            List<RfPort> modulePorts = module.getPortsWithPrefix("", 2);
            int semicolonOffset = this.getSemiColonOffset(module, document);
            if (modulePorts.isEmpty()) {
                TextChange ch;
                int bracketOffset = this.computeModulePortOffset(module, document);
                boolean hasBrackets = false;
                if (bracketOffset > -1 && bracketOffset < document.getLength() && semicolonOffset > -1 && semicolonOffset < document.getLength() && bracketOffset < semicolonOffset) {
                    hasBrackets = true;
                }
                int insertionOffset = hasBrackets ? bracketOffset + 1 : semicolonOffset;
                StringBuilder portConnectionText = new StringBuilder();
                portConnectionText.append(hasBrackets ? "" : "(").append(String.valueOf(direction) + " " + type + " ").append(width.isEmpty() ? "" : String.valueOf(width) + " ").append(portName).append(hasBrackets ? "" : ")");
                TextChange textChange = ch = new TextChange((IFile)module.getFileAdapter(), insertionOffset, 0, portConnectionText.toString());
                return textChange;
            }
            int insertionOffset = DVTDocumentUtils.getCharOffset((char)')', (int)semicolonOffset, (boolean)false, (int)1000, (IDocument)document, (String)"__vlog_partitioning") - 1;
            int lastPortOffset = modulePorts.get(modulePorts.size() - 1).getStartOffset();
            if (insertionOffset < 0 || lastPortOffset < 0) {
                return null;
            }
            String indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)lastPortOffset, (int)module.getStartOffset(), (String)"__vlog_partitioning");
            String insertionOffsetIndent = VlogRefactorDesignElementUtils.getBracketIndent((int)(insertionOffset - 1), (IDocument)document);
            indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
            StringBuilder portConnectionText = new StringBuilder();
            if (isAnsi) {
                portConnectionText.append(String.valueOf(indent) + ", ").append(String.valueOf(direction) + " " + type + " ").append(width.isEmpty() ? "" : String.valueOf(width) + " ").append(portName).append(insertionOffsetIndent);
            } else {
                portConnectionText.append(String.valueOf(indent) + ", " + portName).append(insertionOffsetIndent);
            }
            if (insertionOffset < 0 || insertionOffset > document.getLength()) {
                return null;
            }
            TextChange textChange = new TextChange((IFile)module.getFileAdapter(), insertionOffset, 0, portConnectionText.toString());
            return textChange;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logDebug(e.toString());
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
        return null;
    }

    private int computeModulePortOffset(RfNamedElement module, IDocument document) throws BadLocationException, BadPartitioningException {
        List<RfPort> modulePorts = module.getPortsWithPrefix("", 2);
        if (modulePorts.isEmpty()) {
            RfAssociatedType lastParameter = null;
            List<RfField> moduleParameters = module.getLocalParameters(128);
            for (RfField parameter : moduleParameters) {
                boolean isInParameterPortList = parameter.isInParameterPortList();
                if (!isInParameterPortList) continue;
                lastParameter = parameter;
            }
            int bracketOffset = -1;
            int lastParameterOffset = -1;
            if (lastParameter != null) {
                lastParameterOffset = lastParameter.getDeclaration().getEndOffset();
                if (lastParameterOffset < 0) {
                    return -1;
                }
                int parameterBracketOffset = DVTDocumentUtils.getCharOffset((char)')', (int)lastParameterOffset, (boolean)true, (int)1000, (IDocument)document, (String)"__vlog_partitioning");
                if (parameterBracketOffset < 0) {
                    return -1;
                }
                bracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)parameterBracketOffset, (boolean)true, (int)1000, (IDocument)document, (String)"__vlog_partitioning");
            } else {
                int hashOffset = DVTDocumentUtils.getCharOffset((char)'#', (int)module.getStartOffset(), (boolean)true, (int)1000, (IDocument)document, (String)"__vlog_partitioning");
                if (hashOffset > 0 && hashOffset < module.getDeclaration().getEndOffset()) {
                    int parameterBracketOffset = DVTDocumentUtils.getCharOffset((char)')', (int)hashOffset, (boolean)true, (int)1000, (IDocument)document, (String)"__vlog_partitioning");
                    if (parameterBracketOffset < 0) {
                        return -1;
                    }
                    bracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)parameterBracketOffset, (boolean)true, (int)1000, (IDocument)document, (String)"__vlog_partitioning");
                } else {
                    bracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)module.getStartOffset(), (boolean)true, (int)1000, (IDocument)document, (String)"__vlog_partitioning");
                }
            }
            return bracketOffset;
        }
        return -1;
    }

    public List<TextChange> makeModulePortsTextChanges(Set<RefactorInputWrapper> changeWrappers, RfModule module, String moduleIndent) {
        try {
            TextChange nonAnsiPortDeclarationChange;
            TextChange textChg;
            ArrayList<TextChange> result = new ArrayList<TextChange>();
            StringBuilder wireText = new StringBuilder();
            StringBuilder portConnectionText = new StringBuilder();
            String portConnectionIndent = moduleIndent;
            int insertionOffset = -1;
            String newLine = System.lineSeparator();
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile(module));
            if (document == null) {
                return null;
            }
            int semicolonOffset = this.getSemiColonOffset(module, document);
            boolean hasBrackets = false;
            int bracketOffset = -1;
            List<RfPort> modulePorts = module.getPortsWithPrefix("", 2);
            if (modulePorts.isEmpty()) {
                bracketOffset = this.computeModulePortOffset(module, document);
                if (bracketOffset > -1 && bracketOffset < document.getLength() && semicolonOffset > -1 && semicolonOffset < document.getLength() && bracketOffset < semicolonOffset) {
                    hasBrackets = true;
                }
                if (!hasBrackets) {
                    portConnectionText.append(hasBrackets ? "" : "(");
                }
                insertionOffset = hasBrackets ? bracketOffset + 1 : semicolonOffset;
            } else {
                hasBrackets = true;
                insertionOffset = DVTDocumentUtils.getCharOffset((char)')', (int)semicolonOffset, (boolean)false, (int)1000, (IDocument)document, (String)"__vlog_partitioning") - 1;
                int lastPortOffset = modulePorts.get(modulePorts.size() - 1).getStartOffset();
                portConnectionIndent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)lastPortOffset, (int)module.getStartOffset(), (String)"__vlog_partitioning");
                portConnectionIndent = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)portConnectionIndent, (String)"");
                insertionOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)(insertionOffset - 1), (boolean)false, (String)"__vlog_partitioning") + 1;
            }
            if (insertionOffset < 0 || insertionOffset > document.getLength()) {
                return null;
            }
            int index = 0;
            for (RefactorInputWrapper changeWrapper : changeWrappers) {
                if (modulePorts.isEmpty() || !module.isNonAnsi()) {
                    String width = VlogRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"[", (String)"]");
                    portConnectionText.append(index++ > 0 || !modulePorts.isEmpty() ? "," : "").append(newLine).append(portConnectionIndent).append(String.valueOf(changeWrapper.getDirection()) + " " + changeWrapper.getType() + " ").append(changeWrapper.getWidth().isEmpty() ? "" : String.valueOf(width) + " ").append(changeWrapper.getNewElementName());
                    continue;
                }
                portConnectionText.append(",").append(newLine).append(portConnectionIndent).append(changeWrapper.getNewElementName());
                String wireType = String.valueOf(changeWrapper.getType()) + " " + (changeWrapper.getWidth().isEmpty() ? "" : String.valueOf(VlogRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"[", (String)"]")) + " ");
                wireText.append(newLine).append(moduleIndent).append(changeWrapper.getDirection()).append(" ").append(wireType).append(changeWrapper.getNewElementName()).append(";");
            }
            if (!hasBrackets) {
                portConnectionText.append(moduleIndent).append(")");
            }
            TextChange textChange = textChg = insertionOffset < 0 ? null : new TextChange((IFile)module.getFileAdapter(), insertionOffset, 0, portConnectionText.toString());
            if (textChg != null) {
                result.add(textChg);
            }
            if (module.isNonAnsi() && (nonAnsiPortDeclarationChange = this.makeWireTextChange(module, wireText.toString())) != null) {
                result.add(nonAnsiPortDeclarationChange);
            }
            ArrayList<TextChange> arrayList = result;
            return arrayList;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logDebug(e.toString());
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
        return null;
    }

    public TextChange makeWireTextChange(RfNamedElement module, String blockText) {
        try {
            TextChange ch;
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile(module));
            if (document == null) {
                return null;
            }
            int insertionOffset = this.getSemiColonOffset(module, document);
            RfDefElement declaration = module.getDeclaration();
            if (module instanceof IRfDesignElement && (((IRfDesignElement)module).hasDirectiveTimeprecision() || ((IRfDesignElement)module).hasDirectiveTimeunit())) {
                insertionOffset = Utils.getInstance().computeInsertOffsetConsideringTimescale(document, insertionOffset, declaration);
            }
            if (insertionOffset < 0 || insertionOffset > document.getLength()) {
                return null;
            }
            String indent = DVTDocumentUtils.getIndent((int)module.getStartOffset(), (IDocument)document);
            String newLine = System.lineSeparator();
            blockText = String.valueOf(newLine) + indent + blockText + newLine;
            TextChange textChange = ch = new TextChange((IFile)module.getFileAdapter(), insertionOffset + 1, 0, blockText);
            return textChange;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
        return null;
    }

    private int getSemiColonOffset(RfNamedElement module, IDocument document) throws BadLocationException, BadPartitioningException {
        int endOffset;
        int initialOffset = module.getStartOffset();
        if (initialOffset >= (endOffset = module.getEndOffset())) {
            return -1;
        }
        int semicolonOffset = -1;
        String textSource = "";
        do {
            if ((semicolonOffset = DVTDocumentUtils.getCharOffset((char)';', (int)(initialOffset + 1), (boolean)true, (int)endOffset, (IDocument)document, (String)"__vlog_partitioning")) == -1) {
                return -1;
            }
            textSource = document.get(initialOffset, semicolonOffset - initialOffset);
            initialOffset = semicolonOffset;
        } while (textSource.indexOf("import") != -1);
        return semicolonOffset;
    }

    private TextChange computeInstanceParameterValueChange(VlogRefactorRfInstanceWrapper refInstance, String parameterName, String parameterValueConnection) {
        try {
            TextChange ch;
            int insertOffset = -1;
            IRfInstanceElement instance = refInstance.getInstance();
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile((RfNamedElement)instance));
            boolean hasParameterConnections = refInstance.hasParameterConnections();
            int moduleNameOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, instance.getName(), instance.getDeclaration().getStartOffset(), instance.getDeclaration().getEndOffset(), false);
            String insertText = "";
            String indent = "";
            String newLine = System.lineSeparator();
            if (hasParameterConnections) {
                insertOffset = DVTDocumentUtils.getCharOffset((char)')', (int)moduleNameOffset, (boolean)false, (int)100, (IDocument)document, (String)"__vlog_partitioning") - 1;
                if (insertOffset < 0) {
                    return null;
                }
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)refInstance.getLastParameterConnectionOffset(), (int)instance.getDeclaration().getStartOffset(), (String)"__vlog_partitioning");
                String insertionOffsetIndent = VlogRefactorDesignElementUtils.getBracketIndent((int)(insertOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                insertText = refInstance.hasNamedParameterConnections() ? String.valueOf(indent) + ", " + "." + parameterName + "(" + parameterValueConnection + ")" + insertionOffsetIndent : String.valueOf(indent) + ", " + parameterValueConnection + insertionOffsetIndent;
            } else {
                int instanceStartOffset = instance.getDeclaration().getStartOffset();
                int hashOffset = DVTDocumentUtils.getCharOffset((char)'#', (int)instanceStartOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
                indent = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)document);
                if (hashOffset < 0 || hashOffset > instance.getDeclaration().getEndOffset()) {
                    insertOffset = moduleNameOffset;
                    insertText = String.valueOf(indent) + "#(" + "." + parameterName + "(" + parameterValueConnection + ")" + ") " + newLine;
                } else {
                    insertOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)hashOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning") + 1;
                    insertText = String.valueOf(indent) + "." + parameterName + "(" + parameterValueConnection + ")";
                }
            }
            if (insertOffset < 0 || insertOffset > document.getLength()) {
                return null;
            }
            TextChange textChange = ch = new TextChange((IFile)instance.getFileAdapter(), insertOffset, 0, insertText);
            return textChange;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
        return null;
    }

    private TextChange computeInstancePortConnectionChange(VlogRefactorRfInstanceWrapper refInstance, List<RefactorInputWrapper> changes) {
        try {
            TextChange ch;
            int insertOffset = -1;
            IRfInstanceElement instance = refInstance.getInstance();
            IDocument document = this.fDocManager.getDoc(this.fDocManager.getIFile((RfNamedElement)instance));
            if (document == null) {
                return null;
            }
            boolean hasMultiplePortConnections = changes.size() > 1;
            boolean hasPortConnections = refInstance.hasPortConnections();
            boolean hasParameterConnections = refInstance.hasParameterConnections();
            int semicolonOffset = DVTDocumentUtils.getCharOffset((char)';', (int)instance.getDeclaration().getEndOffset(), (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
            int bracketOffset = DVTDocumentUtils.getCharOffset((char)')', (int)instance.getDeclaration().getEndOffset(), (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
            if (semicolonOffset < 0 || semicolonOffset > document.getLength()) {
                return null;
            }
            String indent = "";
            String newLine = System.lineSeparator();
            StringBuilder text = new StringBuilder();
            if (hasPortConnections) {
                insertOffset = bracketOffset;
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)refInstance.getLastPortConnectionOffset(), (int)instance.getDeclaration().getStartOffset(), (String)"__vlog_partitioning");
                String insertionOffsetIndent = VlogRefactorDesignElementUtils.getBracketIndent((int)(insertOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                if (insertOffset < 0) {
                    return null;
                }
                for (RefactorInputWrapper change : changes) {
                    if (refInstance.hasNamedPortConnections()) {
                        text.append(indent).append(", ").append(".").append(change.getNewElementName()).append("(").append(change.getConnectionExpression()).append(")").append(insertionOffsetIndent);
                        continue;
                    }
                    text.append(indent).append(", ").append(change.getConnectionExpression()).append(insertionOffsetIndent);
                }
            } else {
                boolean hasBracket = false;
                if (bracketOffset > -1 && bracketOffset < document.getLength() && semicolonOffset > -1 && semicolonOffset < document.getLength() && bracketOffset < semicolonOffset) {
                    hasBracket = true;
                }
                insertOffset = hasBracket ? bracketOffset : semicolonOffset;
                indent = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)document);
                String insertionOffsetIndent = VlogRefactorDesignElementUtils.getBracketIndent((int)(insertOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                int index = 0;
                for (RefactorInputWrapper change : changes) {
                    if (hasMultiplePortConnections) {
                        text.append(newLine).append(indent).append(indent);
                    }
                    if (hasParameterConnections) {
                        text.append(hasBracket ? "" : "(").append(".").append(change.getNewElementName()).append("(").append(change.getConnectionExpression()).append(")").append(hasBracket ? "" : ")");
                    } else {
                        text.append(hasBracket ? "" : "(").append(".").append(change.getNewElementName()).append("(").append(change.getConnectionExpression()).append(")").append(hasBracket ? "" : ")");
                    }
                    if (hasMultiplePortConnections) {
                        text.append(index++ < changes.size() - 1 ? "," : "");
                    }
                    if (index != changes.size()) continue;
                    text.append(newLine).append(indent);
                }
            }
            String fixme = !changes.isEmpty() && changes.get(0).isInsideBlock() ? "/*FIXME: inside block*/\n" : "";
            text.append(" ").append(fixme);
            if (insertOffset < 0 || insertOffset > document.getLength()) {
                return null;
            }
            TextChange textChange = ch = new TextChange((IFile)instance.getFileAdapter(), insertOffset, 0, text.toString());
            return textChange;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
        return null;
    }

    private RefactorInputWrapper getChangeByTarget(List<RefactorInputWrapper> changes, IRfInstanceElement target) {
        for (RefactorInputWrapper change : changes) {
            if (change.getTargetElement() != target) continue;
            return change;
        }
        return null;
    }

    private List<RefactorInputWrapper> getChangesByTarget(List<RefactorInputWrapper> changes, IRfInstanceElement target) {
        ArrayList<RefactorInputWrapper> inputWrappers = new ArrayList<RefactorInputWrapper>(1);
        for (RefactorInputWrapper change : changes) {
            if (change.getTargetElement() != target) continue;
            inputWrappers.add(change);
        }
        return inputWrappers;
    }
}

