/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.ovm2uvm;

import java.io.File;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMRefactorWizard;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMVersions;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScript;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptXMLParser;
import ro.amiq.vlogdt.ui.refactor.scripts.editor.RefactorScriptEditorDialog;

public class OVM2UVMPreferencesPage
extends UserInputWizardPage {
    public static final String NAME = "OVM to UVM Migration Preferences Page";
    private Label fVersionLabel;
    private Combo fVersionCombo;
    private OVM2UVMRefactorInfo fRefactorInfo;
    private Composite fMainComposite;
    private Button fSkipLinkedResources;
    private Button inspectButton;
    private URL fScriptUrl;

    public OVM2UVMPreferencesPage(String name, OVM2UVMRefactorInfo refactorInfo) {
        super(name);
        this.fRefactorInfo = refactorInfo;
        this.setTitle("Preferences");
        this.setDescription("Set OVM to UVM migration preferences");
    }

    public void createControl(Composite parent) {
        this.getShell().setImage(DVTImages.imageCache.getImage(DVTImages.OVM_TO_UVM));
        Composite bigPapa = new Composite(parent, 0);
        bigPapa.setLayout((Layout)new GridLayout());
        this.fMainComposite = new Composite(bigPapa, 0);
        this.fMainComposite.setLayoutData((Object)new GridData(4, 128, true, true));
        this.fMainComposite.setLayout((Layout)new GridLayout());
        this.createReplacementGroup();
        this.setControl((Control)bigPapa);
        this.updateAndValidate();
    }

    private void createReplacementGroup() {
        Group replacementGroup = new Group(this.fMainComposite, 0);
        replacementGroup.setLayout((Layout)new GridLayout(4, false));
        replacementGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        replacementGroup.setText("Replacement");
        this.fVersionLabel = new Label((Composite)replacementGroup, 0);
        this.fVersionLabel.setText("Refactor script:");
        this.fVersionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fVersionCombo = new Combo((Composite)replacementGroup, 4);
        this.fVersionCombo.setItems(OVM2UVMVersions.getVersions());
        this.fVersionCombo.select(0);
        this.fVersionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OVM2UVMPreferencesPage.this.updateAndValidate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fVersionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OVM2UVMPreferencesPage.this.updateAndValidate();
            }
        });
        Button browseCustom = new Button((Composite)replacementGroup, 0);
        browseCustom.setText("Browse...");
        browseCustom.setToolTipText("Browse for custom script");
        browseCustom.setLayoutData((Object)new GridData(16384, 4, false, true));
        browseCustom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(OVM2UVMPreferencesPage.this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.xml"});
                fileDialog.setText("Select a custom refactor script to use for OVM to UVM migration");
                fileDialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
                String path = fileDialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                DVTFileUtils.getInstance().setLastDirectory(path);
                OVM2UVMPreferencesPage.this.fVersionCombo.setText(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.inspectButton = new Button((Composite)replacementGroup, 0);
        this.inspectButton.setText("Inspect...");
        this.inspectButton.setToolTipText("Inspect script content");
        this.inspectButton.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.inspectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                new RefactorScriptEditorDialog(OVM2UVMPreferencesPage.this.getShell(), OVM2UVMPreferencesPage.this.fScriptUrl, OVM2UVMPreferencesPage.this.fRefactorInfo.getScriptRefactorInfo().getScript()).open();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.fSkipLinkedResources = new Button((Composite)replacementGroup, 32);
        this.fSkipLinkedResources.setSelection(false);
        this.fSkipLinkedResources.setText("Skip linked resources");
        this.fSkipLinkedResources.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fSkipLinkedResources.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OVM2UVMPreferencesPage.this.updateAndValidate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void updateAndValidate() {
        this.fScriptUrl = null;
        RefactorScript script = null;
        int selectionIndex = this.fVersionCombo.getSelectionIndex();
        if (selectionIndex != -1) {
            try {
                String selectedVersion = OVM2UVMVersions.getVersions()[selectionIndex];
                this.fScriptUrl = OVM2UVMVersions.getScriptURL(selectedVersion);
                script = OVM2UVMVersions.getScript(this.fScriptUrl);
            }
            catch (Exception e) {
                new MessageDialog(this.getShell(), "Internal error", MessageDialog.getDefaultImage(), "The wizard had encountered an unexpected error. Please report this problem.", 1, new String[]{"OK"}, 0).open();
                DVTLogger.INSTANCE.logError((Throwable)e);
                ((OVM2UVMRefactorWizard)this.getWizard()).getShell().close();
            }
        } else {
            try {
                this.fScriptUrl = new File(this.fVersionCombo.getText()).toURI().toURL();
                RefactorScriptXMLParser parser = RefactorScriptXMLParser.newParser(this.fScriptUrl, true);
                script = parser.load();
            }
            catch (Exception exception) {
                this.setErrorMessage("The custom refactoring script is invalid.");
            }
        }
        if (script != null) {
            this.inspectButton.setEnabled(true);
            this.fRefactorInfo.getScriptRefactorInfo().setSkipLinkedResources(this.fSkipLinkedResources.getSelection());
            this.fRefactorInfo.getScriptRefactorInfo().setScript(script);
        } else {
            this.inspectButton.setEnabled(false);
        }
    }

    public void setErrorMessage(String error) {
        this.setPageComplete(error == null);
        super.setErrorMessage(error);
    }

    public void setVisible(boolean visible) {
        this.updateAndValidate();
        super.setVisible(visible);
    }
}

