/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.ovm2uvm;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.utils.DVTRefactoringWizard;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMPreferencesPage;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring;

public class OVM2UVMRefactorWizard
extends DVTRefactoringWizard {
    private OVM2UVMRefactorInfo fRefactorInfo;
    private OVM2UVMPreferencesPage fOVM2UVMPreferencesPage;

    public OVM2UVMRefactorWizard(ScriptRefactoring refactoring, OVM2UVMRefactorInfo ovm2uvmRefactorInfo) {
        super((Refactoring)refactoring, 4);
        this.setWindowTitle("OVM to UVM Migration");
        this.setDefaultPageTitle("OVM to UVM Migration");
        this.setDefaultPageImageDescriptor(DVTImages.OVM_TO_UVM_WIZARD);
        this.fRefactorInfo = ovm2uvmRefactorInfo;
    }

    protected void addUserInputPages() {
        this.fOVM2UVMPreferencesPage = new OVM2UVMPreferencesPage("OVM to UVM Migration Preferences Page", this.fRefactorInfo);
        this.addPage((IWizardPage)this.fOVM2UVMPreferencesPage);
    }

    void fixFileMods(IProgressMonitor monitor) {
        final IFile[] files = Arrays.asList(this.fRefactorInfo.getScriptRefactorInfo().getResources()).toArray(new IFile[0]);
        DVTFileUtils.getInstance().fixFileModificationValidatorPermissions((IResource[])files, (Callable)new Callable<IStatus>(){

            @Override
            public IStatus call() throws Exception {
                return ResourcesPlugin.getWorkspace().validateEdit(files, (Object)FileModificationValidationContext.VALIDATE_PROMPT);
            }
        }, false, monitor);
    }
}

