/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.test.TestHelper;
import ro.amiq.vlogdt.ui.editor.VlogAmsEditor;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;
import ro.amiq.vlogdt.ui.search.text.FileMatch;

public class VlogRenameAcrossDesignHierarchyDelegate
extends VlogRenameDelegate {
    public VlogRenameAcrossDesignHierarchyDelegate(DVTRenameRefactorInfo info) {
        super(info, false);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        return new RefactoringStatus();
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        Collection renamedMatches;
        RefactoringStatus result = new RefactoringStatus();
        pm.setTaskName("Computing matches...");
        final IProject project = this.getRefactorInfo().getProject();
        String[] fileExtensions = null;
        try {
            fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IProject)project);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        RenameAcrossHierarchyInfo renameADHInfo = this.getRefactorInfo().getRenameADHInfo();
        FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.getRefactorInfo().getResourceSearchScope()}, (String[])fileExtensions, (boolean)false);
        IRfNamedElement element = this.getRefactorInfo().getElement();
        final HashSet allMatches = new HashSet();
        final HashMap renameMatches = new HashMap();
        IReportHitsListener<SearchHit> renameAcrossHierarchyHitsListener = new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                try {
                    ParserPath parserPath = match.getParserPath();
                    if (parserPath == null) {
                        return;
                    }
                    IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
                    if (file == null) {
                        return;
                    }
                    LineElement element = VlogRfReferencesUtils.computeLineElementHit(file, match, match.getNamedElement());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setWriteAccess(match.getAccess());
                    int matchLength = match.getMatchLength();
                    IRfInstanceElement instance = match.getInstance();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                    fileMatch.setHitType(match.getHitType());
                    fileMatch.setInstance(instance);
                    fileMatch.setIsEscaped(match.isEscaped());
                    fileMatch.setConnectedElement(match.getConnectedElement());
                    fileMatch.setLeftRightHandSideOfConnection(match.getLeftRightHandSideOfConnection());
                    if (instance != null) {
                        fileMatch.setScopeDef(instance.getDeclaration());
                    } else {
                        fileMatch.setScopeDef(RfSearchUtils.getScope((IProject)project, (ParserPath)parserPath, (int)match.getLine(), (int)match.getOffset()));
                    }
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    RfSearchUtils.addMatchesForRename((Map)renameMatches, (BaseFileMatch)fileMatch, (IFile)file);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public Set<SearchHit> getMatches() {
                return allMatches;
            }
        };
        RfSearchUtils.searchAcrossDesignHierarchy((IRfNamedElement)element, (RenameAcrossHierarchyInfo)renameADHInfo, (IReportHitsListener)renameAcrossHierarchyHitsListener, (IProject)project, (IProgressMonitor)(pm == null ? new NullProgressMonitor() : pm), (boolean)true, (boolean)true, (boolean)true);
        HashMap<IResource, Match[]> matches = new HashMap<IResource, Match[]>();
        for (Map.Entry entry : renameMatches.entrySet()) {
            matches.put((IResource)entry.getKey(), (Match[])((List)entry.getValue()).toArray(new BaseFileMatch[0]));
        }
        this.getRefactorInfo().setMatches(matches);
        if (!TestHelper.isTestMode()) {
            VlogRfGUIReferencesUtils.computeAmbiguityWarnings((RenameAcrossHierarchyInfo)renameADHInfo, (RefactoringStatus)result, (IProject)project);
            VlogRfGUIReferencesUtils.computeConflictingWarnings((RenameAcrossHierarchyInfo)renameADHInfo, (RefactoringStatus)result, (IProject)project);
        }
        if ((renamedMatches = matches.values()) == null || renamedMatches.isEmpty()) {
            return result;
        }
        HashSet<String> existingDuplicateMatches = new HashSet<String>();
        String newName = this.getRefactorInfo().getNewName();
        Collection ambiguousElements = renameADHInfo.getAmbiguityCases().values();
        for (Match[] renamedMatchesPerFile : renamedMatches) {
            if (renamedMatchesPerFile == null || renamedMatchesPerFile.length == 0) continue;
            Match[] matchArray = renamedMatchesPerFile;
            int n = renamedMatchesPerFile.length;
            int n2 = 0;
            while (n2 < n) {
                BaseFileMatch baseFileMatch;
                IRfDefElement scopeDef;
                Match match = matchArray[n2];
                if (match instanceof BaseFileMatch && (scopeDef = (baseFileMatch = (BaseFileMatch)match).getScopeDef()) != null) {
                    IRfNamedElement namedElementMatch;
                    scopeDef.getNamedElement();
                    LineElement lineElement = baseFileMatch.getLineElement();
                    if (lineElement != null && (namedElementMatch = lineElement.getNamedElement()) != null && !newName.equals(lineElement.getSearchedElement())) {
                        List candidates;
                        IStatus checkOtherElements = RfSearchUtils.getConflictingStatus((String)this.getRefactorInfo().getNewName(), (IProject)this.getRefactorInfo().getProject(), (IRfNamedElement)namedElementMatch, (IRfScopeElement)namedElementMatch.getEnclosingScope());
                        if (checkOtherElements instanceof NameConflictStatus && (candidates = ((NameConflictStatus)checkOtherElements).getCandidates()) != null && !candidates.contains(namedElementMatch)) {
                            String duplicateMessage = RfSearchUtils.getDuplicateElementsMessage((IRfNamedElement)namedElementMatch, (IProject)this.getRefactorInfo().getProject(), (List)candidates);
                            if (duplicateMessage == null || existingDuplicateMatches.contains(duplicateMessage)) {
                                baseFileMatch.setIsRenamed(false);
                            } else {
                                existingDuplicateMatches.add(duplicateMessage);
                                RefactoringStatusContext nameConflictContext = VlogRfGUIReferencesUtils.computeContext((NameConflictStatus)((NameConflictStatus)checkOtherElements));
                                if (!TestHelper.isTestMode()) {
                                    result.addWarning(duplicateMessage, nameConflictContext);
                                }
                                baseFileMatch.setIsRenamed(false);
                            }
                        } else if (baseFileMatch.isRenamed()) {
                            VlogRfGUIReferencesUtils.checkAmbiguousMatch(ambiguousElements, (BaseFileMatch)baseFileMatch);
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public void addEdit(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String newConnection, String matchString, IRegion track) {
        ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), newConnection);
        textFileChange.addEdit((TextEdit)replaceEdit, track);
        boolean sideEffectMatch = VlogRfGUIReferencesUtils.isSideEffectMatch((RenameAcrossHierarchyInfo)this.getRefactorInfo().getRenameADHInfo(), (BaseFileMatch)fileMatch);
        GroupCategorySet gcs = sideEffectMatch ? SIDE_EFFECT_MATCH : (fileMatch.isPossibleMatch() ? POTENTIAL_MATCH : GroupCategorySet.NONE);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, (TextEdit)replaceEdit, gcs));
        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
    }

    @Override
    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        DVTRenameRefactorInfo renameInfo = this.getRefactorInfo();
        Map matchesPerInstance = VlogRfReferencesUtils.getDotStarImplicitMatches((Match[])matches);
        String newName = renameInfo.getNewName();
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (match instanceof BaseFileMatch) {
                BaseFileMatch fileMatch = (BaseFileMatch)match;
                String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                LineElement lineElement = fileMatch.getLineElement();
                if (lineElement != null && !newName.equals(lineElement.getSearchedElement())) {
                    IRfInstanceElement instanceElement = fileMatch.getInstance();
                    if (instanceElement instanceof RfInstance && fileMatch.isDotStarPortConnection() || fileMatch.isImplicitPortConnection()) {
                        RfInstance instance = (RfInstance)instanceElement;
                        List matchesOfInstance = (List)matchesPerInstance.get(instance);
                        if (matchesOfInstance != null) {
                            this.renameDotStarImplicitInstanceConnection(renameInfo, matchesOfInstance, textFileChange, matchString, instance);
                            matchesPerInstance.remove(instance);
                        }
                    } else if (fileMatch.isInsideMacroCall()) {
                        InsertEdit insertEdit = VlogRfReferencesUtils.createCommentForMacroHit((BaseFileMatch)fileMatch, (DVTRenameRefactorInfo)renameInfo, (IRfNamedElement)lineElement.getNamedElement());
                        VlogRfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
                    } else if (fileMatch.isRenamed()) {
                        ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), renameInfo.getNewName(fileMatch.isEscaped()));
                        textFileChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(0, fileMatch.getLength()));
                        boolean isSideEffectMatch = VlogRfGUIReferencesUtils.isSideEffectMatch((RenameAcrossHierarchyInfo)renameInfo.getRenameADHInfo(), (BaseFileMatch)fileMatch);
                        GroupCategorySet gcs = isSideEffectMatch ? SIDE_EFFECT_MATCH : (fileMatch.isPossibleMatch() ? POTENTIAL_MATCH : GroupCategorySet.NONE);
                        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, (TextEdit)replaceEdit, gcs));
                        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public IStatus checkNewNameInternal(DVTRenameRefactorInfo refactorInfo) {
        String newName = refactorInfo.getNewName();
        String[] words = PrefConst.getVerilogKeywords(refactorInfo instanceof VlogRenameRefactorInfo && ((VlogRenameRefactorInfo)refactorInfo).getEditor() instanceof VlogAmsEditor);
        int i = 0;
        while (i < words.length) {
            if (words[i].equals(newName)) {
                return new Status(4, "ro.amiq.vlogdt", "New name is a keyword.");
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

