/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.rename;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTFileStatusContext;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegateCommon;

public class VlogRenameDelegate
extends VlogRenameDelegateCommon {
    public VlogRenameDelegate(DVTRenameRefactorInfo info, boolean useScopeInfo) {
        super(info, useScopeInfo);
    }

    public void addEdit(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String newConnection, String matchString, IRegion track) {
        ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), newConnection);
        textFileChange.addEdit((TextEdit)replaceEdit, track);
        GroupCategorySet gcs = fileMatch.isPossibleMatch() ? POTENTIAL_MATCH : GroupCategorySet.NONE;
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, (TextEdit)replaceEdit, gcs));
        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        RefactoringStatus result = new RefactoringStatus();
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        IRfNamedElement element = refactorInfo.getElement();
        if (!(element instanceof RfNamedElement)) {
            return result;
        }
        RfNamedElement namedElement = (RfNamedElement)element;
        HashMap matches = refactorInfo.getMatches();
        String newName = refactorInfo.getNewName();
        if (TestHelper.isTestMode()) {
            return result;
        }
        IStatus checkOtherElements = VlogRfReferencesUtils.checkOtherElements(newName, refactorInfo.getProject(), namedElement, namedElement.getEnclosingScope(), false);
        boolean usageErrors = false;
        for (Match[] matchesPerFile : matches.values()) {
            if (matchesPerFile == null || matchesPerFile.length == 0) continue;
            Match[] matchArray = matchesPerFile;
            int n = matchesPerFile.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus checkOtherElementsStatus;
                IRfNamedElement hitScope;
                IRfDefElement scopeDef;
                BaseFileMatch fileMatch;
                Match hit = matchArray[n2];
                if (hit instanceof BaseFileMatch && !this.skipNameConflictingMatch(fileMatch = (BaseFileMatch)hit) && (scopeDef = fileMatch.getScopeDef()) != null && (hitScope = scopeDef.getNamedElement()) != null && hitScope != element && hitScope != element.getEnclosingScope() && (checkOtherElementsStatus = VlogRfReferencesUtils.checkOtherElements(newName, refactorInfo.getProject(), namedElement, hitScope, true)) instanceof NameConflictStatus) {
                    DVTFileStatusContext fileStatusContext = RfSearchUtils.getFileStatusContext((IProject)refactorInfo.getProject(), (LanguageKind)hitScope.getLanguageKind());
                    fileStatusContext.addFileRegions(fileMatch.getFile(), (IRegion)new Region(fileMatch.getOffset(), fileMatch.getLength()));
                    NameConflictStatus nameConflicting = (NameConflictStatus)checkOtherElementsStatus;
                    IRfNamedElement conflictingNamedElement = (IRfNamedElement)nameConflicting.getCandidates().get(0);
                    result.addError(MessageFormat.format("{0} ''{1}'' is shadowed by {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingNamedElement.getKindName(), conflictingNamedElement.getFullNameLabel()), (RefactoringStatusContext)fileStatusContext);
                    usageErrors = true;
                }
                ++n2;
            }
        }
        if (!usageErrors && checkOtherElements != Status.OK_STATUS) {
            return result;
        }
        if (usageErrors && checkOtherElements instanceof NameConflictStatus) {
            List conflctingElements = ((NameConflictStatus)checkOtherElements).getCandidates();
            for (IRfNamedElement conflictingElement : conflctingElements) {
                DVTFileStatusContext fileStatusContext = RfSearchUtils.getFileStatusContext((IProject)refactorInfo.getProject(), (LanguageKind)conflictingElement.getLanguageKind());
                fileStatusContext.addFileRegions((IFile)conflictingElement.getFileAdapter(), (IRegion)new Region(conflictingElement.getDeclaration().getLabelStartOffset(), conflictingElement.getName().length()));
                result.addWarning(MessageFormat.format("{0} ''{1}'' shadows {2} ''{3}''.", VlogRfReferencesUtils.capitalize((String)namedElement.getKindName()), namedElement.getFullNameLabel(), conflictingElement.getKindName(), conflictingElement.getFullNameLabel()), (RefactoringStatusContext)fileStatusContext);
            }
        }
        return result;
    }

    @Override
    protected void addEdit(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String newConnection, String matchString, IRegion track, boolean inComments) {
        ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), newConnection);
        textFileChange.addEdit((TextEdit)replaceEdit, track);
        this.addToChangeGroup(textFileChange, fileMatch, matchString, inComments, (TextEdit)replaceEdit, SEMANTIC_CHANGES);
    }
}

