/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.rename;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.FilesAndProjectsOfScopeCalculator;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.editor.VlogAmsEditor;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameWithFileInfo;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileInfo;
import ro.amiq.vlogdt.ui.search.text.FileMatch;

public abstract class VlogRenameDelegateCommon
extends DVTRenameDelegate {
    protected VlogRenameDelegateCommon(DVTRenameRefactorInfo info, boolean useScopeInfo) {
        super(info, useScopeInfo);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        RefactoringStatus result = new RefactoringStatus();
        final IProject project = this.getRefactorInfo().getProject();
        IRfNamedElement namedElement = this.getRefactorInfo().getElement();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        String[] fileExtensions = null;
        try {
            fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
        }
        catch (CoreException coreException) {
            result.addError("Could not search for references to " + this.getRefactorInfo().getOldSignature());
            return result;
        }
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.getRefactorInfo().getResourceSearchScope()}, (String[])fileExtensions, (boolean)false);
        FilesAndProjectsOfScopeCalculator calculator = this.useScopeInfo() ? new FilesAndProjectsOfScopeCalculator((TextSearchScope)searchScope) : new FilesAndProjectsOfScopeCalculator(null);
        final HashMap renameMatches = new HashMap();
        final HashSet allMatches = new HashSet();
        IReportHitsListener<SearchHit> renameAcrossHierarchyHitsListener = new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                try {
                    ParserPath parserPath = match.getParserPath();
                    IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
                    if (file == null) {
                        return;
                    }
                    LineElement element = VlogRfReferencesUtils.computeLineElementHit(file, match, match.getNamedElement());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setWriteAccess(match.getAccess());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                    fileMatch.setHitType(match.getHitType());
                    fileMatch.setInstance(match.getInstance());
                    fileMatch.setIsEscaped(match.isEscaped());
                    fileMatch.setConnectedElement(match.getConnectedElement());
                    fileMatch.setLeftRightHandSideOfConnection(match.getLeftRightHandSideOfConnection());
                    fileMatch.setIsInsideHierarchicalAccess(match.isInsideHierarchicalAccess());
                    fileMatch.setIsDeclarationHit(match.isDeclarationHit());
                    fileMatch.setIsElaborationHit(match.isElaborationHit());
                    fileMatch.setIsInsideComment(match.isCommentHit());
                    fileMatch.setHid(match.getHid());
                    if (match.getInstance() != null) {
                        fileMatch.setScopeDef(match.getInstance().getDeclaration());
                    } else {
                        fileMatch.setScopeDef(RfSearchUtils.getScope((IProject)project, (ParserPath)parserPath, (int)match.getLine(), (int)match.getOffset()));
                    }
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    RfSearchUtils.addMatchesForRename((Map)renameMatches, (BaseFileMatch)fileMatch, (IFile)file);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public Set<SearchHit> getMatches() {
                return allMatches;
            }
        };
        HashMap<IResource, Match[]> matches = new HashMap<IResource, Match[]>();
        Map filesMap = calculator.getFilesMap();
        IProgressMonitor monitor = pm == null ? new NullProgressMonitor() : pm;
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles((Map)filesMap), monitor);
        boolean searchVlogDisableHitInsideMacroArgument = PrefConst.getSearchVlogDisableMacroCallArgumentDetection();
        RfSearchUtils.computeReferences((IReportHitsListener)renameAcrossHierarchyHitsListener, (IProject)project, (IRfNamedElement)namedElement, (IHidEvaluator)RfTypesResolver.create((IRfScopeElement)namedElement, namedElement.getRfProject(), 8), (String)namedElement.getName(), (IProgressMonitor)monitor, (Map)filesMap, (FileSynchedAndAvailableManager)fileManager, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)searchVlogDisableHitInsideMacroArgument);
        for (Map.Entry entry : renameMatches.entrySet()) {
            matches.put((IResource)entry.getKey(), (Match[])((List)entry.getValue()).toArray(new BaseFileMatch[0]));
        }
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        refactorInfo.setMatches(matches);
        if (!(refactorInfo instanceof VlogRenameWithFileInfo)) {
            return result;
        }
        VlogRenameWithFileInfo infoWrapper = (VlogRenameWithFileInfo)refactorInfo;
        VlogRenameFileInfo renameFileInfo = infoWrapper.getRenameFileInfo();
        if (renameFileInfo.getStatus().getSeverity() == 4) {
            return result;
        }
        renameFileInfo.computeMatches();
        if (renameFileInfo.getStatus().getSeverity() == 4) {
            return result;
        }
        if (TestHelper.isTestMode()) {
            infoWrapper.computeNameValidation();
        }
        return result;
    }

    public IStatus checkNewNameInternal(DVTRenameRefactorInfo refactorInfo) {
        String newName = refactorInfo.getNewName();
        boolean isKeyWord = VlogRfReferencesUtils.isKeyWordNewName(newName, refactorInfo instanceof VlogRenameRefactorInfo && ((VlogRenameRefactorInfo)refactorInfo).getEditor() instanceof VlogAmsEditor);
        if (isKeyWord) {
            return new Status(4, "ro.amiq.vlogdt", MessageFormat.format("New name{0} is a keyword.", ""));
        }
        IRfNamedElement namedElement = refactorInfo.getElement();
        if (namedElement == null) {
            return Status.CANCEL_STATUS;
        }
        IRfScopeElement declarationEnclosingScope = namedElement.getEnclosingScope();
        if (!(declarationEnclosingScope instanceof IRfNamedElement)) {
            return Status.OK_STATUS;
        }
        IProject project = refactorInfo.getProject();
        HashMap matches = refactorInfo.getMatches();
        IStatus checkOtherElementsStatus = VlogRfReferencesUtils.checkOtherElements(newName, project, namedElement, (IRfNamedElement)namedElement.getEnclosingScope(), false);
        IStatus checkAllOccurrencesOfRenamedElementStatus = this.checkAllOccurrencesOfRenamedElement(newName, project, namedElement, matches);
        if (checkAllOccurrencesOfRenamedElementStatus != Status.OK_STATUS && checkOtherElementsStatus != Status.OK_STATUS) {
            return checkAllOccurrencesOfRenamedElementStatus;
        }
        if (checkOtherElementsStatus != Status.OK_STATUS) {
            if (!(checkOtherElementsStatus instanceof NameConflictStatus)) {
                return checkOtherElementsStatus;
            }
            NameConflictStatus status = (NameConflictStatus)checkOtherElementsStatus;
            IRfNamedElement conflictingElement = (IRfNamedElement)status.getCandidates().get(0);
            if (VlogRfReferencesUtils.isInEnclosingScope(namedElement, conflictingElement)) {
                return checkOtherElementsStatus;
            }
        }
        return checkAllOccurrencesOfRenamedElementStatus;
    }

    protected IStatus checkAllOccurrencesOfRenamedElement(String newName, IProject project, IRfNamedElement namedElement, HashMap<IResource, Match[]> matches) {
        if (matches == null || matches.isEmpty()) {
            return Status.OK_STATUS;
        }
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (!(enclosingScope instanceof IRfNamedElement)) {
            return Status.OK_STATUS;
        }
        for (Match[] matchesPerFile : matches.values()) {
            if (matchesPerFile == null || matchesPerFile.length == 0) continue;
            Match[] matchArray = matchesPerFile;
            int n = matchesPerFile.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus checkOtherElementsStatus;
                IRfNamedElement hitScope;
                IRfDefElement scopeDef;
                BaseFileMatch fileMatch;
                Match match = matchArray[n2];
                if (match instanceof BaseFileMatch && !this.skipNameConflictingMatch(fileMatch = (BaseFileMatch)match) && (scopeDef = fileMatch.getScopeDef()) != null && (hitScope = scopeDef.getNamedElement()) != namedElement.getEnclosingScope() && hitScope != namedElement && (checkOtherElementsStatus = VlogRfReferencesUtils.checkOtherElements(newName, project, namedElement, hitScope, true)) instanceof NameConflictStatus) {
                    return new Status(4, "ro.amiq.vlogdt", "The rename operation results in name conflicts.");
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    protected boolean skipNameConflictingMatch(BaseFileMatch fileMatch) {
        return fileMatch.isInsideHierarchicalAccess() || fileMatch.isDeclarationHit() || fileMatch.isPossibleMatch();
    }

    public DVTTextFileChange createTextEdit(IFile file, CompositeChange rootChange) {
        VlogTextFileChange textFileChange = this.getTextFileChange(file);
        textFileChange.setEdit((TextEdit)new MultiTextEdit());
        rootChange.add((Change)textFileChange);
        return textFileChange;
    }

    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        VlogRenameRefactorInfo renameInfo = (VlogRenameRefactorInfo)this.getRefactorInfo();
        Map matchesPerInstance = VlogRfReferencesUtils.getDotStarImplicitMatches((Match[])matches);
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (match instanceof BaseFileMatch) {
                BaseFileMatch fileMatch = (BaseFileMatch)match;
                String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                IRfInstanceElement instanceElement = fileMatch.getInstance();
                if (instanceElement instanceof RfInstance && fileMatch.isDotStarPortConnection() || fileMatch.isImplicitPortConnection()) {
                    RfInstance instance = (RfInstance)instanceElement;
                    List matchesOfInstance = (List)matchesPerInstance.get(instance);
                    if (matchesOfInstance != null) {
                        this.renameDotStarImplicitInstanceConnection(renameInfo, matchesOfInstance, textFileChange, matchString, instanceElement);
                        matchesPerInstance.remove(instance);
                    }
                } else if (fileMatch.isInsideMacroCall()) {
                    InsertEdit insertEdit = VlogRfReferencesUtils.createCommentForMacroHit((BaseFileMatch)fileMatch, (DVTRenameRefactorInfo)renameInfo, (IRfNamedElement)this.getRefactorInfo().getElement());
                    RfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
                } else {
                    this.addEdit(textFileChange, fileMatch, this.getRefactorInfo().getNewName(fileMatch.isEscaped()), matchString, (IRegion)new Region(0, fileMatch.getLength()), inComments);
                }
            }
            ++n2;
        }
    }

    protected VlogTextFileChange getTextFileChange(IFile file) {
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        if (!(refactorInfo instanceof VlogRenameWithFileInfo)) {
            return this.getDefaultTextFileChange(file);
        }
        VlogRenameWithFileInfo infoWrapper = (VlogRenameWithFileInfo)refactorInfo;
        VlogRenameFileInfo renameFileInfo = infoWrapper.getRenameFileInfo();
        if (renameFileInfo == null || !renameFileInfo.getOldFileResource().equals((Object)file) || !infoWrapper.isNameValidated()) {
            return this.getDefaultTextFileChange(file);
        }
        return new VlogTextFileChange(file.getName(), file, renameFileInfo.getNewFileResource());
    }

    private VlogTextFileChange getDefaultTextFileChange(IFile file) {
        return new VlogTextFileChange(file.getName(), file);
    }

    protected abstract void addEdit(DVTTextFileChange var1, BaseFileMatch var2, String var3, String var4, IRegion var5, boolean var6);
}

