/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.rename;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.ui.search.text.FileMatch;

public abstract class VlogRenameRefactorInfoCommon
extends DVTRenameRefactorInfo {
    protected IRfNamedElementAndScope fNamedElementAndScope;
    protected ITextEditor fEditor;

    public VlogRenameRefactorInfoCommon(IProject project, IRfNamedElementAndScope namedElement, ITextEditor editor) {
        super(project);
        this.fNamedElementAndScope = namedElement;
        this.fEditor = editor;
    }

    public ITextEditor getEditor() {
        return this.fEditor;
    }

    public String getOldName() {
        IRfNamedElement element = this.getElement();
        if (element == null) {
            return "";
        }
        String oldName = element.getName();
        if (element.isEscaped()) {
            oldName = "\\" + oldName;
        }
        return oldName;
    }

    public String getOldSignature() {
        IRfNamedElement namedElement = this.fNamedElementAndScope.getIRfNamedElement();
        String oldSingnature = namedElement.getSignature();
        if (oldSingnature != null) {
            return DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)oldSingnature, (String)" ");
        }
        if (namedElement instanceof RfNamedActionBlock) {
            return this.getOldName();
        }
        return null;
    }

    public boolean hasPotentialMatches() {
        if (this.getMatches() == null) {
            return false;
        }
        Iterator iterator = this.getMatches().values().iterator();
        while (iterator.hasNext()) {
            Match[] fileMatches;
            Match[] matchArray = fileMatches = (Match[])iterator.next();
            int n = fileMatches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof FileMatch && ((FileMatch)match).isPossibleMatch()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IRfNamedElementAndScope getNamedElementAndScope() {
        return this.fNamedElementAndScope;
    }

    public IRfScopeElement getScope() {
        return this.fNamedElementAndScope.getScope();
    }

    public IRfNamedElement getElement() {
        if (this.fNamedElementAndScope == null) {
            return null;
        }
        IRfNamedElement namedElement = this.fNamedElementAndScope.getIRfNamedElement();
        while (namedElement instanceof RfInstance.RfInstanceList) {
            namedElement = ((RfInstance.RfInstanceList)namedElement).getAssociatedType();
        }
        return namedElement;
    }
}

