/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileInfo;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFilePreferencesPage;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileStyledStatus;

public class VlogRenameWithFileInfo
extends VlogRenameRefactorInfo {
    private VlogRenameFileInfo renameFileInfo;
    private boolean checkboxSelected = true;
    private boolean nameValidated;

    public VlogRenameWithFileInfo(IProject project, IRfNamedElementAndScope namedElement, ITextEditor editor, IFile file) {
        super(project, namedElement, editor);
        this.renameFileInfo = new VlogRenameFileInfo(file, false);
    }

    @NotNull
    public VlogRenameFileInfo getRenameFileInfo() {
        return this.renameFileInfo;
    }

    public boolean isCheckboxAvailable() {
        return this.getRenameFileInfo().getStatus().isOK();
    }

    public boolean isCheckboxSelected() {
        return this.checkboxSelected;
    }

    public void setCheckboxSelected(boolean checkboxSelected) {
        this.checkboxSelected = checkboxSelected;
    }

    public boolean shouldPerformValidations() {
        return this.isCheckboxAvailable() && this.isCheckboxSelected();
    }

    public boolean isNameValidated() {
        return this.nameValidated;
    }

    public void setNewName(String newName) {
        super.setNewName(newName);
        if (!this.isCheckboxAvailable()) {
            return;
        }
        String extension = this.renameFileInfo.getOldFullPath().getFileExtension();
        if (extension != null) {
            newName = String.valueOf(newName) + "." + extension;
        }
        this.renameFileInfo.setNewName(newName);
    }

    public VlogRenameFileStyledStatus computeNameValidation() {
        this.nameValidated = false;
        VlogRenameFileInfo vlogRenameFileInfo = this.getRenameFileInfo();
        if (vlogRenameFileInfo == null) {
            return null;
        }
        IStatus initialStatus = this.renameFileInfo.getStatus();
        if (!initialStatus.isOK()) {
            return new VlogRenameFileStyledStatus(initialStatus.getSeverity(), initialStatus.getMessage());
        }
        if (!this.shouldPerformValidations()) {
            return null;
        }
        VlogRenameFileStyledStatus status = VlogRenameFilePreferencesPage.checkNewName(null, vlogRenameFileInfo);
        if (!status.isOK()) {
            return status;
        }
        this.nameValidated = true;
        return new VlogRenameFileStyledStatus();
    }
}

