/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.rename;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameWithFileInfo;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFilePreferencesPage;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileStyledStatus;

public class VlogRenameWithFilePreferencesPage
extends DVTRenamePreferencesPage {
    private static final String RENAME_FILE_LABEL = "Update file name";
    private static final String INFO_TEXT_FORMAT = "Unable to update file name: %s";
    private Composite parentComposite;
    private Button renameFileCheckbox;
    private Composite infoComposite;
    private Label infoImage;
    private Label infoText;
    private StyledText extraInfoBox;
    private VlogRenameWithFileInfo infoWrapper;

    public VlogRenameWithFilePreferencesPage(String name, VlogRenameWithFileInfo infoWrapper, DVTEditor dvtEditor) {
        super(name, (DVTRenameRefactorInfo)infoWrapper, dvtEditor);
        if (infoWrapper == null) {
            throw new IllegalArgumentException();
        }
        this.infoWrapper = infoWrapper;
    }

    public void fillInWithOtherButtons(Composite parentComposite) {
        this.parentComposite = parentComposite;
        this.createExtraInfoBox();
        this.createCheckBox();
        this.createInfo();
        this.centerShell();
        this.manageControl((Control)this.extraInfoBox, false);
        this.manageControl((Control)this.infoComposite, false);
        this.manageControl((Control)this.renameFileCheckbox, false);
        super.fillInWithOtherButtons(parentComposite);
    }

    private void createCheckBox() {
        this.renameFileCheckbox = new Button(this.parentComposite, 32);
        this.renameFileCheckbox.setText(RENAME_FILE_LABEL);
        this.renameFileCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                VlogRenameWithFilePreferencesPage.this.infoWrapper.setCheckboxSelected(VlogRenameWithFilePreferencesPage.this.renameFileCheckbox.getSelection());
                VlogRenameWithFilePreferencesPage.this.updateAndValidate();
            }
        });
        this.renameFileCheckbox.setSelection(true);
        GridDataFactory.fillDefaults().applyTo((Control)this.renameFileCheckbox);
    }

    private void createInfo() {
        this.infoComposite = new Composite(this.parentComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.infoComposite);
        GridDataFactory.fillDefaults().applyTo((Control)this.infoComposite);
        this.infoImage = new Label(this.infoComposite, 0);
        this.infoImage.setImage(RefactoringPluginImages.get((String)"org.eclipse.ltk.ui.refactoringinfo_obj.png"));
        GridDataFactory.fillDefaults().align(1, 1).hint(this.infoImage.computeSize(-1, -1)).applyTo((Control)this.infoImage);
        this.infoText = new Label(this.infoComposite, 64);
        GridDataFactory.fillDefaults().align(1, 1).hint(-1, this.infoText.computeSize((int)-1, (int)-1).y).applyTo((Control)this.infoText);
    }

    private void createExtraInfoBox() {
        this.extraInfoBox = new StyledText(this.parentComposite, 2632);
        DVTColorUtil.INSTANCE.setBackground((Control)this.extraInfoBox, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"), true);
        this.extraInfoBox.getVerticalBar().setVisible(false);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.extraInfoBox);
    }

    private void showCheckbox() {
        Point oldSize = this.getShell().getSize();
        this.manageControl((Control)this.extraInfoBox, false);
        this.manageControl((Control)this.infoComposite, false);
        this.manageControl((Control)this.renameFileCheckbox, true);
        this.resizeShell(oldSize);
    }

    private void showInfo(VlogRenameFileStyledStatus status) {
        Point oldSize = this.getShell().getSize();
        this.infoText.setText(String.format(INFO_TEXT_FORMAT, status.getMessage()));
        this.manageControl((Control)this.infoComposite, true);
        this.manageControl((Control)this.renameFileCheckbox, false);
        String additionalInfo = status.getAdditionalInfo();
        if (!additionalInfo.isEmpty()) {
            this.extraInfoBox.setText(additionalInfo);
            this.extraInfoBox.setStyleRanges(status.getStyledRanges());
            this.manageControl((Control)this.extraInfoBox, true);
        } else {
            this.manageControl((Control)this.extraInfoBox, false);
        }
        this.resizeShell(oldSize);
    }

    private void manageControl(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    private void resizeShell(Point oldSize) {
        SashForm sashForm = this.findSashForm(this.parentComposite.getParent());
        if (sashForm != null) {
            this.manageControl((Control)sashForm, false);
        }
        this.getShell().pack(true);
        this.parentComposite.layout(true);
        if (sashForm != null) {
            this.manageControl((Control)sashForm, true);
        }
        Point newSize = this.getShell().getSize();
        this.getShell().setMinimumSize(newSize);
        int xDisplacement = (oldSize.x - newSize.x) / 2;
        int yDisplacement = (oldSize.y - newSize.y) / 2;
        Point currentLocation = this.getShell().getLocation();
        int xLocation = currentLocation.x + xDisplacement;
        int yLocation = currentLocation.y + yDisplacement;
        this.getShell().setLocation(xLocation, yLocation);
    }

    private SashForm findSashForm(Composite currentComposite) {
        if (currentComposite == null) {
            return null;
        }
        if (currentComposite instanceof SashForm) {
            return (SashForm)currentComposite;
        }
        Control[] controlArray = currentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            SashForm possibleSash;
            Control child = controlArray[n2];
            if (child instanceof Composite && (possibleSash = this.findSashForm((Composite)child)) != null) {
                return possibleSash;
            }
            ++n2;
        }
        return null;
    }

    private void centerShell() {
        Rectangle bounds = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        Rectangle size = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - size.width) / 2;
        int y = bounds.y + (bounds.height - size.height) / 2;
        this.getShell().setLocation(x, y);
    }

    protected IStatus checkNewName() {
        IStatus status = super.checkNewName();
        if (!status.isOK() || !this.infoWrapper.shouldPerformValidations()) {
            return status;
        }
        return VlogRenameFilePreferencesPage.checkForWarnings(this.infoWrapper.getRenameFileInfo(), null);
    }

    protected void onQuickNameCheckFail() {
        if (this.infoWrapper.isCheckboxAvailable()) {
            this.showCheckbox();
            return;
        }
        IStatus renameFileInitialStatus = this.infoWrapper.getRenameFileInfo().getStatus();
        if (!renameFileInitialStatus.isOK()) {
            this.showInfo(new VlogRenameFileStyledStatus(renameFileInitialStatus.getSeverity(), renameFileInitialStatus.getMessage()));
        }
    }

    protected void onJobStart() {
        VlogRenameFileStyledStatus status = this.infoWrapper.computeNameValidation();
        if (status == null) {
            return;
        }
        Display.getDefault().syncExec(() -> {
            if (status.isOK()) {
                this.showCheckbox();
            } else {
                this.showInfo(status);
            }
        });
    }
}

