/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMatch;

public abstract class RenameFileBCMatch
extends RenameFileMatch {
    protected static final String INSIDE_BUILD_CONFIG = "Build Configuration";
    protected static final GroupCategory INSIDE_BUILD_CONFIG_MATCH = new GroupCategory("ro.amiq.dvt.ui.refactor.INSIDE_BUILD_CONFIG_MATCH", "Build Configuration", "Build Configuration");
    protected BuildConfigProperty property;
    protected Invocation invocation;

    public RenameFileBCMatch(IFile includingFile, IRegion region, BuildConfigProperty property, Invocation invocation) {
        super(includingFile, region);
        this.property = property;
        this.invocation = invocation;
    }

    protected String computeBCNewName(String projectRelativeNewName) {
        String compilationRoot;
        String minusFCompilationRoot;
        IPath fileLocation;
        IPath absoluteNewPath = this.computeBCAbsoluteNewPath(projectRelativeNewName);
        if (absoluteNewPath == null) {
            return null;
        }
        if (Path.fromOSString((String)this.getToken().getText()).isAbsolute()) {
            return absoluteNewPath.toOSString();
        }
        ArrayList<IPath> relativePaths = new ArrayList<IPath>();
        if (IBuildConfigParserConstants.IUS_TOOLS.contains(this.invocation.getState().fToolCompat) && (fileLocation = this.getElement().getLocation()) != null) {
            relativePaths.add(fileLocation.removeLastSegments(1));
        }
        if ((minusFCompilationRoot = this.invocation.getState().fCompilationRootConsideringMinusF) != null) {
            relativePaths.add(Path.fromOSString((String)minusFCompilationRoot));
        }
        if ((compilationRoot = this.invocation.getState().fCompilationRoot) != null) {
            relativePaths.add(Path.fromOSString((String)compilationRoot));
        }
        IPath originalPath = this.getOriginalFilePath();
        for (IPath relativePath : relativePaths) {
            if (!relativePath.isPrefixOf(originalPath)) continue;
            return absoluteNewPath.makeRelativeTo(relativePath).toOSString();
        }
        return absoluteNewPath.toOSString();
    }

    private IPath computeBCAbsoluteNewPath(String projectRelativeNewName) {
        String lastSegment = Path.fromOSString((String)projectRelativeNewName).lastSegment();
        if (lastSegment == null) {
            return null;
        }
        return this.getOriginalFilePath().removeLastSegments(1).append(lastSegment);
    }

    private IPath getOriginalFilePath() {
        return Path.fromOSString((String)this.property.getValue());
    }

    protected BuildConfigToken getToken() {
        return (BuildConfigToken)this.property.getAttribute("ATTRIBUTE_TOKEN");
    }
}

