/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMatch;

public class RenameFileMacroMatch
extends RenameFileMatch {
    private static final String COMMENT_FORMAT = " FIXME: Rename '%s' to '%s' inside the macro call below";
    private String oldNameLastSegment;

    public RenameFileMacroMatch(IFile includingFile, IRegion region, String oldNameLastSegment) {
        super(includingFile, region);
        this.oldNameLastSegment = oldNameLastSegment;
    }

    @Override
    public CategorizedTextEditGroup getChange(VlogTextFileChange textFileChange, String projectRelativeNewName, String newName) {
        GroupCategorySet gcs = new GroupCategorySet(RfGUIReferencesUtils.INSIDE_MACRO_CALL_MATCH);
        String lastSegment = Path.fromOSString((String)projectRelativeNewName).lastSegment();
        String comment = String.format(COMMENT_FORMAT, this.oldNameLastSegment, lastSegment);
        String editGroupName = String.format("%s [%s]", this.getElement().getName(), "Inside Macro");
        InsertEdit insertEdit = RfReferencesUtils.createComment((IFile)this.getElement(), (int)this.getOffset(), (String)comment, null);
        textFileChange.addEdit((TextEdit)insertEdit);
        return new CategorizedTextEditGroup(editGroupName, (TextEdit)insertEdit, gcs);
    }
}

