/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileBCMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMacroMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMatch;

public class RenameFileMatchResult {
    private Map<IFile, Set<RenameFileMatch>> matches = new HashMap<IFile, Set<RenameFileMatch>>();
    private int matchCount;
    private boolean hasMacroMatches;
    private boolean hasBCMatches;

    public void addMatch(RenameFileMatch match) {
        IFile file = match.getElement();
        Set<RenameFileMatch> fileMatches = this.matches.get(file);
        if (fileMatches == null) {
            fileMatches = new HashSet<RenameFileMatch>();
            this.matches.put(file, fileMatches);
        }
        if (fileMatches.add(match)) {
            ++this.matchCount;
        }
        if (match instanceof RenameFileMacroMatch) {
            this.hasMacroMatches = true;
        }
        if (match instanceof RenameFileBCMatch) {
            this.hasBCMatches = true;
        }
    }

    public Map<IFile, Set<RenameFileMatch>> getMatches() {
        return this.matches;
    }

    public int getMatchCount() {
        return this.matchCount;
    }

    public boolean hasMatches() {
        return this.matchCount != 0;
    }

    public boolean hasMacroMatches() {
        return this.hasMacroMatches;
    }

    public boolean hasBCMatches() {
        return this.hasBCMatches;
    }
}

