/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.ide.ResourceSelectionUtil;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileWorkspaceAction;

public class VlogRefactorActionGroup
extends ActionGroup {
    private VlogRenameFileWorkspaceAction renameAction;
    private MoveResourceAction moveAction;
    private Shell shell;

    public VlogRefactorActionGroup(Shell aShell) {
        this.shell = aShell;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean anyResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        if (anyResourceSelected) {
            this.moveAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.insertAfter(this.moveAction.getId(), (IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return VlogRefactorActionGroup.this.shell;
            }
        };
        this.moveAction = new MoveResourceAction(sp);
        this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
        this.renameAction = new VlogRenameFileWorkspaceAction(sp);
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

