/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileBCEnvvarMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileBCRegularMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileBCWildcardMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMacroMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMatchResult;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileRegularMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileInfoCommon;

public class VlogRenameFileInfo
extends VlogRenameFileInfoCommon {
    private RenameFileMatchResult matchResult = new RenameFileMatchResult();

    public VlogRenameFileInfo() {
    }

    public VlogRenameFileInfo(IFile file) {
        super(file, false);
        this.computeMatches();
    }

    public VlogRenameFileInfo(IFile file, boolean computeMatches) {
        super(file, false);
        if (computeMatches) {
            this.computeMatches();
        }
    }

    public RenameFileMatchResult getMatchResult() {
        return this.matchResult;
    }

    public VlogRenameFileInfo reverse() {
        VlogRenameFileInfo newInfo = new VlogRenameFileInfo();
        newInfo.oldParserPath = this.getNewParserPath();
        newInfo.oldFileResource = this.getNewFileResource();
        newInfo.oldProjectRelativePath = this.getNewProjectRelativePath();
        newInfo.oldLocation = this.getNewLocation();
        newInfo.oldFullPath = this.getNewFullPath();
        newInfo.oldSystemFile = this.getNewSystemFile();
        newInfo.oldName = this.getNewName();
        newInfo.newName = this.getOldName();
        newInfo.project = this.project;
        newInfo.rfProject = this.rfProject;
        newInfo.fileInstances = this.fileInstances;
        newInfo.matchResult = this.matchResult;
        newInfo.status = this.status;
        return newInfo;
    }

    public IFile[] getAffectedFiles() {
        return (IFile[])this.getMatchResult().getMatches().keySet().stream().toArray(IFile[]::new);
    }

    @Override
    protected void addBCRegularMatch(IFile includingFile, IRegion region, BuildConfigProperty fileProperty, Invocation invocation) {
        this.matchResult.addMatch(new RenameFileBCRegularMatch(includingFile, region, fileProperty, invocation));
    }

    @Override
    protected void addBCWildcardMatch(IFile includingFile, IRegion region, BuildConfigProperty fileProperty, Invocation invocation) {
        this.matchResult.addMatch(new RenameFileBCWildcardMatch(includingFile, region, fileProperty, invocation));
    }

    @Override
    protected void addBCEnvvarMatch(IFile includingFile, IRegion region, BuildConfigProperty fileProperty, Invocation invocation) {
        this.matchResult.addMatch(new RenameFileBCEnvvarMatch(includingFile, region, fileProperty, invocation));
    }

    @Override
    protected void addRegularFileMatch(IFile includingFile, IRegion properFileNameRegion) {
        this.matchResult.addMatch(new RenameFileRegularMatch(includingFile, properFileNameRegion));
    }

    @Override
    protected void addMacroMatch(IFile includingFile, IRegion fileNameRegion, String oldName) {
        this.matchResult.addMatch(new RenameFileMacroMatch(includingFile, fileNameRegion, oldName));
    }

    @Override
    protected IPath getProjectFullPath() {
        return this.project.getFullPath();
    }
}

