/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class VlogRenameFileInfoCommon {
    public static final String TOP_FILE_ERROR_FORMAT = "'%s' is an implicit top file.";
    public static final String UNEXPECTED_ERROR = "An unexpected error has occurred.";
    protected ParserPath oldParserPath;
    protected IFile oldFileResource;
    protected IPath oldProjectRelativePath;
    protected IPath oldLocation;
    protected IPath oldFullPath;
    protected File oldSystemFile;
    protected String oldName;
    protected IProject project;
    protected RfProject rfProject;
    protected List<VlogFileInstance> fileInstances;
    protected IStatus status = Status.OK_STATUS;
    protected String cachedIncludeDirectiveNewName;
    protected String newName = "";

    protected VlogRenameFileInfoCommon(IFile file) {
        this(file, true);
    }

    protected VlogRenameFileInfoCommon(IFile file, boolean computeMatches) {
        this.oldFileResource = file;
        this.project = this.oldFileResource.getProject();
        this.oldName = this.oldFileResource.getName();
        this.oldFullPath = this.oldFileResource.getFullPath();
        this.oldProjectRelativePath = this.oldFullPath.makeRelativeTo(this.getProjectFullPath());
        this.rfProject = RfManager.getInstance().getRfProject(this.project);
        if (this.rfProject == null) {
            this.status = this.createErrorStatus(UNEXPECTED_ERROR);
            return;
        }
        this.oldLocation = this.oldFileResource.getLocation();
        if (this.oldLocation == null) {
            this.status = this.createErrorStatus(UNEXPECTED_ERROR);
            return;
        }
        this.oldSystemFile = this.oldLocation.toFile();
        this.oldParserPath = DVTFileUtils.getInstance().resource2parser((IResource)this.oldFileResource);
        if (this.oldParserPath == null) {
            this.status = this.createErrorStatus(UNEXPECTED_ERROR);
            return;
        }
        if (!computeMatches) {
            return;
        }
        this.computeMatches();
    }

    protected VlogRenameFileInfoCommon() {
    }

    public ParserPath getOldParserPath() {
        return this.oldParserPath;
    }

    public IFile getOldFileResource() {
        return this.oldFileResource;
    }

    public IPath getOldProjectRelativePath() {
        return this.oldProjectRelativePath;
    }

    public IPath getOldLocation() {
        return this.oldLocation;
    }

    public IPath getOldFullPath() {
        return this.oldFullPath;
    }

    public File getOldSystemFile() {
        return this.oldSystemFile;
    }

    public String getOldName() {
        return this.oldName;
    }

    public IProject getProject() {
        return this.project;
    }

    public RfProject getRfProject() {
        return this.rfProject;
    }

    public List<VlogFileInstance> getFileInstances() {
        return this.fileInstances;
    }

    @NotNull
    public IStatus getStatus() {
        return this.status;
    }

    public ParserPath getNewParserPath() {
        return new ParserPath(this.getNewLocation().toOSString());
    }

    public IPath getNewLocation() {
        return this.getOldLocation().removeLastSegments(1).append(this.getNewName());
    }

    public IPath getNewFullPath() {
        return this.getOldFullPath().removeLastSegments(1).append(this.getNewName());
    }

    public IPath getNewProjectRelativePath() {
        return this.getOldProjectRelativePath().removeLastSegments(1).append(this.getNewName());
    }

    public IFile getNewFileResource() {
        return this.getProject().getFile(this.getNewProjectRelativePath());
    }

    public File getNewSystemFile() {
        return this.getNewLocation().toFile();
    }

    public void setNewName(String newName) {
        this.newName = newName;
        this.cachedIncludeDirectiveNewName = null;
    }

    public String getNewName() {
        return this.newName;
    }

    public IStatus computeMatches() {
        this.status = this.addBuildConfigMatches();
        if (this.status.getSeverity() == 4) {
            return this.status;
        }
        this.status = this.addFileMatches();
        return this.status;
    }

    private IStatus addBuildConfigMatches() {
        List invocations = BuildConfigManager.getInvocations((IProject)this.project);
        if (invocations == null) {
            return this.createErrorStatus(UNEXPECTED_ERROR);
        }
        for (Invocation invocation : invocations) {
            ArrayList properties = new ArrayList();
            properties.addAll(BuildConfigManager.getTopFiles((Invocation)invocation, (LanguageKind)LanguageKind.VLOG));
            properties.addAll(BuildConfigManager.getCmdFileCalls((IProject)this.project));
            for (BuildConfigProperty fileProperty : properties) {
                IFile includingFile;
                BuildConfigToken token;
                String tokenText;
                IFile filePropertyResource = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(this.project, fileProperty.getValue());
                if (!Objects.equals(filePropertyResource, this.oldFileResource)) continue;
                if (fileProperty.hasAttribute("ATTRIBUTE_UVM_TOP_SPECIFICATION")) {
                    return this.createErrorStatus(VlogRenameFileInfoCommon.getTopFileErrorMessage(this.oldFileResource));
                }
                Object attribute = fileProperty.getAttribute("ATTRIBUTE_TOKEN");
                if (!(attribute instanceof BuildConfigToken) || (tokenText = (token = (BuildConfigToken)attribute).getText()) == null || (includingFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(this.project, token.getFilename())) == null) continue;
                Region region = new Region(token.getOffset(), tokenText.length());
                IPath tokenPath = Path.fromOSString((String)tokenText);
                if (DVTAutoLinkManager.getInstance().hasEnviromentVariable(this.project, tokenPath)) {
                    if (DVTAutoLinkManager.getInstance().hasEnviromentVariable(this.project, Path.fromOSString((String)tokenPath.lastSegment()))) {
                        return this.createErrorStatus(VlogRenameFileInfoCommon.getTopFileErrorMessage(this.oldFileResource));
                    }
                    this.addBCEnvvarMatch(includingFile, (IRegion)region, fileProperty, invocation);
                    continue;
                }
                if (fileProperty.hasAttribute("ATTRIBUTE_WILDCARD_FILE")) {
                    this.addBCWildcardMatch(includingFile, (IRegion)region, fileProperty, invocation);
                    continue;
                }
                this.addBCRegularMatch(includingFile, (IRegion)region, fileProperty, invocation);
            }
        }
        return Status.OK_STATUS;
    }

    private static String getTopFileErrorMessage(IFile file) {
        return VlogRenameFileInfoCommon.getTopFileErrorMessage(file.getName());
    }

    public static String getTopFileErrorMessage(String fileName) {
        return String.format(TOP_FILE_ERROR_FORMAT, fileName);
    }

    private IStatus addFileMatches() {
        DocumentManager docManager = new DocumentManager();
        docManager.activate();
        try {
            try {
                VlogFileInstance rootInstance = this.rfProject.getPreprocessingTable().getTopFileInstance();
                this.fileInstances = rootInstance.getFileInstances(new ParserPath(this.oldLocation.toOSString()));
                for (VlogFileInstance fileInstance : this.fileInstances) {
                    this.computeFileInstanceMatches(fileInstance, docManager, this.rfProject);
                }
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                IStatus iStatus = this.createErrorStatus(UNEXPECTED_ERROR);
                docManager.deactivate();
                return iStatus;
            }
        }
        finally {
            docManager.deactivate();
        }
        return Status.OK_STATUS;
    }

    private void computeFileInstanceMatches(VlogFileInstance fileInstance, DocumentManager docManager, RfProject rfProject) throws BadLocationException {
        int lineOffset;
        IRegion macroRegion;
        ParserPath includingParserPath = this.getIncludingParserPath(fileInstance);
        if (includingParserPath == null) {
            return;
        }
        IDocument includingDocument = docManager.getDocument(includingParserPath, this.project);
        if (includingDocument == null) {
            return;
        }
        IFile includingFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(this.project, includingParserPath.toString());
        if (includingFile == null) {
            return;
        }
        int line = fileInstance.getIncludingScope().getIncludingLine() - 1;
        if (line == includingDocument.getNumberOfLines()) {
            --line;
        }
        if ((macroRegion = RfBatchUtils.getMacroRegionAtOffset(rfProject, includingParserPath, includingDocument, lineOffset = includingDocument.getLineOffset(line), 500)) != null) {
            this.addMacroMatch(includingFile, macroRegion, this.oldName);
            return;
        }
        IRegion fileNameRegion = this.getFileNameRegion(includingDocument, lineOffset);
        String fileName = DVTDocumentUtils.getTextAtRegion((IDocument)includingDocument, (IRegion)fileNameRegion);
        if (fileName == null) {
            return;
        }
        if (fileName.startsWith("`")) {
            this.addMacroMatch(includingFile, fileNameRegion, this.oldName);
        } else {
            Region properFileNameRegion = new Region(fileNameRegion.getOffset() + 1, fileNameRegion.getLength() - 2);
            this.addRegularFileMatch(includingFile, (IRegion)properFileNameRegion);
        }
    }

    private ParserPath getIncludingParserPath(VlogFileInstance fileInstance) {
        if (fileInstance == null) {
            return null;
        }
        VlogIncludingScope includingScope = fileInstance.getIncludingScope();
        if (includingScope == null) {
            return null;
        }
        VlogFileInstance includingInstance = includingScope.getIncludingInstance();
        if (includingInstance == null) {
            return null;
        }
        return includingInstance.getParserPath();
    }

    private IRegion getFileNameRegion(IDocument includingDocument, int lineOffset) throws BadLocationException {
        int postIncludeOffset;
        int maxSearchOffset = Math.min(lineOffset + 500, includingDocument.getLength());
        int currentOffset = postIncludeOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(includingDocument, "`include", lineOffset, maxSearchOffset, false);
        while (currentOffset < maxSearchOffset && Character.isWhitespace(includingDocument.getChar(currentOffset))) {
            ++currentOffset;
        }
        int regionStart = this.getRegionStart(currentOffset, maxSearchOffset, includingDocument);
        while (currentOffset < maxSearchOffset && !Character.isWhitespace(includingDocument.getChar(currentOffset))) {
            ++currentOffset;
        }
        int regionEnd = currentOffset;
        return new Region(regionStart, regionEnd - regionStart);
    }

    private int getRegionStart(int currentOffset, int maxSearchOffset, IDocument includingDocument) throws BadLocationException {
        int offset = currentOffset;
        if (includingDocument.getChar(currentOffset) == '\"') {
            offset = currentOffset++;
            while (currentOffset < maxSearchOffset && includingDocument.getChar(currentOffset) != '\"') {
                if (includingDocument.getChar(currentOffset) == '\\' || includingDocument.getChar(currentOffset) == '/') {
                    offset = currentOffset;
                }
                ++currentOffset;
            }
        }
        return offset;
    }

    private IStatus createErrorStatus(String errorMessage) {
        return new Status(4, "ro.amiq.dvt", errorMessage);
    }

    public String computeIncludeDirectiveNewName(IProgressMonitor pm) {
        if (this.cachedIncludeDirectiveNewName != null) {
            return this.cachedIncludeDirectiveNewName;
        }
        Path originalPath = new Path(this.oldParserPath.toString());
        IPath searchedPath = (IPath)originalPath.clone();
        List invocations = BuildConfigManager.getInvocations((IProject)this.project);
        int maxSegments = 0;
        boolean pathRemoved = false;
        block0: for (Invocation invocation : invocations) {
            List incdirs = BuildConfigManager.getIncdirs((IProject)this.project, (Invocation)invocation);
            for (String incdir : incdirs) {
                int matchingSegments;
                if (pm != null && pm.isCanceled()) continue block0;
                IPath incdirPath = Path.fromOSString((String)incdir);
                if (!incdirPath.isAbsolute()) {
                    incdirPath = this.project.getLocation().append(incdirPath);
                }
                if ((matchingSegments = originalPath.matchingFirstSegments(incdirPath)) != incdirPath.segmentCount() || matchingSegments <= maxSegments) continue;
                searchedPath = originalPath.removeFirstSegments(matchingSegments);
                maxSegments = matchingSegments;
                pathRemoved = true;
            }
        }
        this.cachedIncludeDirectiveNewName = searchedPath.removeLastSegments(1).append(this.newName).toOSString();
        String device = searchedPath.getDevice();
        if (device != null && pathRemoved) {
            this.cachedIncludeDirectiveNewName = this.cachedIncludeDirectiveNewName.substring(device.length());
        }
        return this.cachedIncludeDirectiveNewName;
    }

    protected abstract void addBCRegularMatch(IFile var1, IRegion var2, BuildConfigProperty var3, Invocation var4);

    protected abstract void addBCWildcardMatch(IFile var1, IRegion var2, BuildConfigProperty var3, Invocation var4);

    protected abstract void addBCEnvvarMatch(IFile var1, IRegion var2, BuildConfigProperty var3, Invocation var4);

    protected abstract void addRegularFileMatch(IFile var1, IRegion var2);

    protected abstract void addMacroMatch(IFile var1, IRegion var2, String var3);

    protected abstract IPath getProjectFullPath();
}

