/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileInfo;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileStyledStatus;

public class VlogRenameFilePreferencesPage
extends UserInputWizardPage {
    private static final String TITLE = "Rename File Preferences Page";
    private static final String STARTING_POINT_LABEL_FORMAT = "Rename File %s";
    public static final String CONFLICTING_INCDIR_FILE_NAME_ERROR = "A file with this name is already included in an incdir.";
    public static final String MULTIPLE_BUILD_CONFIGS_WARNING = "Multiple build configurations found. Only the active configuration will be modified.";
    public static final String EXISTING_FILE_ERROR = "A resource with that name already exists.";
    public static final String INVALID_NAME_ERROR = "Invalid file name.";
    private static final int EXTRA_INFO_BOX_HINT_X = 1000;
    private static final int EXTRA_INFO_BOX_HINT_Y_LINES = 4;
    private static final Pattern INVALID_FILE_NAME_PATTERN = Pattern.compile(".*[ :/'\"\\\\].*", 32);
    private RenameCheckJob renameCheckJob = new RenameCheckJob();
    private Object FAMILY_RENAME = new Object();
    private VlogRenameFileInfo info;
    private Text textBox;
    private StyledText extraInfoBox;

    public VlogRenameFilePreferencesPage(VlogRenameFileInfo info) {
        super(TITLE);
        this.info = info;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Composite mainComposite = new Composite(composite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.fillInRenameStartingPointLabel(mainComposite);
        Label replaceLabel = new Label(mainComposite, 0);
        replaceLabel.setText("New name: ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)replaceLabel);
        this.textBox = new Text(mainComposite, 2048);
        this.textBox.setText(this.info.getOldName());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.textBox);
        this.textBox.selectAll();
        this.textBox.setFocus();
        this.textBox.addModifyListener(e -> this.updateAndValidate());
        this.extraInfoBox = new StyledText(mainComposite, 2632);
        DVTColorUtil.INSTANCE.setBackground((Control)this.extraInfoBox, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"), true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.extraInfoBox);
        this.showExtraInfoBox(false, false, false, false);
        this.centerShell();
        this.setControl((Control)composite);
        this.updateAndValidate();
    }

    private void fillInRenameStartingPointLabel(Composite mainComposite) {
        Label oldNameLabel = new Label(mainComposite, 0);
        GridData oldNameLabelGD = new GridData(4, 128, true, true);
        oldNameLabelGD.horizontalSpan = 2;
        oldNameLabel.setLayoutData((Object)oldNameLabelGD);
        oldNameLabel.setText(String.format(STARTING_POINT_LABEL_FORMAT, this.info.getOldName()));
    }

    private void updateAndValidate() {
        this.renameCheckJob.cancel();
        String currentText = this.textBox.getText();
        this.info.setNewName(currentText);
        this.resetMessages();
        IStatus status = VlogRenameFilePreferencesPage.checkForErrors(this.info, currentText);
        if (!status.isOK()) {
            this.setError(status.getMessage());
            return;
        }
        this.renameCheckJob.schedule(300L);
        AtomicBoolean forcePreview = new AtomicBoolean();
        status = VlogRenameFilePreferencesPage.checkForWarnings(this.info, forcePreview);
        if (!status.isOK()) {
            this.setWarning(status.getMessage(), forcePreview.get());
        }
    }

    public static IStatus checkForErrors(VlogRenameFileInfo renameFileInfo, String currentText) {
        if (currentText.isEmpty()) {
            return new Status(4, "ro.amiq.dvt", "You must provide a new name.");
        }
        if (currentText.equals(renameFileInfo.getOldName())) {
            return new Status(4, "ro.amiq.dvt", "New name is the same as old name.");
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkForWarnings(VlogRenameFileInfo renameFileInfo, AtomicBoolean forcePreview) {
        StringBuilder message = new StringBuilder();
        if (renameFileInfo.getMatchResult().hasMacroMatches()) {
            message.append("Found matches inside macro calls. It is mandatory to preview the changes.");
            if (forcePreview != null) {
                forcePreview.set(true);
            }
        }
        if (renameFileInfo.getMatchResult().hasBCMatches() && BuildConfigManager.getAvailableBuildConfigs((IProject)renameFileInfo.getProject()).size() > 1) {
            if (message.length() > 0) {
                message.append(System.lineSeparator());
            }
            message.append(MULTIPLE_BUILD_CONFIGS_WARNING);
        }
        if (message.length() > 0) {
            return new Status(2, "ro.amiq.dvt", message.toString());
        }
        return Status.OK_STATUS;
    }

    private void setWarning(String message, boolean forcePreview) {
        if (forcePreview) {
            ((RefactoringWizard)this.getWizard()).setForcePreviewReview(true);
            message = String.valueOf(message) + " It is mandatory to preview the changes.";
        }
        this.setMessage(message, 2);
    }

    private void resetMessages() {
        this.setMessage(null);
        this.setError(null);
    }

    private void setError(String error) {
        this.setErrorMessage(error);
        this.setPageComplete(false);
        this.showExtraInfoBox(false, true, true, false);
    }

    private void setStyledError(VlogRenameFileStyledStatus status) {
        this.setError(status.getMessage());
        String additionalInfo = status.getAdditionalInfo();
        if (additionalInfo.isEmpty()) {
            return;
        }
        boolean showScrollBar = DVTStringUtil.NEW_LINE.matcher(additionalInfo).groupCount() >= 4;
        this.extraInfoBox.setText(additionalInfo);
        this.extraInfoBox.setStyleRanges(status.getStyledRanges());
        this.showExtraInfoBox(true, true, true, showScrollBar);
    }

    private void showExtraInfoBox(boolean show, boolean resize, boolean reposition, boolean showScrollBar) {
        Point oldSize = this.getShell().getSize();
        ((GridData)this.extraInfoBox.getLayoutData()).widthHint = show ? 1000 : 0;
        ((GridData)this.extraInfoBox.getLayoutData()).heightHint = show ? 4 * this.extraInfoBox.getLineHeight() : 0;
        this.extraInfoBox.getVerticalBar().setVisible(showScrollBar);
        this.extraInfoBox.setVisible(show);
        if (resize) {
            this.extraInfoBox.getParent().layout(true);
            this.getShell().pack(true);
            this.getShell().layout(true);
            if (reposition) {
                Point newSize = this.getShell().getSize();
                int xDisplacement = (oldSize.x - newSize.x) / 2;
                int yDisplacement = (oldSize.y - newSize.y) / 2;
                Point currentLocation = this.getShell().getLocation();
                int xLocation = currentLocation.x + xDisplacement;
                int yLocation = currentLocation.y + yDisplacement;
                this.getShell().setLocation(xLocation, yLocation);
            }
        }
    }

    private void centerShell() {
        Rectangle bounds = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        Rectangle size = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - size.width) / 2;
        int y = bounds.y + (bounds.height - size.height) / 2;
        this.getShell().setLocation(x, y);
    }

    public boolean testSetText(String text) {
        if (this.textBox == null) {
            return false;
        }
        this.textBox.setText(text);
        return true;
    }

    public String testGetError() {
        String error = this.getErrorMessage();
        return error != null ? error : this.getMessage();
    }

    public boolean testPressButton(String buttonName) {
        Shell shell = this.getShell();
        if (shell == null) {
            return false;
        }
        LinkedList<Control> childrenQueue = new LinkedList<Control>();
        childrenQueue.addAll(Arrays.asList(shell.getChildren()));
        while (!childrenQueue.isEmpty()) {
            Button button;
            Object child = childrenQueue.poll();
            if (child instanceof Composite) {
                Composite compositeChild = (Composite)child;
                childrenQueue.addAll(Arrays.asList(compositeChild.getChildren()));
                continue;
            }
            if (!(child instanceof Button) || !(button = (Button)child).getText().equals(buttonName)) continue;
            Display.getDefault().asyncExec(() -> button.notifyListeners(13, new Event()));
            return true;
        }
        return false;
    }

    public static VlogRenameFileStyledStatus checkNewName(IProgressMonitor pm, VlogRenameFileInfo info) {
        if (info.getNewFileResource().exists()) {
            return new VlogRenameFileStyledStatus(4, EXISTING_FILE_ERROR);
        }
        if (INVALID_FILE_NAME_PATTERN.matcher(info.getNewName()).matches()) {
            return new VlogRenameFileStyledStatus(4, INVALID_NAME_ERROR);
        }
        IProject project = info.getProject();
        List invocations = BuildConfigManager.getInvocations((IProject)project);
        String projectRelativeNewName = info.computeIncludeDirectiveNewName(pm);
        for (Invocation invocation : invocations) {
            if (pm != null && pm.isCanceled()) {
                return new VlogRenameFileStyledStatus(8);
            }
            List incdirs = BuildConfigManager.getIncdirs((IProject)project, (Invocation)invocation);
            for (String incdir : incdirs) {
                if (pm != null && pm.isCanceled()) {
                    return new VlogRenameFileStyledStatus(8);
                }
                String properFileName = VlogRenameFilePreferencesPage.getProperFileName(String.valueOf(incdir) + projectRelativeNewName, info.getProject());
                File otherFile = new File(properFileName);
                if (!otherFile.exists()) continue;
                return VlogRenameFilePreferencesPage.getConflictingIncdirFileError(projectRelativeNewName, incdir);
            }
        }
        return new VlogRenameFileStyledStatus();
    }

    private static VlogRenameFileStyledStatus getConflictingIncdirFileError(String conflictingFile, String incdir) {
        return new VlogRenameFileStyledStatus(4, CONFLICTING_INCDIR_FILE_NAME_ERROR).append("Conflicting file:\n\t", VlogRenameFilePreferencesPage.getBoldStyleRange()).append(conflictingFile).append(System.lineSeparator()).append("Found inside incdir:\n\t", VlogRenameFilePreferencesPage.getBoldStyleRange()).append(incdir);
    }

    private static StyleRange getBoldStyleRange() {
        StyleRange styleRange = new StyleRange();
        styleRange.fontStyle = 1;
        return styleRange;
    }

    private static String getProperFileName(String fileName, IProject project) {
        String crossPlatformPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(fileName);
        return DVTUtilsCommon.INSTANCE.getFileSubstitute(project, crossPlatformPath);
    }

    private class RenameCheckJob
    extends UIJob {
        public RenameCheckJob() {
            super("RenameCheckJob");
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == VlogRenameFilePreferencesPage.this.FAMILY_RENAME;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                if (VlogRenameFilePreferencesPage.this.getErrorMessage() != null) {
                    return Status.OK_STATUS;
                }
                VlogRenameFileStyledStatus newNameStatus = VlogRenameFilePreferencesPage.checkNewName(monitor, VlogRenameFilePreferencesPage.this.info);
                if (!newNameStatus.isOK()) {
                    VlogRenameFilePreferencesPage.this.setStyledError(newNameStatus);
                } else {
                    VlogRenameFilePreferencesPage.this.setPageComplete(true);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

