/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.views.DVTQuickViewersUtil;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.renamefile.RenameFileMatch;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileInfo;

public class VlogRenameFileProcessor
extends DVTRefactoringProcessor {
    private static final String PROCESSOR_NAME = "Rename File Refactoring";
    private static final String FILE_COMPOSITE_CHANGE_NAME = "Rename File Changes";
    protected static final GroupCategorySet RENAME_FILE_CHANGES = new GroupCategorySet(new GroupCategory("ro.amiq.dvt.ui.refactor.rename.RENAME_FILE_CHANGES", "Rename file changes", "Rename file changes"));
    private VlogRenameFileInfo info;

    public VlogRenameFileProcessor(VlogRenameFileInfo info) {
        this.info = info;
    }

    public IFile[] getElements() {
        return this.info.getAffectedFiles();
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return PROCESSOR_NAME;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return VlogRenameFileProcessor.createFileRenameCompositeChange(pm, this.info, new HashMap<IFile, DVTTextFileChange>());
    }

    public static CompositeChange createFileRenameCompositeChange(IProgressMonitor pm, VlogRenameFileInfo info, Map<IFile, DVTTextFileChange> textChangesMap) {
        CompositeChange fileRenameRootChange = new CompositeChange(FILE_COMPOSITE_CHANGE_NAME);
        fileRenameRootChange.add((Change)new VlogRenameResourceChange(info));
        String projectRelativeNewName = info.computeIncludeDirectiveNewName(pm);
        try {
            for (Map.Entry<IFile, Set<RenameFileMatch>> entry : info.getMatchResult().getMatches().entrySet()) {
                if (!pm.isCanceled()) {
                    VlogTextFileChange fileChange = null;
                    if (textChangesMap.containsKey(entry.getKey())) {
                        fileChange = (VlogTextFileChange)textChangesMap.get(entry.getKey());
                    }
                    VlogRenameFileProcessor.createChangesFor(entry.getKey(), entry.getValue(), fileRenameRootChange, projectRelativeNewName, pm, fileChange, info.getNewName());
                    continue;
                }
                break;
            }
        }
        catch (CoreException | BadLocationException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return fileRenameRootChange;
    }

    private static void createChangesFor(IFile file, Set<RenameFileMatch> matches, CompositeChange rootChange, String projectRelativeNewName, IProgressMonitor pm, VlogTextFileChange textFileChange, String newName) throws CoreException, BadLocationException {
        boolean shouldCreateNewComposite;
        boolean bl = shouldCreateNewComposite = textFileChange == null;
        if (textFileChange == null) {
            textFileChange = new VlogTextFileChange(file.getName(), file);
            textFileChange.setEdit((TextEdit)new MultiTextEdit());
        }
        boolean hasChanges = false;
        for (RenameFileMatch match : matches) {
            if (pm.isCanceled()) break;
            CategorizedTextEditGroup group = match.getChange(textFileChange, projectRelativeNewName, newName);
            if (group == null) continue;
            TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)group);
            textFileChange.addTextEditChangeGroup(textEditChangeGroup);
            textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup("", RENAME_FILE_CHANGES));
            textFileChange.addTextEditChangeGroup(textEditChangeGroup);
            hasChanges = true;
        }
        if (hasChanges && shouldCreateNewComposite) {
            rootChange.add((Change)textFileChange);
        }
    }

    private static class VlogRenameResourceChange
    extends RenameResourceChange {
        private VlogRenameFileInfo info;
        private boolean readOnly;

        public VlogRenameResourceChange(VlogRenameFileInfo info) {
            super(info.getOldFullPath(), info.getNewName());
            this.info = info;
            IFile oldFileResource = info.getOldFileResource();
            this.readOnly = oldFileResource == null ? false : oldFileResource.isReadOnly();
        }

        public String getName() {
            return String.format("Rename '%s' to '%s'", this.info.getOldName(), this.info.getNewName());
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            boolean currentReadOnly;
            IFile fileToRename = this.info.getOldFileResource();
            boolean bl = currentReadOnly = fileToRename == null ? false : fileToRename.isReadOnly();
            if (currentReadOnly != this.readOnly) {
                try {
                    FieldUtils.writeField((Object)((Object)this), (String)"fReadOnly", (Object)currentReadOnly, (boolean)true);
                }
                catch (IllegalAccessException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            return super.isValid(pm);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (this.info.getOldFileResource().isLinked()) {
                this.performRelinking(pm);
            } else {
                super.perform(pm);
            }
            this.updateCompilationUnit();
            return new VlogRenameResourceChange(this.info.reverse());
        }

        private void performRelinking(IProgressMonitor pm) throws CoreException {
            DVTAutoLinkManager manager = DVTAutoLinkManager.getInstance();
            IProject project = this.info.getProject();
            IWorkspaceRunnable action = monitor -> {
                DVTAutoLinkManager.IAutoLinkOperation operation = cachedLinksMap -> {
                    manager.fastRemoveLink(project, (IResource)this.info.getOldFileResource(), cachedLinksMap);
                    Map autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)project);
                    manager.createAutoLink(project, this.info.getNewLocation(), autoLinkedRoots, cachedLinksMap, false);
                    if (!this.info.getOldSystemFile().renameTo(this.info.getNewSystemFile())) {
                        return;
                    }
                    this.info.getNewFileResource().refreshLocal(1, null);
                };
                manager.modifyWorkspaceOperation(project, VlogRenameFileProcessor.PROCESSOR_NAME, operation, false);
            };
            ResourcesPlugin.getWorkspace().run(action, pm);
        }

        private void updateCompilationUnit() {
            ParserPath oldParserPath = this.info.getOldParserPath();
            ParserPath newParserPath = this.info.getNewParserPath();
            for (VlogFileInstance fileInstance : this.info.getFileInstances()) {
                fileInstance.setFileName(newParserPath);
            }
            this.info.getRfProject().updateParserPath(oldParserPath, newParserPath);
            DVTQuickViewersUtil.updateRenameInCompileOrder((IProject)this.info.getProject());
            String qName = PropertiesManager.getSessionProperty((IResource)this.info.getOldFileResource(), (String)PropertyTypes.QN_IMPORTED_FILE);
            if (qName != null) {
                PropertiesManager.addSessionProperty((IResource)this.info.getNewFileResource(), (String)PropertyTypes.QN_IMPORTED_FILE, (String)qName);
            }
        }
    }
}

