/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;

public class VlogRenameFileStyledStatus {
    private int severity;
    private String message;
    private StringBuilder additionalInfo;
    private List<StyleRange> styledRanges;

    public VlogRenameFileStyledStatus() {
        this(0);
    }

    public VlogRenameFileStyledStatus(int severity) {
        this(severity, "");
    }

    public VlogRenameFileStyledStatus(int severity, String message) {
        this.severity = severity;
        this.message = message;
        this.additionalInfo = new StringBuilder();
        this.styledRanges = new ArrayList<StyleRange>();
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.getSeverity() == 0;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo.toString();
    }

    public StyleRange[] getStyledRanges() {
        return (StyleRange[])this.styledRanges.stream().toArray(StyleRange[]::new);
    }

    public VlogRenameFileStyledStatus append(String text, StyleRange styleRange) {
        styleRange.start = this.additionalInfo.length();
        this.additionalInfo.append(text);
        styleRange.length = this.additionalInfo.length() - styleRange.start;
        this.styledRanges.add(styleRange);
        return this;
    }

    public VlogRenameFileStyledStatus append(String text) {
        this.additionalInfo.append(text);
        return this;
    }
}

