/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalRenamedDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.RenameRefactorAction;
import ro.amiq.dvt.ui.refactor.utils.DVTRefactoringWizard;
import ro.amiq.vlogdt.model.floatingwidgets.VlogFNotificationProvider;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileInfo;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFilePreferencesPage;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileProcessor;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileRefactoring;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileWorkspaceAction;

public class VlogRenameFileWizard
extends DVTRefactoringWizard {
    private static final String DIALOG_TITLE = "Rename File Wizard";
    private VlogRenameFileInfo info;
    private VlogRenameFilePreferencesPage page;

    public VlogRenameFileWizard(VlogRenameFileInfo info) {
        super((Refactoring)new VlogRenameFileRefactoring(new VlogRenameFileProcessor(info)), 36);
        this.info = info;
        this.page = new VlogRenameFilePreferencesPage(info);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        if (!super.performFinish(false)) {
            return false;
        }
        VlogRenameFileWizard.checkFullBuild(this.info);
        return true;
    }

    public static void checkFullBuild(VlogRenameFileInfo info) {
        int matchCount = info.getMatchResult().getMatchCount();
        if (matchCount > 0 && matchCount < 50) {
            FIncrementalNotificationTracker.INSTANCE.addDirtyResource(info.getProject(), (FNotificationDirtyResource)new FIncrementalRenamedDirtyFile(info.getNewFileResource(), info.getOldFileResource(), FNotificationDirtyReason.RENAME_FILE, (DVTFNotificationProvider)VlogFNotificationProvider.getInstance()));
        }
    }

    public static void open(IFile file) {
        try {
            if (file == null) {
                return;
            }
            Map outOfSyncFilesMap = RenameRefactorAction.computeOutOfSyncFilesMap((IProject)file.getProject());
            if (!RenameRefactorAction.ensureFilesInSync((Map)outOfSyncFilesMap)) {
                return;
            }
            VlogRenameFileInfo info = new VlogRenameFileInfo(file);
            IStatus status = info.getStatus();
            if (status.getSeverity() == 4) {
                VlogRenameFileWorkspaceAction.popError(status.getMessage());
                return;
            }
            new RefactoringWizardOpenOperation((RefactoringWizard)new VlogRenameFileWizard(info)).run(VlogRenameFileWizard.getWorkbenchShell(), DIALOG_TITLE);
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static Shell getWorkbenchShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static VlogRenameFileInfo testCreateInfo(IFile file) {
        return new VlogRenameFileInfo(file);
    }

    public static VlogRenameFileWizard testCreateWizard(VlogRenameFileInfo info) {
        return new VlogRenameFileWizard(info);
    }

    public static void testOpenWizard(VlogRenameFileWizard wizard) throws InterruptedException {
        new RefactoringWizardOpenOperation((RefactoringWizard)wizard).run(VlogRenameFileWizard.getWorkbenchShell(), DIALOG_TITLE);
    }

    public boolean testSetText(String text) {
        return this.page.testSetText(text);
    }

    public String testGetError() {
        return this.page.testGetError();
    }

    public boolean testPressButton(String buttonName) {
        return this.page.testPressButton(buttonName);
    }
}

