/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamefile;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileWizard;

public class VlogRenameFileWorkspaceAction
extends WorkspaceAction {
    private static final String ERROR_POPUP_TITLE = "Unsupported Operation";
    private static final String ERROR_MULTIPLE_ELEMENTS = "Can only rename one file.";

    protected VlogRenameFileWorkspaceAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.RenameResourceAction_text);
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_progress;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    public void run() {
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() != 1) {
            VlogRenameFileWorkspaceAction.popError(ERROR_MULTIPLE_ELEMENTS);
            return;
        }
        IResource firstResource = (IResource)selectedResources.get(0);
        if (!(firstResource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)firstResource;
        VlogRenameFileWizard.open(file);
    }

    public static void popError(String message) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ERROR_POPUP_TITLE, null, message, 1, new String[]{"OK"}, 0).open());
    }
}

