/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.renamehierarchy;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.connect.DVTDesignHierarchyHook;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameProcessor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactoring;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.utils.TCConfiguration;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.renamehierarchy.RefactorRenameHierachyUserInput;

public class RefactorRenameHierarchyProcessor
extends DVTRefactoringProcessor {
    RefactorRenameHierachyUserInput userInput;

    public RefactorRenameHierarchyProcessor(RefactorRenameHierachyUserInput userInput) {
        this.userInput = userInput;
    }

    public Object[] getElements() {
        return new Object[]{"ciudat"};
    }

    public String getIdentifier() {
        return "getIdentifier";
    }

    public String getProcessorName() {
        return "VLOG Refactor Rename in Hierarchy";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    private void flattenTraceTreeChildren(TCNode root, List<TCNode> nodes) {
        for (TCNode child : root.getChildren()) {
            nodes.add(child);
            this.flattenTraceTreeChildren(child, nodes);
        }
    }

    private TCNode select(TCNode root, IRfNamedElement elem) {
        if (root.namedElement == elem) {
            return root;
        }
        for (TCNode child : root.getChildren()) {
            TCNode sel = this.select(child, elem);
            if (sel == null) continue;
            return sel;
        }
        return null;
    }

    private List<TextFileChange> getTextFileChanges(Change change) {
        Change[] vlogTextFileChanges;
        ArrayList<TextFileChange> textFileChanges = new ArrayList<TextFileChange>();
        CompositeChange compChange = (CompositeChange)change;
        Change[] changeArray = vlogTextFileChanges = compChange.getChildren();
        int n = vlogTextFileChanges.length;
        int n2 = 0;
        while (n2 < n) {
            Change vlogTextFileChangeComp = changeArray[n2];
            CompositeChange compChange2 = (CompositeChange)vlogTextFileChangeComp;
            Change[] changeArray2 = compChange2.getChildren();
            int n3 = changeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Change textFileChg = changeArray2[n4];
                TextFileChange vlogTextFileChg = (TextFileChange)textFileChg;
                textFileChanges.add(vlogTextFileChg);
                ++n4;
            }
            ++n2;
        }
        return textFileChanges;
    }

    private Change makeRenameChange(IRfPortElement port, IProgressMonitor pm) {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        IRfDefElement decl = port.getDeclaration();
        RfWNamedElementAndScope namedElementAndScope = new RfWNamedElementAndScope((IRfNamedElement)port, (IRfScope)decl);
        VlogRenameRefactorInfo refactorInfo = new VlogRenameRefactorInfo(project, namedElementAndScope, null);
        refactorInfo.setNewName(this.userInput.newName);
        VlogRenameDelegate delegate = new VlogRenameDelegate(refactorInfo, false);
        DVTRenameProcessor processor = new DVTRenameProcessor((DVTRenameDelegate)delegate);
        DVTRenameRefactoring refactoring = new DVTRenameRefactoring(processor);
        IStatus status = delegate.checkNewName();
        if (status.getSeverity() != 0) {
            String m = "Rename in Hierarchy error for " + this.userInput.newName + ": " + status.getMessage();
            DVTLogger.INSTANCE.logDebug(m);
            throw new RuntimeException(m);
        }
        Change chg = null;
        try {
            refactoring.checkInitialConditions(pm);
            refactoring.checkFinalConditions(pm);
            chg = refactoring.createChange(pm);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return chg;
    }

    boolean overlappingConflict(ReplaceEdit r1, ReplaceEdit r2) {
        int offset1 = r1.getOffset();
        int length1 = r1.getLength();
        int offset2 = r2.getOffset();
        int length2 = r2.getLength();
        if (offset1 == offset2 && length1 == 0 && length2 == 0) {
            return false;
        }
        if (offset1 + length1 <= offset2) {
            return false;
        }
        return offset2 + length2 > offset1;
    }

    boolean isDotStarReplaceEdit(ReplaceEdit r) {
        return r.getText().startsWith(".*");
    }

    boolean isImplicitReplaceEdit(ReplaceEdit r) {
        return !this.isDotStarReplaceEdit(r);
    }

    List<ReplaceEdit> fixDotStarAndImplicitConflicts(List<ReplaceEdit> reditsList) {
        ArrayList<Pair> conflicts = new ArrayList<Pair>();
        int i = 0;
        while (i < reditsList.size() - 1) {
            int j = i + 1;
            while (j < reditsList.size()) {
                ReplaceEdit r2;
                ReplaceEdit r1 = reditsList.get(i);
                if (this.overlappingConflict(r1, r2 = reditsList.get(j))) {
                    conflicts.add(new Pair(r1, r2));
                }
                ++j;
            }
            ++i;
        }
        for (Pair p : conflicts) {
            reditsList.remove(p.r1);
            reditsList.remove(p.r2);
        }
        for (Pair p : conflicts) {
            if (!this.isImplicitReplaceEdit(p.r1)) continue;
            reditsList.add(new ReplaceEdit(p.r1.getOffset(), p.r1.getLength(), this.userInput.newName));
        }
        return reditsList;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IRfNamedElement rootElem = (IRfNamedElement)DVTDesignHierarchyHook.elementWrapperRoot.getRfElement();
        HashMap dummyPortMap = new HashMap();
        IRfSingleLangProject rfProject = rootElem.getRfProject();
        ElementPath dhTopElementPath = null;
        TCNode traceInstanceTreeRoot = TCUtils.makeDesignHierarchyElabMode((IRfSingleLangProject)rfProject, dhTopElementPath, dummyPortMap);
        TCNode selectedTraceNode = this.select(traceInstanceTreeRoot, this.userInput.instance);
        TCPathChain causedBy = new TCPathChain();
        try {
            EnumSet<TCConfiguration> options = EnumSet.allOf(TCConfiguration.class);
            TCUtils.traceSignalInFullHierarchy((TCNode)selectedTraceNode, (IRfPortElement)this.userInput.port, (TCPathChain)causedBy, options, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CanceledTraceException canceledTraceException) {
            return null;
        }
        ArrayList<TCNode> listTraceNodes = new ArrayList<TCNode>();
        listTraceNodes.add(traceInstanceTreeRoot);
        this.flattenTraceTreeChildren(traceInstanceTreeRoot, listTraceNodes);
        HashSet<IRfPortElement> collectedHotports = new HashSet<IRfPortElement>();
        for (TCNode traceNode : listTraceNodes) {
            Set hotPorts = traceNode.getHotPorts();
            if (!hotPorts.iterator().hasNext()) continue;
            IRfPortElement iRfPortElement = (IRfPortElement)hotPorts.iterator().next();
            collectedHotports.add(iRfPortElement);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (IRfPortElement hotport : collectedHotports) {
            if (hotport instanceof DummyPort) continue;
            Change change = this.makeRenameChange(hotport, pm);
            if (change == null) {
                return null;
            }
            changes.add(change);
        }
        HashMap<IFile, ArrayList<TextFileChange>> changesPerFiles = new HashMap<IFile, ArrayList<TextFileChange>>();
        int i = 0;
        while (i < changes.size()) {
            Change change = (Change)changes.get(i);
            List<TextFileChange> list = this.getTextFileChanges(change);
            for (TextFileChange textFileChange : list) {
                IFile file = textFileChange.getFile();
                ArrayList<TextFileChange> changesPerFile = (ArrayList<TextFileChange>)changesPerFiles.get(file);
                if (changesPerFile == null) {
                    changesPerFile = new ArrayList<TextFileChange>();
                    changesPerFiles.put(file, changesPerFile);
                }
                changesPerFile.add(textFileChange);
            }
            ++i;
        }
        ArrayList<VlogTextFileChange> masterTextFileChanges = new ArrayList<VlogTextFileChange>();
        for (Map.Entry entry : changesPerFiles.entrySet()) {
            VlogTextFileChange bigTxc = new VlogTextFileChange("change", (IFile)entry.getKey());
            MultiTextEdit bigMte = new MultiTextEdit();
            List<ReplaceEdit> redits = new ArrayList<ReplaceEdit>();
            List textFileChanges = (List)entry.getValue();
            for (TextFileChange textFileChange : textFileChanges) {
                TextEdit[] tes;
                MultiTextEdit mte = (MultiTextEdit)textFileChange.getEdit();
                TextEdit[] textEditArray = tes = mte.getChildren();
                int n = tes.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit te = textEditArray[n2];
                    TextEdit deepCopy = te.copy();
                    redits.add((ReplaceEdit)deepCopy);
                    ++n2;
                }
            }
            redits = this.fixDotStarAndImplicitConflicts(redits);
            for (ReplaceEdit redit : redits) {
                bigMte.addChild((TextEdit)redit);
            }
            bigTxc.setEdit((TextEdit)bigMte);
            masterTextFileChanges.add(bigTxc);
        }
        CompositeChange compositeChange = new CompositeChange("all changes");
        for (TextFileChange textFileChange : masterTextFileChanges) {
            compositeChange.add((Change)textFileChange);
        }
        return compositeChange;
    }

    static class Pair {
        ReplaceEdit r1;
        ReplaceEdit r2;

        public Pair(ReplaceEdit r1, ReplaceEdit r2) {
            this.r1 = r1;
            this.r2 = r2;
        }
    }
}

