/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.ui.refactor.scripts.ApplyTo;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptValidationException;

public class AdnotateRefactorItem
extends BaseRefactorItem {
    public static final String ADNOTATE = "add-comment";
    public StringMatcher fElementCommentMatcher;
    public boolean fElementCommentMatchPositive;
    public StringMatcher fElementPathMatcher;
    public String fElement;
    public String fComment;
    public ApplyTo fApplyTo = ApplyTo.BOTH;

    @Override
    protected String getAction() {
        return ADNOTATE;
    }

    @Override
    public Node getXMLNode(Document document) {
        Node parent = super.getXMLNode(document);
        Element elem = document.createElement("item");
        elem.setAttribute("element", this.fElement);
        elem.setAttribute("comment", this.fComment);
        parent.appendChild(elem);
        return parent;
    }

    public static AdnotateRefactorItem makeItem(Element xmlElem) throws RefactorScriptValidationException {
        AdnotateRefactorItem result;
        block21: {
            result = new AdnotateRefactorItem();
            String element = AdnotateRefactorItem.getAttribute(xmlElem, "element");
            String elementFullName = result.fElement = AdnotateRefactorItem.getAttribute(xmlElem, "element-full-name");
            if (element != null && elementFullName != null) {
                throw new RefactorScriptValidationException("Only one attribute may be specified (element is deprecated): element, element-full-name");
            }
            if (elementFullName != null) {
                result.fElement = elementFullName;
            } else if (element != null) {
                result.fElement = element;
            }
            result.fComment = AdnotateRefactorItem.getAttribute(xmlElem, "comment");
            String applyTo = AdnotateRefactorItem.getAttribute(xmlElem, "apply-to");
            if (applyTo == null) break block21;
            switch (applyTo) {
                case "declaration": {
                    result.fApplyTo = ApplyTo.DECLARATIONS;
                    break;
                }
                case "usages": {
                    result.fApplyTo = ApplyTo.USAGES;
                    break;
                }
                default: {
                    result.fApplyTo = ApplyTo.BOTH;
                }
            }
        }
        String matchNot = AdnotateRefactorItem.getAttribute(xmlElem, "element-comment-matches-not");
        String match = AdnotateRefactorItem.getAttribute(xmlElem, "element-comment-matches");
        if (match != null && matchNot != null) {
            throw new RefactorScriptValidationException("Only one attribute may be specified: element-comment-matches-not, element-comment-matches");
        }
        if (match != null) {
            result.fElementCommentMatcher = new StringMatcher(match, false, false);
            result.fElementCommentMatchPositive = true;
        } else if (matchNot != null) {
            result.fElementCommentMatcher = new StringMatcher(matchNot, false, false);
            result.fElementCommentMatchPositive = false;
        }
        if (result.fElement != null && result.fElementCommentMatcher != null) {
            throw new RefactorScriptValidationException("Only one attribute may be specified: element-full-name, element-comment-matches");
        }
        if (result.fElement == null && result.fElementCommentMatcher == null) {
            throw new RefactorScriptValidationException("At least one attribute must be specified: element-full-name, element-comment-matches");
        }
        String elementPathMatches = AdnotateRefactorItem.getAttribute(xmlElem, "element-path-matches");
        if (elementPathMatches != null) {
            result.fElementPathMatcher = new StringMatcher(elementPathMatches, false, false, true);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" to ");
        if (this.fElement != null) {
            result.append("'").append(this.fElement).append("'");
        } else {
            result.append(this.fElementCommentMatchPositive ? "elements matching " : "elements not matching '").append(this.fElementCommentMatcher).append("'");
        }
        result.append(" - '").append(this.fComment).append("'");
        return result.toString();
    }
}

