/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.amiq.vlogdt.ui.refactor.scripts.AdnotateRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.ChangeSignatureRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptValidationException;
import ro.amiq.vlogdt.ui.refactor.scripts.RenameRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RenameResourceRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.ReplaceRefactorItem;

public abstract class BaseRefactorItem {
    public Node getXMLNode(Document document) {
        Element elem = document.createElement("item");
        elem.setAttribute("action", this.getAction());
        return elem;
    }

    protected abstract String getAction();

    public static BaseRefactorItem makeItem(String action, Element elem) throws RefactorScriptValidationException {
        if ("add-comment".equals(action)) {
            return AdnotateRefactorItem.makeItem(elem);
        }
        if ("change-signature".equals(action)) {
            return ChangeSignatureRefactorItem.makeItem(elem);
        }
        if ("rename".equals(action)) {
            return RenameRefactorItem.makeItem(elem);
        }
        if ("replace-in-text".equals(action)) {
            return ReplaceRefactorItem.makeItem(elem);
        }
        if ("replace-in-file-name".equals(action) || "replace-in-dir-name".equals(action)) {
            return RenameResourceRefactorItem.makeItem(elem);
        }
        throw new UnsupportedOperationException();
    }

    public static String getAttribute(Element elem, String attr) {
        if (elem == null || attr == null) {
            return null;
        }
        String result = elem.getAttribute(attr);
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public String toString() {
        return "'" + this.getAction() + "'";
    }
}

