/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor2;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.VFUtils;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.refactor.scripts.RSUtils;

public class CommentMatchNECollector
implements IRfNamedElementVisitor2 {
    private IProject fProject;
    private List<RfNamedElement> fResult = new ArrayList<RfNamedElement>();
    private StringMatcher fCommentMatcher;
    private boolean fCommentPositiveMatch;
    private StringMatcher fPathMatcher;

    public CommentMatchNECollector(IProject project, StringMatcher pathMatcher, StringMatcher commentMatcher, boolean commentPositiveMatch) {
        this.fProject = project;
        this.fCommentMatcher = commentMatcher;
        this.fCommentPositiveMatch = commentPositiveMatch;
        this.fPathMatcher = pathMatcher;
    }

    public List<RfNamedElement> collect() {
        RfProject rfProject = RfManager.getInstance().getRfProject(this.fProject);
        if (rfProject == null) {
            return null;
        }
        rfProject.accept(this);
        for (VlogMacroInfo vlogMacroInfo : rfProject.getAllMacros()) {
            if (this.filter(vlogMacroInfo)) continue;
            this.fResult.add(vlogMacroInfo);
        }
        return this.fResult;
    }

    @Override
    public boolean visit(RfNamedElement namedElement) {
        if (!this.filter(namedElement)) {
            this.fResult.add(namedElement);
        }
        return !(namedElement instanceof RfFunction);
    }

    private boolean filter(RfNamedElement namedElement) {
        if (this.filterByKind(namedElement)) {
            return true;
        }
        if (this.filterByPath(namedElement)) {
            return true;
        }
        return this.filterByComment(namedElement);
    }

    private boolean filterByKind(RfNamedElement namedElement) {
        if (namedElement.isPredefined()) {
            return true;
        }
        if (namedElement instanceof VlogMacroInfo) {
            return false;
        }
        if (namedElement instanceof RfTypeAlias) {
            return false;
        }
        if (namedElement instanceof RfClass) {
            return false;
        }
        if (namedElement instanceof RfFunction) {
            return ((RfFunction)namedElement).isConstructor();
        }
        return namedElement.getClass() != RfField.class || ((RfField)namedElement).getFieldKind() != 1;
    }

    private boolean filterByPath(RfNamedElement namedElement) {
        ParserPath parserPath = RSUtils.getParserPath(namedElement);
        if (parserPath == null) {
            return true;
        }
        return !this.fPathMatcher.match(parserPath.path);
    }

    private boolean filterByComment(RfNamedElement namedElement) {
        String comment = this.getComment(namedElement);
        boolean matches = this.fCommentMatcher.match(comment);
        if (matches && this.fCommentPositiveMatch) {
            return false;
        }
        return matches || this.fCommentPositiveMatch;
    }

    private String getComment(RfNamedElement namedElement) {
        if (!(namedElement instanceof RfFunction)) {
            return namedElement.getComment();
        }
        StringBuilder comment = new StringBuilder(namedElement.getComment());
        for (RfFunction f2 : VFUtils.virtualParentsIterable((RfFunction)namedElement)) {
            comment.append(f2.getComment()).append("\n");
            if (!f2.isConstructor()) continue;
            comment.append(f2.getEnclosingScope().getComment());
        }
        return comment.toString();
    }

    @Override
    public void preVisit(RfNamedElement namedElement) throws Exception {
    }

    @Override
    public void postVisit(RfNamedElement namedElement) throws Exception {
    }

    @Override
    public boolean visitFunctionCalls() {
        return false;
    }

    @Override
    public boolean visitNonPersistent() {
        return false;
    }

    @Override
    public boolean visitEventTriggers() {
        return false;
    }
}

