/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScript;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptXMLParser1;

public abstract class RefactorScriptXMLParser {
    protected static final String TAG_REFACTOR_SCRIPT = "refactor-script";
    protected static final String ATTR_VERSION = "version";
    private URL fUrl;
    private static final String LAST_VERSION = "1";

    protected RefactorScriptXMLParser(URL url) {
        this.fUrl = url;
    }

    public abstract void save(RefactorScript var1) throws Exception;

    public abstract RefactorScript load() throws Exception;

    public URL getFile() {
        return this.fUrl;
    }

    public static RefactorScriptXMLParser newParser(URL url, boolean useLastVersion) throws Exception {
        if (useLastVersion) {
            return RefactorScriptXMLParser.newParser(url, LAST_VERSION);
        }
        String version = RefactorScriptXMLParser.detectVersion(url);
        return RefactorScriptXMLParser.newParser(url, version);
    }

    private static RefactorScriptXMLParser newParser(URL url, String version) throws Exception {
        if (LAST_VERSION.equals(version)) {
            return new RefactorScriptXMLParser1(url);
        }
        throw new IllegalArgumentException("Unknown refactor script file version " + version + ".");
    }

    private static String detectVersion(URL url) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(url.openStream());
        NodeList nodes = document.getElementsByTagName(TAG_REFACTOR_SCRIPT);
        if (nodes.getLength() < 1) {
            return null;
        }
        Element node = (Element)nodes.item(0);
        return node.getAttribute(ATTR_VERSION);
    }
}

