/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScript;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptValidationException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptXMLParser;

public class RefactorScriptXMLParser1
extends RefactorScriptXMLParser {
    public static final String VERSION_ID = "1";
    public static final String TAG_ITEM = "item";
    public static final String TAG_EXCEPTIONS = "exception";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_KIND = "kind";
    public static final String ATTR_ELEMENT = "element";
    public static final String ATTR_ELEMENT_FULL_NAME = "element-full-name";
    public static final String ATTR_ELEMENT_COMMENT_CONTAINS = "element-comment-matches";
    public static final String ATTR_ELEMENT_COMMENT_CONTAINS_NOT = "element-comment-matches-not";
    public static final String ATTR_ELEMENT_PATH_MATCHES = "element-path-matches";
    public static final String ATTR_NEWNAME = "newname";
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_SEARCH = "search";
    public static final String ATTR_REPLACEMENT = "replacement";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_NEWSIG = "newsig";
    public static final String ATTR_APPLY_TO = "apply-to";
    public static final String DECLARATION = "declaration";
    public static final String USAGES = "usages";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_SCOPE = "scope";
    public static final String ATTR_WORD = "word";

    public RefactorScriptXMLParser1(URL url) {
        super(url);
    }

    @Override
    public void save(RefactorScript script) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element elem = document.createElement("refactor-script");
        document.appendChild(elem);
        elem.setAttribute("version", VERSION_ID);
        elem.setAttribute(ATTR_NAME, script.getName());
        this.appendExceptions(script, document, elem);
        this.appendItems(script, document, elem);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(this.getFile().openConnection().getOutputStream());
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
    }

    private void appendItems(RefactorScript script, Document document, Node root) {
        List<BaseRefactorItem> refactorItems = script.getItems();
        for (BaseRefactorItem refactorItem : refactorItems) {
            root.appendChild(refactorItem.getXMLNode(document));
        }
    }

    private void appendExceptions(RefactorScript script, Document document, Node root) {
        List<RefactorScriptException> refactorExceptions = script.getExceptions();
        for (RefactorScriptException e : refactorExceptions) {
            root.appendChild(e.getXMLNode(document));
        }
    }

    @Override
    public RefactorScript load() throws Exception {
        RefactorScript script = new RefactorScript();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", true);
        factory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if ("-//DVT//refactor-script".equals(publicId)) {
                    return new InputSource(JarUtils.getFileStream((String)"refactor-script.dtd", this.getClass()));
                }
                return null;
            }
        });
        Document document = builder.parse(this.getFile().openStream());
        NodeList scriptNodes = document.getElementsByTagName("refactor-script");
        if (scriptNodes.getLength() != 1) {
            throw new RefactorScriptValidationException("Missing tag refactor-script");
        }
        script.setName(((Element)scriptNodes.item(0)).getAttribute(ATTR_NAME));
        this.loadExceptions(document, script);
        this.loadItems(document, script);
        return script;
    }

    private void loadItems(Document document, RefactorScript script) throws RefactorScriptValidationException {
        NodeList itemNodes = document.getElementsByTagName(TAG_ITEM);
        int i = 0;
        while (i < itemNodes.getLength()) {
            Element element = (Element)itemNodes.item(i);
            BaseRefactorItem item = BaseRefactorItem.makeItem(element.getAttribute(ATTR_ACTION), element);
            script.addItem(item);
            ++i;
        }
    }

    private void loadExceptions(Document document, RefactorScript script) throws RefactorScriptValidationException {
        NodeList exNodes = document.getElementsByTagName(TAG_EXCEPTIONS);
        int i = 0;
        while (i < exNodes.getLength()) {
            Element element = (Element)exNodes.item(i);
            script.addException(RefactorScriptException.makeException(element.getAttribute(ATTR_KIND), element));
            ++i;
        }
    }
}

