/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptValidationException;

public class RenameRefactorItem
extends BaseRefactorItem {
    static final String RENAME = "rename";
    String fElement;
    String fNewName;
    String fComment;

    @Override
    protected String getAction() {
        return RENAME;
    }

    @Override
    public Node getXMLNode(Document document) {
        Node parent = super.getXMLNode(document);
        Element elem = document.createElement("item");
        elem.setAttribute("element", this.fElement);
        elem.setAttribute("newname", this.fNewName);
        elem.setAttribute("comment", this.fComment);
        parent.appendChild(elem);
        return parent;
    }

    public static RenameRefactorItem makeItem(Element elem) throws RefactorScriptValidationException {
        RenameRefactorItem result = new RenameRefactorItem();
        String element = RenameRefactorItem.getAttribute(elem, "element");
        String elementFullName = RenameRefactorItem.getAttribute(elem, "element-full-name");
        if (element != null && elementFullName != null) {
            throw new RefactorScriptValidationException("Only one attribute may be specified (element is deprecated): element, element-full-name");
        }
        if (elementFullName != null) {
            result.fElement = elementFullName;
        } else if (element != null) {
            result.fElement = element;
        }
        result.fNewName = elem.getAttribute("newname");
        result.fComment = elem.getAttribute("comment");
        Assert.isTrue((result.fElement.length() != 0 ? 1 : 0) != 0);
        Assert.isTrue((result.fNewName.length() != 0 ? 1 : 0) != 0);
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getAction()) + " " + this.fElement + " to " + this.fNewName;
    }
}

