/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;

public class RenameResourceRefactorItem
extends BaseRefactorItem {
    static final String REPLACE_IN_FILE_NAME = "replace-in-file-name";
    static final String REPLACE_IN_DIR_NAME = "replace-in-dir-name";
    String fSearch;
    String fReplacement;
    int fResourceKind;

    @Override
    protected String getAction() {
        if (this.fResourceKind == 1) {
            return REPLACE_IN_FILE_NAME;
        }
        if (this.fResourceKind == 2) {
            return REPLACE_IN_DIR_NAME;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getXMLNode(Document document) {
        Node parent = super.getXMLNode(document);
        Element elem = document.createElement("item");
        elem.setAttribute("search", this.fSearch);
        elem.setAttribute("replacement", this.fReplacement);
        parent.appendChild(elem);
        return parent;
    }

    public static RenameResourceRefactorItem makeItem(Element elem) {
        RenameResourceRefactorItem result = new RenameResourceRefactorItem();
        result.fSearch = elem.getAttribute("search");
        result.fReplacement = elem.getAttribute("replacement");
        if (REPLACE_IN_DIR_NAME.equals(elem.getAttribute("action"))) {
            result.fResourceKind = 2;
        } else if (REPLACE_IN_FILE_NAME.equals(elem.getAttribute("action"))) {
            result.fResourceKind = 1;
        } else {
            throw new UnsupportedOperationException();
        }
        Assert.isTrue((result.fSearch.length() != 0 ? 1 : 0) != 0);
        Assert.isTrue((result.fReplacement.length() != 0 ? 1 : 0) != 0);
        return result;
    }
}

