/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;

public class ReplaceRefactorItem
extends BaseRefactorItem {
    static final String REPLACE = "replace-in-text";
    String fSearch;
    String fReplacement;
    private Matcher fMatcher;

    public Matcher getMatcher() {
        if (this.fMatcher == null) {
            this.fMatcher = Pattern.compile(this.fSearch).matcher("");
        }
        return this.fMatcher;
    }

    @Override
    protected String getAction() {
        return REPLACE;
    }

    @Override
    public Node getXMLNode(Document document) {
        Node parent = super.getXMLNode(document);
        Element elem = document.createElement("item");
        elem.setAttribute("search", this.fSearch);
        elem.setAttribute("replacement", this.fReplacement);
        parent.appendChild(elem);
        return parent;
    }

    public static ReplaceRefactorItem makeItem(Element elem) {
        ReplaceRefactorItem result = new ReplaceRefactorItem();
        result.fSearch = elem.getAttribute("search");
        result.fReplacement = elem.getAttribute("replacement");
        Assert.isTrue((result.fSearch.length() != 0 ? 1 : 0) != 0);
        Assert.isTrue((result.fReplacement.length() != 0 ? 1 : 0) != 0);
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getAction()) + " " + this.fSearch + " with " + this.fReplacement;
    }
}

