/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.refactor.scripts.AdnotateRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScript;
import ro.amiq.vlogdt.ui.refactor.scripts.RenameRefactorItem;

public class ScriptRefactorInfo {
    private IProject fProject;
    private RefactorScript fScript;
    private boolean fSkipLinkedResources;
    private Map<IFile, DVTTextFileChange> fTextChanges;

    public ScriptRefactorInfo(IProject project, RefactorScript script) {
        this.fProject = project;
        this.fScript = script;
    }

    public ScriptRefactorInfo(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public RefactorScript getScript() {
        return this.fScript;
    }

    public void setScript(RefactorScript script) {
        this.fScript = script;
        if (this.fProject == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.fProject);
        if (rfProject == null) {
            return;
        }
        List<RfPackage> allPkgs = rfProject.getAllPackages(true);
        boolean hasOvmPkg = false;
        for (RfPackage pkg : allPkgs) {
            if (!"ovm_pkg".equals(pkg.getName())) continue;
            hasOvmPkg = true;
        }
        if (!hasOvmPkg) {
            return;
        }
        for (BaseRefactorItem item : this.fScript.getItems()) {
            if (item instanceof AdnotateRefactorItem) {
                AdnotateRefactorItem adnotateItem = (AdnotateRefactorItem)item;
                if (adnotateItem.fElement == null || adnotateItem.fElement.startsWith("`")) continue;
                adnotateItem.fElement = "ovm_pkg::" + adnotateItem.fElement;
                continue;
            }
            if (!(item instanceof RenameRefactorItem)) continue;
            RenameRefactorItem renameItem = (RenameRefactorItem)item;
            if (renameItem.fElement == null || renameItem.fElement.startsWith("`")) continue;
            renameItem.fElement = "ovm_pkg::" + renameItem.fElement;
        }
    }

    public List<BaseRefactorItem> getItems() {
        return this.fScript.getItems();
    }

    public String getName() {
        return this.fScript.getName();
    }

    public void setSkipLinkedResources(boolean skip) {
        this.fSkipLinkedResources = skip;
    }

    public boolean isSkipLinkedResources() {
        return this.fSkipLinkedResources;
    }

    public void setTextChanges(Map<IFile, DVTTextFileChange> textChanges) {
        this.fTextChanges = textChanges;
    }

    public IResource[] getResources() {
        if (this.fTextChanges == null) {
            return null;
        }
        return this.fTextChanges.keySet().toArray(new IResource[this.fTextChanges.keySet().size()]);
    }
}

