/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.GenericWordFinder;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.refactor.RenameRefactorCompositeChange;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.scripts.AdnotateRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.ApplyTo;
import ro.amiq.vlogdt.ui.refactor.scripts.BaseRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.ChangeSignatureRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.CommentMatchNECollector;
import ro.amiq.vlogdt.ui.refactor.scripts.InsertEditInfoWrapper;
import ro.amiq.vlogdt.ui.refactor.scripts.RSCanceledException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptResourceException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptScopeException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptWordException;
import ro.amiq.vlogdt.ui.refactor.scripts.RenameRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.RenameResourceRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.ReplaceRefactorItem;
import ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactorInfo;
import ro.amiq.vlogdt.ui.search.MultipleSearchTextFileBufferManager;
import ro.amiq.vlogdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vlogdt.ui.search.SearchQueryProvider;
import ro.amiq.vlogdt.ui.search.text.FileMatch;
import ro.amiq.vlogdt.ui.search.text.FileSearchResult;

public class ScriptRefactoring
extends Refactoring {
    private static final String SW_REFSCRIPT = "REFSCRIPT";
    private static final GroupCategory ADNOTATE_CATEGORY = new GroupCategory("ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring.ADNOTATE_CATEGORY", "Add Comment", "Add Comment");
    private static final GroupCategory RENAME_CATEGORY = new GroupCategory("ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring.RENAME_CATEGORY", "Rename", "Rename");
    private static final GroupCategory REPLACE_CATEGORY = new GroupCategory("ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring.REPLACE_CATEGORY", "Replace In Text", "Replace In Text");
    private static final GroupCategory POTENTIAL_MATCH = new GroupCategory("ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring.POTENTIAL_MATCH", "Potential match", "Potential match");
    private ScriptRefactorInfo fRefactorInfo;
    private Map<IFile, DVTTextFileChange> fTextChanges;
    private RenameResourceHelper fResourceRenameHelper;
    private CompositeChange fRootChange;
    private RefactoringStatus fRefactoringStatus;
    private boolean fHasPotentialMatches;
    private List<InsertEditInfoWrapper> fAdnotateChanges = new ArrayList<InsertEditInfoWrapper>();
    public Map<IResource, Boolean> fWaivingCache = new HashMap<IResource, Boolean>();
    public Map<IResource, Boolean> fBinaryCache = new HashMap<IResource, Boolean>();

    public ScriptRefactoring(ScriptRefactorInfo info) {
        this.fRefactorInfo = info;
    }

    private boolean isWaived(IResource resource) {
        if (resource == null) {
            return true;
        }
        Boolean waived = this.fWaivingCache.get(resource);
        if (waived != null) {
            return waived;
        }
        waived = this.isWaivedInternal(resource);
        this.fWaivingCache.put(resource, waived);
        return waived;
    }

    private boolean isWaivedInternal(IResource resource) {
        if (resource instanceof IProject) {
            return true;
        }
        if ("dvt_build.log".equals(resource.getName())) {
            return true;
        }
        if (this.fRefactorInfo.isSkipLinkedResources() && resource.isLinked()) {
            return true;
        }
        for (RefactorScriptException ex : this.fRefactorInfo.getScript().getExceptions()) {
            String pathToSkip;
            if (!(ex instanceof RefactorScriptResourceException) || (pathToSkip = ((RefactorScriptResourceException)ex).getResourcePath()) == null || pathToSkip.isEmpty()) continue;
            String pathToMatchAgainst = null;
            pathToMatchAgainst = Path.fromOSString((String)pathToSkip).isAbsolute() ? resource.getLocation().toOSString() : resource.getProjectRelativePath().toOSString();
            if (!new StringMatcher(pathToSkip, false, false, false).match(pathToMatchAgainst) && !new StringMatcher(pathToSkip, false, false, false).match(ro.amiq.dvt.utils.Utils.canonicPath((String)pathToMatchAgainst))) continue;
            return true;
        }
        return false;
    }

    private boolean isWaived(IResource resource, IRegion region) {
        for (RefactorScriptException ex : this.fRefactorInfo.getScript().getExceptions()) {
            block4: {
                if (!(ex instanceof RefactorScriptScopeException) || !this.isWaived(resource, region, (RefactorScriptScopeException)ex)) break block4;
                return true;
            }
            try {
                if (!(ex instanceof RefactorScriptWordException) || !this.isWaived(resource, region, (RefactorScriptWordException)ex)) continue;
                return true;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return false;
    }

    private boolean isWaived(IResource resource, IRegion region, RefactorScriptWordException ex) throws CoreException, BadLocationException {
        if (!(resource instanceof IFile)) {
            return false;
        }
        IDocument document = RfGUIReferencesUtils.getDocument((IFile)((IFile)resource));
        if (document == null) {
            return false;
        }
        return new StringMatcher(ex.getWord(), false, false).match(GenericWordFinder.getWord((IDocument)document, (int)region.getOffset()));
    }

    /*
     * Unable to fully structure code
     */
    private boolean isWaived(IResource resource, IRegion region, RefactorScriptScopeException scopeException) throws CoreException {
        if (!(resource instanceof IFile)) {
            return false;
        }
        document = RfGUIReferencesUtils.getDocument((IFile)((IFile)resource));
        if (document == null) {
            return false;
        }
        rfProject = RfManager.getInstance().getRfProject(this.fRefactorInfo.getProject());
        if (rfProject == null) {
            return false;
        }
        element = RfUtils.getRfElement(rfProject, (IFile)resource, document, region.getOffset(), null);
        if (element == null) {
            return false;
        }
        scope = element.getScope();
        if (scope instanceof RfDefElement) {
            scope = ((RfDefElement)scope).getNamedElement();
        }
        waiverScopeString = scopeException.getScope();
        waiverScope = RfUtils.getNamedElementFromString(this.fRefactorInfo.getProject(), waiverScopeString);
        if (waiverScope != null) ** GOTO lbl23
        return false;
lbl-1000:
        // 1 sources

        {
            if (scope.equals(waiverScope)) {
                return true;
            }
            if (!((scope = scope.getEnclosingScope()) instanceof RfDefElement)) continue;
            scope = ((RfDefElement)scope).getNamedElement();
lbl23:
            // 3 sources

            ** while (scope != null)
        }
lbl24:
        // 1 sources

        return false;
    }

    private boolean isBinary(IFile file) {
        Boolean binary = this.fBinaryCache.get(file);
        if (binary != null) {
            return binary;
        }
        binary = this.isBinaryInternal(file);
        this.fBinaryCache.put((IResource)file, binary);
        return binary;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBinaryInternal(IFile file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = file.getContents();){
                byte[] buf = new byte[is.available() / 10 > 50000 ? 50000 : is.available() / 10];
                if (is.read(buf) != buf.length) {
                    return true;
                }
                String s = new String(buf);
                int i = 0;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        block6: {
            this.fHasPotentialMatches = false;
            this.fRefactoringStatus = new RefactoringStatus();
            this.fResourceRenameHelper = new RenameResourceHelper();
            for (BaseRefactorItem item : this.fRefactorInfo.getItems()) {
                if (!(item instanceof RenameResourceRefactorItem)) continue;
                this.fResourceRenameHelper.addReplace((RenameResourceRefactorItem)item);
            }
            try {
                if (this.fRefactorInfo.getProject().isSynchronized(2)) break block6;
                final boolean[] performRefresh = new boolean[1];
                if (TestHelper.isTestMode()) {
                    performRefresh[0] = true;
                } else {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            performRefresh[0] = MessageDialog.openConfirm((Shell)Utils.getActiveShell(), (String)"Resources out of sync", (String)"Some resources in this project are out of sync with the filesystem. Do you want to perform a refresh now?");
                        }
                    });
                }
                if (performRefresh[0]) {
                    this.fRefactorInfo.getProject().refreshLocal(2, pm);
                    break block6;
                }
                this.fRefactoringStatus.addFatalError("The project contains resources which are not in sync with the filesystem. Please perform a refresh!");
                return this.fRefactoringStatus;
            }
            catch (CoreException e) {
                this.fRefactoringStatus.addFatalError(e.getMessage());
                return this.fRefactoringStatus;
            }
        }
        StopWatch.start((String)SW_REFSCRIPT);
        this.createChanges(pm);
        StopWatch.stop((String)SW_REFSCRIPT).reset();
        return this.fRefactoringStatus;
    }

    private void createChanges(IProgressMonitor pm) throws CoreException {
        block32: {
            this.fRootChange = new CompositeChange(this.getName());
            this.fTextChanges = new HashMap<IFile, DVTTextFileChange>();
            int nofTextChangeItems = this.fRefactorInfo.getItems().size();
            this.beginTask(pm, "Creating changes for script: '" + this.getName() + "'", nofTextChangeItems);
            try {
                try {
                    MultipleSearchTextFileBufferManager.activate();
                    for (BaseRefactorItem item : this.fRefactorInfo.getItems()) {
                        this.subTask(pm, "Creating changes for item: " + item.toString());
                        if (item instanceof AdnotateRefactorItem) {
                            if (((AdnotateRefactorItem)item).fApplyTo == ApplyTo.DECLARATIONS) {
                                this.createDeclarationOnlyChanges((AdnotateRefactorItem)item, pm);
                            } else {
                                this.createAdnotateChanges((AdnotateRefactorItem)item, pm);
                            }
                        } else if (item instanceof ChangeSignatureRefactorItem) {
                            this.createChanges((ChangeSignatureRefactorItem)item, pm);
                        } else if (item instanceof RenameRefactorItem) {
                            this.createChanges((RenameRefactorItem)item, pm);
                        } else if (item instanceof ReplaceRefactorItem) {
                            this.createChanges((ReplaceRefactorItem)item, pm);
                        }
                        pm.worked(1);
                        if (!pm.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
                catch (RSCanceledException rSCanceledException) {
                    MultipleSearchTextFileBufferManager.deactivate();
                    break block32;
                }
            }
            catch (Throwable throwable) {
                MultipleSearchTextFileBufferManager.deactivate();
                throw throwable;
            }
            MultipleSearchTextFileBufferManager.deactivate();
        }
        if (!this.fAdnotateChanges.isEmpty()) {
            for (InsertEditInfoWrapper insertEditWrapper : this.fAdnotateChanges) {
                if (pm.isCanceled()) {
                    return;
                }
                IFile file = insertEditWrapper.getFile();
                DVTTextFileChange textFileChange = this.fTextChanges.get(file);
                if (textFileChange == null) {
                    textFileChange = new VlogTextFileChange(file.getProjectRelativePath().toOSString(), file);
                    textFileChange.setEdit((TextEdit)new MultiTextEdit());
                    this.fTextChanges.put(file, textFileChange);
                }
                textFileChange.addEdit((TextEdit)insertEditWrapper.getInsertEdit());
                GroupCategorySet gcs = new GroupCategorySet(ADNOTATE_CATEGORY);
                if (insertEditWrapper.isPotentialMatch()) {
                    gcs = new GroupCategorySet(new GroupCategory[]{ADNOTATE_CATEGORY, POTENTIAL_MATCH});
                    this.fHasPotentialMatches = true;
                }
                TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(insertEditWrapper.getMatchString(), new TextEdit[]{insertEditWrapper.getInsertEdit()}, gcs));
                textFileChange.addTextEditChangeGroup(textEditChangeGroup);
            }
        }
        if (!this.fTextChanges.isEmpty()) {
            Iterator<DVTTextFileChange> iterator = this.fTextChanges.values().iterator();
            while (iterator.hasNext()) {
                if (pm.isCanceled()) {
                    return;
                }
                TextChange textChange = (TextChange)iterator.next();
                if (textChange.getEdit() == null) {
                    iterator.remove();
                }
                if (textChange.getEdit().getChildrenSize() != 0) continue;
                iterator.remove();
            }
            HashMap<java.nio.file.Path, ArrayList<IFile>> resourcesOfPhysicalPathMap = new HashMap<java.nio.file.Path, ArrayList<IFile>>();
            for (IFile file : this.fTextChanges.keySet()) {
                if (pm.isCanceled()) {
                    return;
                }
                try {
                    java.nio.file.Path realPath = file.getLocation().toFile().toPath().toRealPath(new LinkOption[0]);
                    ArrayList<IFile> resourcesOfPhysicalPath = (ArrayList<IFile>)resourcesOfPhysicalPathMap.get(realPath);
                    if (resourcesOfPhysicalPath == null) {
                        resourcesOfPhysicalPath = new ArrayList<IFile>();
                        resourcesOfPhysicalPathMap.put(realPath, resourcesOfPhysicalPath);
                    }
                    resourcesOfPhysicalPath.add(file);
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            for (List resourcesOfPhysicalPath : resourcesOfPhysicalPathMap.values()) {
                if (pm.isCanceled()) {
                    return;
                }
                if (resourcesOfPhysicalPath.size() <= 1) continue;
                IFile keepFile = (IFile)resourcesOfPhysicalPath.remove(0);
                TextChange keepChange = (TextChange)this.fTextChanges.get(keepFile);
                for (IFile discardFile : resourcesOfPhysicalPath) {
                    TextChange discardChange = (TextChange)this.fTextChanges.get(discardFile);
                    this.merge(discardChange.getEdit(), keepChange.getEdit());
                    this.fTextChanges.remove(discardFile);
                }
            }
            TextChange[] textChanges = this.fTextChanges.values().toArray(new TextChange[this.fTextChanges.size()]);
            Arrays.sort(textChanges, new Comparator<TextChange>(){

                @Override
                public int compare(TextChange o1, TextChange o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            CompositeChange contentChanges = new CompositeChange("Content changes" + (this.fHasPotentialMatches ? " [Potential Matches Found]" : ""));
            contentChanges.addAll((Change[])textChanges);
            this.fRootChange.add((Change)contentChanges);
        }
        this.subTask(pm, "Creating rename resource changes");
        this.createRenameResourceChanges(pm);
        pm.done();
    }

    private void beginTask(IProgressMonitor pm, String message, int nofTextChangeItems) {
        pm.beginTask(message, nofTextChangeItems);
        this.debug(message);
    }

    private void subTask(IProgressMonitor pm, String message) {
        this.debug(message);
        pm.subTask(message);
    }

    private void merge(TextEdit srcEdit, final TextEdit destEdit) {
        if (srcEdit == null || destEdit == null) {
            return;
        }
        srcEdit.accept(new TextEditVisitor(){

            public void preVisit(TextEdit edit) {
                if (!destEdit.covers(edit)) {
                    destEdit.addChild(edit);
                }
            }
        });
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm.isCanceled()) {
            return new CompositeChange(this.getName());
        }
        return this.fRootChange;
    }

    private void createRenameResourceChanges(IProgressMonitor pm) throws CoreException {
        RenameRefactorCompositeChange renameChanges = new RenameRefactorCompositeChange("Rename resource changes");
        this.collectRenameResourceChangesRecursively((IResource)this.fRefactorInfo.getProject(), renameChanges, pm);
        if (renameChanges.getChildren().length > 0) {
            this.fRootChange.add((Change)renameChanges);
        }
    }

    private void collectRenameResourceChangesRecursively(IResource resource, RenameRefactorCompositeChange change, IProgressMonitor pm) throws CoreException {
        if (resource instanceof IFile) {
            change.add(this.createRenameResourceChange(resource, pm));
        } else if (resource instanceof IContainer) {
            RenameRefactorCompositeChange childResourceChange = new RenameRefactorCompositeChange(resource.getName());
            childResourceChange.add(this.createRenameResourceChange(resource, pm));
            IResource[] iResourceArray = ((IContainer)resource).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource childResource = iResourceArray[n2];
                this.collectRenameResourceChangesRecursively(childResource, childResourceChange, pm);
                ++n2;
            }
            if (childResourceChange.getChildren().length != 0) {
                change.add((Change)childResourceChange);
            }
        }
    }

    private Change createRenameResourceChange(IResource resource, IProgressMonitor pm) {
        pm.worked(1);
        if (pm.isCanceled()) {
            throw new RSCanceledException();
        }
        if (this.isWaived(resource)) {
            return null;
        }
        if (resource.isLinked()) {
            return null;
        }
        if (!this.fResourceRenameHelper.matches(resource)) {
            return null;
        }
        if (!this.isMoveable(resource)) {
            this.fRefactoringStatus.addWarning("Resource '" + resource.getFullPath() + "' is not moveable and will not be affected by resource name changes!");
            return null;
        }
        String oldName = resource.getName();
        String newName = this.fResourceRenameHelper.replaceAll(oldName, resource.getType());
        if (newName.equals(oldName)) {
            return null;
        }
        String projectPath = resource.getProject().getFullPath().toOSString();
        String parentPath = resource.getProjectRelativePath().removeLastSegments(1).toOSString();
        String actualParentPath = this.fResourceRenameHelper.replaceAll(parentPath, 2);
        IPath path = new Path(projectPath).append(actualParentPath);
        if (resource.getWorkspace().getRoot().findMember(path.append(newName)) != null) {
            this.fRefactoringStatus.addWarning("Resource '" + resource.getFullPath() + "' cannot be renamed since '" + path.append(newName) + "' already exists!");
            return null;
        }
        return new RenameResourceChange(path.append(oldName), newName);
    }

    private boolean isMoveable(IResource resource) {
        return !resource.getParent().getResourceAttributes().isReadOnly();
    }

    private void createAdnotateChanges(AdnotateRefactorItem item, IProgressMonitor pm) {
        List<RfNamedElement> namedElements = this.getNamedElements(item);
        if (namedElements == null) {
            return;
        }
        int index = 1;
        for (RfNamedElement namedElement : namedElements) {
            this.debug("[" + index + "/" + namedElements.size() + "] " + namedElement.getSignature().replaceAll("\\R", " "));
            ++index;
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IWorkingSet[])new IWorkingSet[]{this.makeWorkingSet()}, null, (boolean)false);
            ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, namedElement.getEnclosingScope(), null, true, false, true, searchScope);
            ISearchQuery query = new SearchQueryProvider(1, 6, item.fApplyTo == ApplyTo.BOTH, true, true, true, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            if (query == null) {
                return;
            }
            query.run((IProgressMonitor)new NullProgressMonitor());
            FileSearchResult searchResult = (FileSearchResult)query.getSearchResult();
            if (searchResult.getMatchCount() == 0) continue;
            this.createAdnotateChanges(item, pm, searchResult, namedElement);
        }
    }

    private IWorkingSet makeWorkingSet() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkingSetManager workingSetManager = workbench.getWorkingSetManager();
        IProject project = this.fRefactorInfo.getProject();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        HashSet<IFile> filteredIFiles = new HashSet<IFile>();
        for (ParserPath parserPath : rfProject.getCompiledFilesSet()) {
            IFile file = DVTFileUtils.getInstance().getProjectFile(project, parserPath.path);
            if (file == null || this.isWaived((IResource)file)) continue;
            filteredIFiles.add(file);
        }
        return workingSetManager.createWorkingSet(this.fRefactorInfo.getName(), (IAdaptable[])filteredIFiles.toArray(new IFile[filteredIFiles.size()]));
    }

    private List<RfNamedElement> getNamedElements(AdnotateRefactorItem item) {
        if (item.fElement != null && !item.fElement.isEmpty()) {
            RfNamedElement namedElementFromString = RfUtils.getNamedElementFromString(this.fRefactorInfo.getProject(), item.fElement);
            if (namedElementFromString == null) {
                return null;
            }
            return Arrays.asList(namedElementFromString);
        }
        if (item.fElementCommentMatcher != null) {
            CommentMatchNECollector collector = new CommentMatchNECollector(this.fRefactorInfo.getProject(), item.fElementPathMatcher, item.fElementCommentMatcher, item.fElementCommentMatchPositive);
            return collector.collect();
        }
        return null;
    }

    private void createAdnotateChanges(AdnotateRefactorItem item, IProgressMonitor pm, FileSearchResult searchResult, RfNamedElement namedElement) {
        Object[] allElements;
        Object[] objectArray = allElements = searchResult.getElements();
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object element = objectArray[n2];
            if (element instanceof IFile && !this.isWaived((IResource)(file = (IFile)element)) && !this.isBinary(file)) {
                Match[] matchArray = searchResult.getMatches(element);
                int n3 = matchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    block8: {
                        FileMatch fileMatch;
                        Match match = matchArray[n4];
                        if (pm.isCanceled()) {
                            throw new RSCanceledException();
                        }
                        if (match instanceof FileMatch && !this.isWaived((IResource)file, (IRegion)new Region((fileMatch = (FileMatch)match).getOffset(), fileMatch.getLength())) && !this.isBinary(file)) {
                            String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                            String comment = item.fComment == null ? "FIXME " + namedElement.getSignature().replaceAll("\\R", " ") + " annotated by \"" + this.fRefactorInfo.getScript().getName() + "\" refactoring script" : item.fComment;
                            InsertEdit insertEdit = VlogRfReferencesUtils.createComment((IFile)file, (int)fileMatch.getOffset(), (String)comment, (IRfNamedElement)namedElement);
                            for (InsertEditInfoWrapper wrapper : this.fAdnotateChanges) {
                                if (wrapper.getInsertEdit().getOffset() != insertEdit.getOffset() || !wrapper.getInsertEdit().getText().equals(insertEdit.getText()) || !wrapper.getFile().equals((Object)file)) {
                                    continue;
                                }
                                break block8;
                            }
                            if (insertEdit != null) {
                                this.fAdnotateChanges.add(new InsertEditInfoWrapper(insertEdit, file, matchString, fileMatch.isPossibleMatch()));
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void createDeclarationOnlyChanges(AdnotateRefactorItem item, IProgressMonitor pm) {
        if (pm.isCanceled()) {
            throw new RSCanceledException();
        }
        RfNamedElement namedElement = RfUtils.getNamedElementFromString(this.fRefactorInfo.getProject(), item.fElement);
        if (namedElement == null) {
            this.debug("Unable to find element with full name: " + item.fElement);
            return;
        }
        NEDeclarationInfoWrapper declInfoWrapper = null;
        declInfoWrapper = namedElement instanceof VlogMacroInfo ? this.makeNEDeclarationInfoWrapper((VlogMacroInfo)namedElement) : this.makeNEDeclarationInfoWrapper(namedElement);
        if (declInfoWrapper == null) {
            return;
        }
        if (this.isWaived((IResource)declInfoWrapper.file, (IRegion)new Region(declInfoWrapper.startOffset, declInfoWrapper.length)) || this.isBinary(declInfoWrapper.file)) {
            return;
        }
        String matchString = "Exact match [" + declInfoWrapper.signature + "]";
        String comment = item.fComment.isEmpty() ? "FIXME " + declInfoWrapper.signature + " annotated by \"" + this.fRefactorInfo.getScript().getName() + "\" refactoring script" : item.fComment;
        InsertEdit insertEdit = null;
        insertEdit = namedElement instanceof RfTypeAlias ? this.createTypedefDeclarationComment((RfTypeAlias)namedElement, comment) : VlogRfReferencesUtils.createComment((IFile)declInfoWrapper.file, (int)declInfoWrapper.startOffset, (String)comment, (IRfNamedElement)namedElement);
        if (insertEdit == null) {
            return;
        }
        for (InsertEditInfoWrapper wrapper : this.fAdnotateChanges) {
            if (wrapper.getInsertEdit().getOffset() != insertEdit.getOffset() || !wrapper.getInsertEdit().getText().equals(insertEdit.getText()) || !wrapper.getFile().equals((Object)declInfoWrapper.file)) continue;
            return;
        }
        if (insertEdit != null) {
            this.fAdnotateChanges.add(new InsertEditInfoWrapper(insertEdit, declInfoWrapper.file, matchString, false));
        }
    }

    private void debug(String message) {
        IProject project = this.fRefactorInfo.getProject();
        if (!BuildConfigManager.isRefScriptsDebug((IProject)project)) {
            return;
        }
        String messageFormatted = "[" + String.format("%7d", StopWatch.get((String)SW_REFSCRIPT).timeMillis()) + "]" + message;
        DVTBuildConsoleRegistry.getConsole((IProject)project).print(messageFormatted);
    }

    private void createChanges(ReplaceRefactorItem item, IProgressMonitor pm) throws CoreException {
        this.collectReplaceChangesRecursively((IResource)this.fRefactorInfo.getProject(), item, pm);
    }

    private void collectReplaceChangesRecursively(IResource resource, ReplaceRefactorItem item, IProgressMonitor pm) throws CoreException {
        if (pm.isCanceled()) {
            throw new RSCanceledException();
        }
        if (resource instanceof IFile) {
            this.createReplaceChange((IFile)resource, item);
        } else if (resource instanceof IContainer) {
            IResource[] iResourceArray = ((IContainer)resource).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource childResource = iResourceArray[n2];
                this.collectReplaceChangesRecursively(childResource, item, pm);
                ++n2;
            }
        }
    }

    private Change createReplaceChange(IFile file, ReplaceRefactorItem item) {
        VlogTextFileChange textFileChange;
        if (this.isWaived((IResource)file) || this.isBinary(file)) {
            return null;
        }
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        String fileContent = this.readFileContent(file, new RefactoringStatus());
        Matcher m = item.getMatcher();
        int lastEnd = 0;
        m.reset(fileContent);
        while (m.find()) {
            if (this.isWaived((IResource)file, (IRegion)new Region(m.start(), m.end() - m.start()))) continue;
            textFileChange = this.fTextChanges.get(file);
            if (textFileChange == null) {
                textFileChange = new VlogTextFileChange(file.getProjectRelativePath().toOSString(), file);
                textFileChange.setEdit((TextEdit)new MultiTextEdit());
                this.fTextChanges.put(file, textFileChange);
            }
            StringBuffer sb = new StringBuffer();
            m.appendReplacement(sb, item.fReplacement);
            sb.delete(0, m.start() - lastEnd);
            lastEnd = m.end();
            ReplaceEdit replaceEdit = new ReplaceEdit(m.start(), m.end() - m.start(), sb.toString());
            textFileChange.addEdit((TextEdit)replaceEdit);
            TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup("Textual replace: " + m.pattern().pattern() + " with " + sb.toString(), new TextEdit[]{replaceEdit}, new GroupCategorySet(REPLACE_CATEGORY)));
            textFileChange.addTextEditChangeGroup(textEditChangeGroup);
        }
        this.fRefactorInfo.setTextChanges(this.fTextChanges);
        if (multiTextEdit.getChildren().length == 0) {
            return null;
        }
        textFileChange = new VlogTextFileChange(file.getProjectRelativePath().toOSString(), file);
        textFileChange.setEdit((TextEdit)multiTextEdit);
        return textFileChange;
    }

    private String readFileContent(IFile file, RefactoringStatus refStatus) {
        String result = null;
        try {
            InputStream is = file.getContents();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int len = is.read(buf);
            while (len > 0) {
                bos.write(buf, 0, len);
                len = is.read(buf);
            }
            is.close();
            result = new String(bos.toByteArray());
        }
        catch (Exception ex) {
            String msg = ex.toString();
            refStatus.addFatalError(msg);
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return result;
    }

    private void createChanges(RenameRefactorItem item, IProgressMonitor pm) {
        Object[] allElements;
        RfNamedElement namedElement = RfUtils.getNamedElementFromString(this.fRefactorInfo.getProject(), item.fElement);
        if (namedElement == null) {
            return;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", true);
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fRefactorInfo.getProject()}, (String[])fileExtensions, (boolean)false);
        ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, namedElement.getEnclosingScope(), null, true, false, true, searchScope);
        ISearchQuery query = new SearchQueryProvider(1, 6, true, true, true, false, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
        if (query == null) {
            return;
        }
        query.run((IProgressMonitor)new NullProgressMonitor());
        FileSearchResult searchResult = (FileSearchResult)query.getSearchResult();
        if (searchResult.getMatchCount() == 0) {
            return;
        }
        Object[] objectArray = allElements = searchResult.getElements();
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object element = objectArray[n2];
            if (element instanceof IFile && !this.isWaived((IResource)(file = (IFile)element)) && !this.isBinary(file)) {
                DVTTextFileChange textFileChange = this.fTextChanges.get(file);
                if (textFileChange == null) {
                    textFileChange = new VlogTextFileChange(file.getProjectRelativePath().toOSString(), file);
                    textFileChange.setEdit((TextEdit)new MultiTextEdit());
                    this.fTextChanges.put(file, textFileChange);
                }
                Match[] matchArray = searchResult.getMatches(element);
                int n3 = matchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    FileMatch fileMatch;
                    Match match = matchArray[n4];
                    if (pm.isCanceled()) {
                        throw new RSCanceledException();
                    }
                    if (match instanceof FileMatch && !this.isWaived((IResource)file, (IRegion)new Region((fileMatch = (FileMatch)match).getOffset(), fileMatch.getLength())) && !this.isBinary(file)) {
                        InsertEdit insertEdit;
                        String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                        ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), item.fNewName);
                        if (!fileMatch.isInsideMacroCall()) {
                            textFileChange.addEdit((TextEdit)replaceEdit);
                        }
                        if ((insertEdit = VlogRfReferencesUtils.createComment((IFile)file, (int)fileMatch.getOffset(), (String)item.fComment, (IRfNamedElement)namedElement)) != null) {
                            textFileChange.addEdit((TextEdit)insertEdit);
                        }
                        GroupCategorySet gcs = new GroupCategorySet(RENAME_CATEGORY);
                        if (fileMatch.isPossibleMatch()) {
                            gcs = new GroupCategorySet(new GroupCategory[]{RENAME_CATEGORY, POTENTIAL_MATCH});
                            this.fHasPotentialMatches = true;
                        }
                        if (fileMatch.isInsideMacroCall()) {
                            InsertEdit edit = VlogRfReferencesUtils.createCommentForMacroHit((BaseFileMatch)fileMatch, (String)item.fNewName, (IRfNamedElement)namedElement);
                            RfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)edit, (String)matchString);
                        }
                        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, this.nonNullEditsArray(new TextEdit[]{replaceEdit, insertEdit}), gcs));
                        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private TextEdit[] nonNullEditsArray(TextEdit ... edits) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        TextEdit[] textEditArray = edits;
        int n = edits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit edit = textEditArray[n2];
            if (edit != null) {
                result.add(edit);
            }
            ++n2;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    private void createChanges(ChangeSignatureRefactorItem item, IProgressMonitor pm) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.fRefactorInfo.getName();
    }

    private InsertEdit createTypedefDeclarationComment(RfTypeAlias namedElement, String comment) {
        if (comment == null || comment.length() == 0) {
            return null;
        }
        comment = StrSubstitutor.replace((Object)comment, (Map)VlogRfReferencesUtils.makeCommentSubstMap((IRfNamedElement)namedElement));
        return new InsertEdit(namedElement.getEndOffset() + namedElement.getName().length(), " /*" + comment + "*/ ");
    }

    private NEDeclarationInfoWrapper makeNEDeclarationInfoWrapper(VlogMacroInfo vlogMacroInfo) {
        NEDeclarationInfoWrapper result = new NEDeclarationInfoWrapper();
        ParserPath parserPath = vlogMacroInfo.getFileInstance().getParserPath();
        result.file = DVTFileUtils.getInstance().getProjectFile(this.fRefactorInfo.getProject(), parserPath.path);
        result.startOffset = vlogMacroInfo.getRealOffset();
        result.length = vlogMacroInfo.getName().length();
        result.signature = vlogMacroInfo.getSignature().replaceAll("\\R", " ");
        return result;
    }

    private NEDeclarationInfoWrapper makeNEDeclarationInfoWrapper(RfNamedElement namedElement) {
        NEDeclarationInfoWrapper result = new NEDeclarationInfoWrapper();
        result.file = (IFile)namedElement.getFileAdapter();
        result.startOffset = namedElement.getStartOffset();
        result.length = namedElement.getName().length();
        result.signature = namedElement.getSignature().replaceAll("\\R", " ");
        return result;
    }

    static class NEDeclarationInfoWrapper {
        IFile file;
        int startOffset;
        int length;
        String signature;

        NEDeclarationInfoWrapper() {
        }
    }

    static class RenameResourceHelper {
        private HashMap<Matcher, RenameResourceRefactorItem> fReplaceMap = new HashMap();

        RenameResourceHelper() {
        }

        public void addReplace(RenameResourceRefactorItem item) {
            this.fReplaceMap.put(Pattern.compile(item.fSearch).matcher(""), item);
        }

        public Set<Matcher> getMatchers() {
            return this.fReplaceMap.keySet();
        }

        public String getReplacement(Matcher m) {
            return this.fReplaceMap.get((Object)m).fReplacement;
        }

        public String replaceAll(String input, int flag) {
            for (Matcher m : this.getMatchers()) {
                if (this.fReplaceMap.get((Object)m).fResourceKind != flag) continue;
                m.reset(input);
                input = m.replaceAll(this.getReplacement(m));
            }
            return input;
        }

        public boolean matches(IResource resource) {
            for (Matcher m : this.getMatchers()) {
                if (this.fReplaceMap.get((Object)m).fResourceKind != resource.getType()) continue;
                m.reset(resource.getName());
                if (!m.find()) continue;
                return true;
            }
            return false;
        }
    }
}

