/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.scripts.editor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScript;
import ro.amiq.vlogdt.ui.refactor.scripts.editor.ColorManager;
import ro.amiq.vlogdt.ui.refactor.scripts.editor.XMLConfiguration;
import ro.amiq.vlogdt.ui.refactor.scripts.editor.XMLPartitionScanner;

public class RefactorScriptEditorDialog
extends Dialog {
    private URL fScriptUrl;
    private RefactorScript fScript;

    public RefactorScriptEditorDialog(Shell parentShell, URL scriptUrl, RefactorScript script) {
        super(parentShell);
        this.fScriptUrl = scriptUrl;
        this.fScript = script;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 640;
        layoutData.heightHint = 480;
        container.setLayoutData((Object)layoutData);
        this.getShell().setText("Inspecting Refactoring Script: " + this.fScript.getName());
        this.getShell().setImage(DVTImages.imageCache.getImage(DVTImages.SCRIPT_REFACTOR));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = this.fScriptUrl.openStream();){
                int available = is.available();
                byte[] bytes = new byte[available];
                if (is.read(bytes) != available) {
                    return container;
                }
                String content = new String(bytes);
                Document document = new Document(content);
                SourceViewer viewer = new SourceViewer(container, null, null, false, 2816);
                viewer.setEditable(false);
                XMLConfiguration xmlConfiguration = new XMLConfiguration(new ColorManager());
                viewer.configure((SourceViewerConfiguration)xmlConfiguration);
                FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
                partitioner.connect((IDocument)document);
                document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                viewer.setDocument((IDocument)document);
                partitioner.disconnect();
                viewer.unconfigure();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return container;
    }

    protected boolean isResizable() {
        return true;
    }
}

