/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class MacroSearchVisitor {
    private static final int MAX_SCAN = 10000;
    private static final int SCANNER_BUFFER_SIZE = 100;
    private static final String IFNDEF_STRING = "ifndef";
    private static final String IFDEF_STRING = "ifdef";
    private static final String UNDEF_STRING = "undef";
    private static final String DEFINE_STRING = "define";
    private static final Set<String> MACRO_PREPROCESSOR_DIRECTIVES = new HashSet<String>(Arrays.asList("define", "undef", "ifndef", "ifdef"));
    private Matcher fMatcher;
    private IProgressMonitor fProgressMonitor;
    private IRfNamedElement fRfElement;
    private boolean fIncludeDeclarations;
    private String fSearchString;
    private IReportHitsListener<SearchHit> fReportListener;
    private int fCheckCanceledCounter;
    private FileSynchedAndAvailableManager fFileManager;

    public MacroSearchVisitor(IRfNamedElement element, Pattern searchPattern, boolean includeDeclarations, String searchString, IReportHitsListener<SearchHit> reportListener, FileSynchedAndAvailableManager fileManager) {
        this.fSearchString = searchString;
        this.fRfElement = element;
        if (searchPattern.pattern().length() != 0) {
            String regex = searchPattern.pattern();
            this.fMatcher = Pattern.compile("\\b" + regex + "\\b", searchPattern.flags()).matcher("");
        } else {
            this.fMatcher = null;
        }
        this.fIncludeDeclarations = includeDeclarations;
        this.fReportListener = reportListener;
        this.fFileManager = fileManager;
    }

    public IStatus search(IProgressMonitor monitor, Map<IProject, Set<ParserPath>> filesToSearchIn) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        String patternText = this.fMatcher.pattern().pattern();
        if (patternText.startsWith("`")) {
            this.fMatcher = Pattern.compile(patternText.substring(1)).matcher("");
        }
        DocumentManager documentManager = new DocumentManager();
        try {
            documentManager.activate();
            this.processFiles(filesToSearchIn, documentManager);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            documentManager.deactivate();
            this.fProgressMonitor.done();
        }
    }

    private void processFiles(Map<IProject, Set<ParserPath>> filesMap, DocumentManager documentManager) {
        block0: for (Map.Entry<IProject, Set<ParserPath>> entry : filesMap.entrySet()) {
            Set<ParserPath> files;
            IProject project = entry.getKey();
            RfProject fRfProject = RfManager.getInstance().getRfProject(project);
            if (fRfProject == null || (files = entry.getValue()) == null || files.isEmpty()) continue;
            for (ParserPath file : files) {
                boolean res;
                boolean hasHits;
                RfFileDef fileDef;
                if (file != null && ((fileDef = fRfProject.getFile(file)) != null || (fileDef = fRfProject.getMixedLangProjectParent().getFile((IRfSingleLangProject)fRfProject, file)) != null) && (hasHits = RfMixedLangManager.getInstance().hasHits(file, project, new String[]{this.fSearchString}, this.fMatcher, false)) && !(res = this.processFile(file, this.fMatcher, project, documentManager))) continue block0;
            }
        }
    }

    private boolean processFile(ParserPath parserPath, Matcher matcher, IProject project, DocumentManager documentManager) {
        IDocument document;
        block6: {
            block5: {
                try {
                    IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
                    if (file != null && this.fFileManager.isSynchedFile(parserPath, project)) break block5;
                    return true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            document = documentManager.getDocument(parserPath, project);
            if (document != null) break block6;
            return true;
        }
        DocumentCharSequence documentCharSequence = new DocumentCharSequence(document, true);
        this.locateMatches(parserPath, project, document, documentCharSequence, matcher);
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException("Operation Canceled");
        }
        return true;
    }

    private void locateMatches(ParserPath parserPath, IProject project, IDocument openDocument, DocumentCharSequence searchInput, Matcher matcher) {
        try {
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            matcher.reset((CharSequence)searchInput);
            while (matcher.find()) {
                int matchStartOffset = matcher.start();
                int matchEndOffset = matcher.end();
                int matchLine = openDocument.getLineOfOffset(matchStartOffset);
                int startOffsetOfMatchLine = openDocument.getLineOffset(matchLine);
                RfFileDef rfFileDef = rfProject.getFile(parserPath);
                if (rfFileDef == null) {
                    return;
                }
                boolean validContentType = RfSearchUtils.validContentType((IProject)project, (IDocument)openDocument, (int)(matchEndOffset - 1));
                if (!validContentType) continue;
                if (this.isPrecededByBacktickSkippingWS(openDocument, matchStartOffset - 1 >= 0 ? matchStartOffset - 1 : 0, true)) {
                    this.reportMacroHit(parserPath, project, matchStartOffset, matchEndOffset, matchLine, startOffsetOfMatchLine, openDocument);
                } else {
                    Map offsetsOfPrecedingPreprocDirectives = DVTDocumentUtils.getAllBackwardListOfOffsetsForWords((IDocument)openDocument, MACRO_PREPROCESSOR_DIRECTIVES, (int)startOffsetOfMatchLine, (int)matchStartOffset, (boolean)false, (boolean)true);
                    if (offsetsOfPrecedingPreprocDirectives.containsKey(DEFINE_STRING) && this.fIncludeDeclarations) {
                        this.checkAndReportMacroHit(offsetsOfPrecedingPreprocDirectives, DEFINE_STRING, parserPath, project, matchStartOffset, matchEndOffset, matchLine, startOffsetOfMatchLine, openDocument);
                    } else if (offsetsOfPrecedingPreprocDirectives.containsKey(UNDEF_STRING)) {
                        this.checkAndReportMacroHit(offsetsOfPrecedingPreprocDirectives, UNDEF_STRING, parserPath, project, matchStartOffset, matchEndOffset, matchLine, startOffsetOfMatchLine, openDocument);
                    } else if (offsetsOfPrecedingPreprocDirectives.containsKey(IFDEF_STRING)) {
                        this.checkAndReportMacroHit(offsetsOfPrecedingPreprocDirectives, IFDEF_STRING, parserPath, project, matchStartOffset, matchEndOffset, matchLine, startOffsetOfMatchLine, openDocument);
                    } else if (offsetsOfPrecedingPreprocDirectives.containsKey(IFNDEF_STRING)) {
                        this.checkAndReportMacroHit(offsetsOfPrecedingPreprocDirectives, IFNDEF_STRING, parserPath, project, matchStartOffset, matchEndOffset, matchLine, startOffsetOfMatchLine, openDocument);
                    }
                }
                this.checkCanceled();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void checkCanceled() {
        if (this.fCheckCanceledCounter++ % 20 != 0) {
            return;
        }
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException("Operation Canceled");
        }
    }

    private boolean isPrecededByBacktickSkippingWS(IDocument document, int offset, boolean checkDoubleBacktick) {
        DVTCharacterScanner scanner = new DVTCharacterScanner(100, document, offset, false);
        boolean result = false;
        int pos = offset;
        while (offset - pos < 10000) {
            char ch = (char)scanner.read();
            if (!Character.isWhitespace(ch) || result) {
                if (ch == '`' && !result) {
                    if (!checkDoubleBacktick) {
                        return true;
                    }
                    result = true;
                } else {
                    if (ch == '`' && result) {
                        return false;
                    }
                    return result;
                }
            }
            --pos;
        }
        return false;
    }

    private void checkAndReportMacroHit(Map<String, List<Integer>> preprocessedKeywords, String searchedString, ParserPath parserPath, IProject project, int start, int end, int matchLine, int startOffsetOfMatchLine, IDocument document) throws BadLocationException {
        List<Integer> searchedStringOffsetList = preprocessedKeywords.get(searchedString);
        if (searchedStringOffsetList == null || searchedStringOffsetList.isEmpty()) {
            return;
        }
        int offset = searchedStringOffsetList.get(0);
        if (!this.isPrecededByBacktickSkippingWS(document, offset + 1, false)) {
            return;
        }
        this.reportMacroHit(parserPath, project, start, end, matchLine, startOffsetOfMatchLine, document);
    }

    private void reportMacroHit(ParserPath parserPath, IProject project, int start, int end, int matchLine, int startOffsetOfMatchLine, IDocument document) throws BadLocationException {
        IRegion lineInformation = document.getLineInformation(matchLine);
        String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
        VlogSearchHit searchHit = new VlogSearchHit(parserPath, matchLine + 1, start, lineContents, end - start, project, null);
        searchHit.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)project, (ParserPath)parserPath, (int)(matchLine + 1), (int)end, (boolean)false));
        int counter = RfReferencesUtils.countStartWS((String)lineContents);
        if (counter >= 0) {
            searchHit.setSearchedElement(this.fRfElement.getName(), start - startOffsetOfMatchLine - counter, false);
        }
        this.fReportListener.addMatch((Object)searchHit);
    }
}

