/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search;

import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.ISearchQueryElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfSearchQueryElement
extends RfNamedElement
implements ISearchQueryElement {
    private static final long serialVersionUID = 1L;
    private int fType;

    public RfSearchQueryElement(int type, String name) {
        super(name, false);
        this.fType = type;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return null;
    }

    protected boolean isFunction() {
        return this.fType == 1;
    }

    protected boolean isTask() {
        return this.fType == 5;
    }

    protected boolean isField() {
        return this.fType == 2;
    }

    protected boolean isEvent() {
        return this.fType == 3;
    }

    protected boolean isType() {
        return this.fType == 0;
    }

    protected boolean isCovergroup() {
        return this.fType == 4;
    }

    public boolean isMacro() {
        return this.fType == 7;
    }

    @Override
    public RfProject getRfProject() {
        try {
            Assert.isTrue((boolean)false, (String)"This call returns null, should not use.");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public int getType() {
        return this.fType;
    }

    public String getStringType() {
        if (this.isFunction()) {
            return "function";
        }
        if (this.isTask()) {
            return "task";
        }
        if (this.isField()) {
            return "field";
        }
        if (this.isEvent()) {
            return "event";
        }
        if (this.isType()) {
            return "type";
        }
        if (this.isCovergroup()) {
            return "covergroup";
        }
        if (this.isMacro()) {
            return "macro";
        }
        return "";
    }

    @Override
    public String getFullNameLabel(RfTypesResolver resolver) {
        if (this.fType == 5 || this.fType == 1) {
            return this.getName() + "()";
        }
        if (this.fType == 7) {
            return "`" + this.getName();
        }
        return this.getName();
    }
}

