/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search;

import java.util.function.BiPredicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.ui.search.BaseSearchQueryProvider;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchManager;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.DeclarationsSearchQuery;
import ro.amiq.vlogdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vlogdt.ui.search.new_engine.ReferenceHidSearchQuery;
import ro.amiq.vlogdt.ui.search.text.FileSearchQuery;

public class SearchQueryProvider
extends BaseSearchQueryProvider {
    private int fLimitTo;
    private int fSearchFor;
    private boolean fIncludeDeclarations;
    private boolean fOnlyCompiled;
    private boolean fForRefactor;
    private boolean fIsStrictVirtualFunction;
    RWSearchTypeEnum fSearchRWType;
    private BiPredicate<IHidObject, IRfClassElement> fFilterPredicate;

    public SearchQueryProvider(int limitTo, int searchFor, boolean includeDeclarations, boolean isOnlyCompiled, boolean forRefactoring, boolean isStrictVirtualFunction, RWSearchTypeEnum searchRWType) {
        this(limitTo, searchFor, includeDeclarations, isOnlyCompiled, forRefactoring, isStrictVirtualFunction, searchRWType, null);
    }

    public SearchQueryProvider(int limitTo, int searchFor, boolean includeDeclarations, boolean isOnlyCompiled, boolean forRefactoring, boolean isStrictVirtualFunction, RWSearchTypeEnum searchRWType, BiPredicate<IHidObject, IRfClassElement> filterPredicate) {
        this.fLimitTo = limitTo;
        this.fSearchFor = searchFor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fOnlyCompiled = isOnlyCompiled;
        this.fForRefactor = forRefactoring;
        this.fIsStrictVirtualFunction = isStrictVirtualFunction;
        SearchManager.getInstance().getPositionTracker();
        this.fSearchRWType = searchRWType;
        this.fFilterPredicate = filterPredicate;
    }

    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        boolean wholeWord;
        FileTextSearchScope scope = input.getScope();
        String text = input.getSearchText();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        boolean bl = wholeWord = regEx ? false : ((TextSearchPageInput)input).isWholeWordSearch();
        if (input instanceof ReferenceSearchPageInput) {
            IRfNamedElement element = ((ReferenceSearchPageInput)input).getRfElement();
            IRfScopeElement scopeElement = ((ReferenceSearchPageInput)input).getScopeElement();
            ElementPath designContextPath = null;
            if (VlogRfReferencesUtils.shouldHaveDesignPath(element, ((ReferenceSearchPageInput)input).getIsHierarchicalAccess())) {
                designContextPath = ((ReferenceSearchPageInput)input).getDesignContextPath();
            }
            String searchedString = ((ReferenceSearchPageInput)input).getSearchedString();
            if (scopeElement instanceof RfDefElement) {
                scopeElement = ((RfDefElement)scopeElement).getNamedElement();
            }
            if (scopeElement instanceof RfNamedElement) {
                scopeElement = ((RfNamedElement)scopeElement).getClosestTypeContainer();
            }
            RfTypesResolver resolver = RfTypesResolver.create(scopeElement, scopeElement instanceof RfNamedElement ? ((RfNamedElement)scopeElement).getRfProject() : null, 4);
            String searchLabel = VlogRfReferencesUtils.getFullNameLabel(element, resolver, designContextPath);
            String searchType = this.getSearchType(element);
            IProject project = this.getProject(element, input);
            return new ReferenceHidSearchQuery(project, searchType, element, resolver, scopeElement, designContextPath, searchLabel, input.isRegExSearch(), input.isCaseSensitiveSearch(), input.isWholeWordSearch(), scope, 1, this.fIncludeDeclarations, 6, this.fForRefactor, this.fIsStrictVirtualFunction, this.fSearchRWType, searchedString, this.fFilterPredicate);
        }
        String searchLabel = text;
        if (this.fSearchFor == 5 || this.fSearchFor == 1) {
            searchLabel = String.valueOf(searchLabel) + "()";
        }
        if (this.fLimitTo == 0) {
            return new DeclarationsSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor, this.fForRefactor, this.fIsStrictVirtualFunction);
        }
        return new FileSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor, this.fForRefactor, this.fIsStrictVirtualFunction);
    }

    protected String getSearchType() {
        switch (this.fSearchFor) {
            case 0: {
                return "Type";
            }
            case 3: {
                return "Event";
            }
            case 2: {
                return "Field";
            }
            case 1: {
                return "Function";
            }
            case 5: {
                return "Task";
            }
            case 4: {
                return "Coverage";
            }
            case 7: {
                return "Macro";
            }
        }
        return "Text";
    }
}

