/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import ro.amiq.dvt.ui.search.BaseFileLabelProvider;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseConstraintsSearchPage;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.search.text.CategoryFilterConfig;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintLineElement;
import ro.amiq.vlogdt.ui.search.text.FileLabelProvider;
import ro.amiq.vlogdt.ui.search.text.FileTreeContentProvider;

public class ConstraintsSearchPage
extends BaseConstraintsSearchPage {
    private static CategoryFilterConfig HIDE_RAND_MODE_CATEGORY_FILTER = new CategoryFilterConfig("Hide rand_mode() calls", "searchViewVlogdtHideRandModes"){

        public boolean filter(LineElement lineElement) {
            return "rand_mode".equals(((ConstraintLineElement)lineElement).getModeCall());
        }
    };
    private static CategoryFilterConfig HIDE_CONSTRAINT_MODE_CATEGORY_FILTER = new CategoryFilterConfig("Hide constraint_mode() calls", "searchViewVlogdtHideConstraintModes"){

        public boolean filter(LineElement lineElement) {
            return "constraint_mode".equals(((ConstraintLineElement)lineElement).getModeCall());
        }
    };
    private static final List<CategoryFilterConfig> CONFIGS = Arrays.asList(HIDE_CONSTRAINT_MODE_CATEGORY_FILTER, HIDE_RAND_MODE_CATEGORY_FILTER);

    protected BaseFileLabelProvider makeLabelProvider(BaseFileSearchPage page, int orderFlag, ILabelDecorator decorator) {
        return new FileLabelProvider((AbstractTextSearchViewPage)page, orderFlag, decorator);
    }

    protected IContentProvider makeFileTreeContentProvider(BaseFileSearchPage page, TreeViewer viewer, BaseFileLabelProvider innerLabelProvider) {
        return new FileTreeContentProvider(page, (AbstractTreeViewer)viewer, innerLabelProvider);
    }

    protected List<CategoryFilterConfig> getFilterConfigs() {
        LinkedHashSet<CategoryFilterConfig> result = new LinkedHashSet<CategoryFilterConfig>();
        result.add(HIDE_CONSTRAINT_MODE_CATEGORY_FILTER);
        result.add(HIDE_RAND_MODE_CATEGORY_FILTER);
        return new ArrayList<CategoryFilterConfig>(result);
    }
}

