/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.constraints;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseConstraintsSearchQuery;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintLineElement;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintSearchHit;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintsSearchResult;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintsVisitor;
import ro.amiq.vlogdt.ui.search.constraints.HidCountVisitor;
import ro.amiq.vlogdt.ui.search.text.FileMatch;

public class ConstraintsSearchQuery
extends BaseConstraintsSearchQuery {
    public ConstraintsSearchQuery(RfField element) {
        super((IRfNamedElement)element);
    }

    public String getFieldNameForLabel() {
        RfField field = (RfField)this.getField();
        if (field == null) {
            return null;
        }
        return (field.isRand() ? "rand " : (field.isRandc() ? "randc " : "")).concat(field.getFullName());
    }

    protected int computeMonitorTicks() {
        RfProject rfProject = (RfProject)this.getRfProject();
        HidCountVisitor visitor = new HidCountVisitor();
        rfProject.visitHidObject(null, visitor);
        return visitor.getNoHids();
    }

    protected void computeMatches() {
        RfProject rfProject = (RfProject)this.getRfProject();
        RfField field = (RfField)this.getField();
        if (field == null) {
            return;
        }
        DocumentManager documentManager = new DocumentManager();
        try {
            try {
                documentManager.activate();
                final HashSet cachedMatches = new HashSet();
                IReportHitsListener<ConstraintSearchHit> reportListener = new IReportHitsListener<ConstraintSearchHit>(){

                    public void addMatch(ConstraintSearchHit match) {
                        try {
                            IFile file;
                            ParserPath parserPath = match.getParserPath();
                            if (parserPath == null) {
                                return;
                            }
                            if (!parserPath.equals((Object)ConstraintsSearchQuery.this.fCurrentParserPath)) {
                                ConstraintsSearchQuery.this.fCurrentParserPath = parserPath;
                                VlogRfReferencesUtils.flushMatches((Set)cachedMatches, (AbstractTextSearchResult)ConstraintsSearchQuery.this.getSearchResult());
                            }
                            if ((file = DVTFileUtils.getInstance().findProjectFile(match.getProject(), parserPath.path)) == null) {
                                return;
                            }
                            ConstraintLineElement element = new ConstraintLineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents(), match.getExtraInfo(), match.getMode());
                            element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                            element.setWriteAccess(match.getAccess());
                            FileMatch fileMatch = new FileMatch(file, match.getOffset(), match.getMatchLength(), match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                            cachedMatches.add(fileMatch);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }

                    public Set<ConstraintSearchHit> getMatches() {
                        return null;
                    }
                };
                ConstraintsVisitor constraintsVisitor = new ConstraintsVisitor(field, this.getMonitor(), reportListener, documentManager);
                rfProject.visitHidObject(null, constraintsVisitor);
                VlogRfReferencesUtils.flushMatches(cachedMatches, (AbstractTextSearchResult)this.getSearchResult());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                documentManager.deactivate();
            }
        }
        finally {
            documentManager.deactivate();
        }
    }

    protected AbstractTextSearchResult makeSearchResult() {
        return new ConstraintsSearchResult((ISearchQuery)this);
    }

    protected boolean useScaledMonitor() {
        return true;
    }
}

