/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintSearchHit;

public class ConstraintsVisitor
extends RfHidVisitor {
    private static final int FIRST_LEVEL = 1;
    private static final int SECOND_LEVEL = 2;
    private static final String RANDOMIZE = "randomize";
    private static final String STDRANDOMIZE = "std::randomize";
    private static final String RANDOMIZE_WITH = "randomize_with";
    public static final String CONSTRAINT_MODE = "constraint_mode";
    public static final String RAND_MODE = "rand_mode";
    public static final Set<String> MODE_CALL_FUNCTIONS = new HashSet<String>(Arrays.asList("constraint_mode", "rand_mode"));
    private static final int SCAN_LIMIT = 1000;
    private RfField fRfElement;
    private IProject fProject;
    private RfProject fRfProject;
    private IReportHitsListener<ConstraintSearchHit> fReportListener;
    private IProgressMonitor fProgressMonitor;
    private ParserPath fCurrentParserPath;
    private DocumentManager fDocumentManager;
    private Map<Integer, Map<Hid, MacroCallSearchStatus>> fMacroInfoMap;

    public ConstraintsVisitor(RfField rfNamedElement, IProgressMonitor monitor, IReportHitsListener<ConstraintSearchHit> reportListener, DocumentManager documentManager) {
        this.fRfElement = rfNamedElement;
        this.fRfProject = this.fRfElement.getRfProject();
        this.fProject = this.fRfProject.getProject();
        this.fProgressMonitor = monitor;
        this.fReportListener = reportListener;
        this.fDocumentManager = documentManager;
        this.fMacroInfoMap = new HashMap<Integer, Map<Hid, MacroCallSearchStatus>>(4);
    }

    @Override
    public void setParserPath(ParserPath parserPath) {
        super.setParserPath(parserPath);
        if (!parserPath.equals((Object)this.fCurrentParserPath) && this.fCurrentParserPath != null) {
            this.fMacroInfoMap = new HashMap<Integer, Map<Hid, MacroCallSearchStatus>>(4);
        }
        this.fCurrentParserPath = parserPath;
    }

    public boolean visit(RfHid hid) {
        this.fProgressMonitor.worked(1);
        if (this.fProgressMonitor.isCanceled()) {
            return false;
        }
        if (hid.getName() == null) {
            return true;
        }
        if (MODE_CALL_FUNCTIONS.contains(hid.getName())) {
            Hid parentHid = hid.getParentHid();
            if (parentHid == null) {
                return true;
            }
            IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
            if (parentHid.getElement() == this.fRfElement) {
                this.addModeMatch(new ModeCallInfo(this.getRelevantOccurrence(hid), (IRfScopeElement)scope, RAND_MODE.equals(hid.getName()) ? RAND_MODE : CONSTRAINT_MODE));
            } else if (parentHid.getElement() instanceof RfConstraint) {
                this.visitConstraintContent((IRfScopeElement)scope, hid, parentHid.getElement());
            } else if (parentHid.getElement() instanceof RfAssociatedType) {
                if (!(this.fRfElement.getEnclosingScope() instanceof RfClass)) {
                    return true;
                }
                IRfNamedElement typeOfCalledObject = ((RfAssociatedType)parentHid.getElement()).getAssociatedType();
                if (!(typeOfCalledObject instanceof RfClass)) {
                    return true;
                }
                if (!this.isSameOrSubClass((RfClass)typeOfCalledObject, (RfClass)this.fRfElement.getEnclosingScope())) {
                    return true;
                }
                if (CONSTRAINT_MODE.equals(hid.getName())) {
                    this.computeConstraintModeMatches((RfClass)typeOfCalledObject, hid, (IRfScopeElement)scope);
                } else if (RAND_MODE.equals(hid.getName())) {
                    this.addModeMatch(new ModeCallInfo(this.getRelevantOccurrence(hid), (IRfScopeElement)scope, RAND_MODE));
                }
            }
        }
        if (!this.fRfElement.checkEquals(hid.getElement())) {
            return true;
        }
        IRfNamedElement hidHolderScope = ((RfHidHolder)this.holder).getScope();
        if (hidHolderScope instanceof RfConstraint || hidHolderScope instanceof RfActionBlock && hidHolderScope.getEnclosingScope(RfConstraint.class) != null) {
            this.addConstraintMatch(hid, (IRfScopeElement)hidHolderScope, false);
            return true;
        }
        HidAccess parentAccess = hid.getParentAccess();
        if (parentAccess == null) {
            if (hidHolderScope == null) {
                return true;
            }
            if ((hidHolderScope = hidHolderScope.getEnclosingScope(RfFunctionCall.class)) == null) {
                return true;
            }
            if (RANDOMIZE.equals(hidHolderScope.getName())) {
                this.addConstraintMatch(hid, (IRfScopeElement)hidHolderScope, true);
            }
        } else {
            Hid secondId = this.getSecondIdInHid(hid);
            if (secondId == null) {
                return true;
            }
            Hid firstId = secondId.getParentHid();
            if (firstId == null) {
                return true;
            }
            IRfNamedElement firstIdElement = firstId.getElement();
            if (firstIdElement == null) {
                return true;
            }
            IRfNamedElement scope = secondId.getSecondaryScope();
            if (scope == null) {
                return true;
            }
            if ((scope = scope.getEnclosingScope(RfFunctionCall.class)) == null) {
                return true;
            }
            if (RANDOMIZE.equals(scope.getName()) || STDRANDOMIZE.equals(scope.getName()) && scope instanceof RfFunctionCall) {
                RfFunctionCall randomizeCall = (RfFunctionCall)scope;
                List<String> randomizeCallArguments = randomizeCall.getArguments();
                String reference = RANDOMIZE.equals(scope.getName()) && firstId.hasQualifier(HidQualifierCache.HIDDEN) ? secondId.getName() : firstIdElement.getName();
                for (String argument : randomizeCallArguments) {
                    if (!argument.equals(reference)) continue;
                    this.addConstraintMatch(hid, (IRfScopeElement)scope, true);
                    return true;
                }
            } else {
                IRfNamedElement secondIdElement = secondId.getElement();
                if (secondIdElement != firstIdElement) {
                    IRfScopeElement secondIdEnclosingScope = secondIdElement.getEnclosingScope();
                    RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)hidHolderScope, this.fRfProject, 8);
                    IRfNamedElement firstIdAssocType = ((RfField)firstIdElement).getAssociatedType(resolver);
                    if (firstIdAssocType instanceof RfSpecializedClass) {
                        firstIdAssocType = ((RfSpecializedClass)firstIdAssocType).getGenericClass();
                    }
                    if (secondIdEnclosingScope instanceof RfSpecializedClass) {
                        secondIdEnclosingScope = ((RfSpecializedClass)secondIdEnclosingScope).getGenericClass();
                    }
                    if (secondIdEnclosingScope != firstIdAssocType) {
                        if (secondIdEnclosingScope instanceof RfClass && firstIdAssocType instanceof RfClass && ((RfClass)firstIdAssocType).isChildOfClass((RfClass)secondIdEnclosingScope)) {
                            this.addConstraintMatch(hid, (IRfScopeElement)scope, true);
                            return true;
                        }
                        return true;
                    }
                }
                this.addConstraintMatch(hid, (IRfScopeElement)scope, true);
            }
        }
        return true;
    }

    private boolean isSameOrSubClass(RfClass rfClass, RfClass ancestorCandidate) {
        if (rfClass.getGenericClass() == ancestorCandidate.getGenericClass()) {
            return true;
        }
        return rfClass.isSubClass(ancestorCandidate);
    }

    private void visitConstraintContent(final IRfScopeElement scope, final RfHid hid, IRfNamedElement visitedObject) {
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (hidObject.getElement() != ConstraintsVisitor.this.fRfElement) {
                    return true;
                }
                ConstraintsVisitor.this.addModeMatch(new ModeCallInfo(ConstraintsVisitor.this.getRelevantOccurrence(hid), scope, ConstraintsVisitor.RAND_MODE.equals(hid.getName()) ? ConstraintsVisitor.RAND_MODE : ConstraintsVisitor.CONSTRAINT_MODE));
                return false;
            }
        };
        visitedObject.visitHidObject(null, (IHidVisitor)visitor);
    }

    private void computeConstraintModeMatches(RfClass type, RfHid hid, IRfScopeElement scope) {
        if (type == null) {
            return;
        }
        Collection<RfNamedElement> members = type.getMembers();
        for (RfNamedElement element : members) {
            if (!(element instanceof RfConstraint)) continue;
            this.visitConstraintContent(scope, hid, element);
        }
        this.computeConstraintModeMatches(type.getParent(), hid, scope);
    }

    private Hid getSecondIdInHid(RfHid hid) {
        RfHid currentHid = hid;
        RfHid hidBehindCurrentHid = null;
        while (currentHid.getParentHid() != null) {
            hidBehindCurrentHid = currentHid;
            currentHid = currentHid.getParentHid();
        }
        return hidBehindCurrentHid;
    }

    private HidOccurrence getRelevantOccurrence(RfHid hid) {
        if (!hid.hasAccesses()) {
            return null;
        }
        ListContainer accesses = hid.getAccesses();
        for (HidAccess access : accesses) {
            if (!(access instanceof IHidAccessArgs) || ((IHidAccessArgs)access).getArgumentValues().isEmpty()) continue;
            return access.getOccurrence();
        }
        return null;
    }

    private String computeScopeInfo(IRfScopeElement scope) {
        if (scope instanceof RfConstraint) {
            return "[ " + ((RfConstraint)scope).getFullName() + " ]";
        }
        RfFunction enclosingFunction = (RfFunction)scope.getEnclosingScope(RfFunction.class);
        if (enclosingFunction != null) {
            return "[ " + RfKind.of(enclosingFunction).getName() + " " + ((RfFunction)scope.getEnclosingScope(RfFunction.class)).getFullName() + "() ]";
        }
        RfActionBlock enclosingActionBlock = this.getFarthestActionBlockEncolsingScope(scope);
        if (enclosingActionBlock == null) {
            return "";
        }
        String actionBlockTypeName = this.getActionBlockTypeName(enclosingActionBlock);
        String actionBlockContainerTypeName = RfKind.of(enclosingActionBlock.getEnclosingScope()).getName();
        String actionBlockContainerName = enclosingActionBlock.getEnclosingScope().getFullName();
        return "[ " + actionBlockTypeName + "block inside " + actionBlockContainerTypeName + " " + actionBlockContainerName + " ]";
    }

    private String getActionBlockTypeName(RfActionBlock enclosingActionBlock) {
        StringBuilder result = new StringBuilder();
        if (enclosingActionBlock.isNamedBlock()) {
            result.append(enclosingActionBlock.getName()).append(" ");
        }
        long blockQualifiers = enclosingActionBlock.getBlockQualifiers();
        IRfActionBlockElement.BlockQualifier[] blockQualifierArray = IRfActionBlockElement.BlockQualifier.values();
        int n = blockQualifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRfActionBlockElement.BlockQualifier blockQualifier = blockQualifierArray[n2];
            if (blockQualifier != IRfActionBlockElement.BlockQualifier.BEGIN_END && blockQualifier != IRfActionBlockElement.BlockQualifier.IS_COMBINATIONAL && blockQualifier != IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL && (blockQualifiers & blockQualifier.value()) != 0L) {
                result.append(blockQualifier.toString().toLowerCase()).append(" ");
            }
            ++n2;
        }
        return result.toString();
    }

    private RfActionBlock getFarthestActionBlockEncolsingScope(IRfScopeElement scope) {
        IRfScopeElement parentScope = scope;
        RfActionBlock bestCandidate = null;
        while (parentScope != null) {
            if (parentScope instanceof RfActionBlock) {
                bestCandidate = (RfActionBlock)parentScope;
            }
            parentScope = parentScope.getEnclosingScope();
        }
        return bestCandidate;
    }

    private void addConstraintMatch(RfHid hid, IRfScopeElement scope, boolean isRandomizeWith) {
        this.addMatch(hid, hid.getOccurrence(), scope, isRandomizeWith ? RANDOMIZE_WITH : null);
    }

    private void addModeMatch(ModeCallInfo callInfo) {
        this.addMatch(null, callInfo.hit, callInfo.scope, callInfo.mode);
    }

    private void addMatch(RfHid hid, HidOccurrence occurrence, IRfScopeElement scope, String mode) {
        if (occurrence == null) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(this.parserPath, this.fProject);
        try {
            int line = occurrence.getLine();
            int offset = occurrence.getOffset();
            TextOffset textOffset = this.computeMacroHit(hid, occurrence);
            String matchString = this.fRfElement.getName();
            if (textOffset != null) {
                int index = textOffset.text.indexOf(this.fRfElement.getName());
                offset = textOffset.offset;
                if (index != -1) {
                    offset += index;
                } else {
                    matchString = textOffset.text;
                }
                line = DVTDocumentUtils.convertPositionToLine((IDocument)document, (int)offset);
            } else if (mode != null && !mode.equals(RANDOMIZE_WITH)) {
                matchString = mode;
            }
            IRegion region = document.getLineInformation(line - 1);
            String lineContents = document.get(region.getOffset(), region.getLength());
            ConstraintSearchHit match = new ConstraintSearchHit(this.parserPath, line, offset, lineContents, matchString.length(), this.fProject, mode);
            match.setExtraInfo(this.computeScopeInfo(scope));
            if (mode == null || mode.equals(RANDOMIZE_WITH)) {
                int lineOffset = DVTDocumentUtils.convertLineToOffset((IDocument)document, (int)line);
                int counter = VlogRfReferencesUtils.countStartWS((String)lineContents);
                match.setSearchedElement(matchString, offset - lineOffset - counter, false);
            }
            this.fReportListener.addMatch((Object)match);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private TextOffset computeMacroHit(Hid hid, HidOccurrence occurence) {
        MacroCallSearchStatus infoForHid;
        int virtualOffset = occurence.getVirtualOffset();
        if (virtualOffset == -1) {
            return null;
        }
        int offset = occurence.getOffset();
        Map<Hid, MacroCallSearchStatus> infoMap = this.fMacroInfoMap.get(offset);
        if (infoMap == null) {
            infoMap = new HashMap<Hid, MacroCallSearchStatus>(4);
            this.fMacroInfoMap.put(offset, infoMap);
        }
        if ((infoForHid = infoMap.get(hid)) == null) {
            IDocument document = this.fDocumentManager.getDocument(this.parserPath, this.fProject);
            if (document == null) {
                return null;
            }
            infoForHid = this.locateMatch(document, infoMap, hid, offset);
        }
        if (infoForHid == null) {
            return null;
        }
        int startOffset = 0;
        int endOffset = 0;
        Matcher hidMatcher = infoForHid.fMatcher;
        if (!hidMatcher.find()) {
            return new TextOffset(infoForHid.fMacroCallText, offset);
        }
        startOffset = hidMatcher.start();
        endOffset = hidMatcher.toMatchResult().end();
        return new TextOffset(infoForHid.fMacroCallText.substring(startOffset, endOffset), offset + startOffset);
    }

    private MacroCallSearchStatus locateMatch(IDocument document, Map<Hid, MacroCallSearchStatus> macroInfoMap, Hid hid, int offset) {
        IRegion macroCallRegion = RfBatchUtils.getMacroRegionAtOffset(this.fRfProject, this.parserPath, document, offset, 1000);
        if (macroCallRegion == null) {
            return null;
        }
        String macroCallText = null;
        try {
            macroCallText = document.get(macroCallRegion.getOffset(), macroCallRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (macroCallText == null) {
            return null;
        }
        StringBuilder hierarchicalPathPattern = new StringBuilder();
        this.computeHierarchicalPathPattern(hid, hierarchicalPathPattern, 2);
        if (hierarchicalPathPattern.length() == 0) {
            hierarchicalPathPattern.append(macroCallText);
        }
        Matcher hidMatcher = Pattern.compile("\\b" + hierarchicalPathPattern.toString() + "\\b", 8).matcher(macroCallText);
        MacroCallSearchStatus info = new MacroCallSearchStatus(hidMatcher, macroCallText);
        macroInfoMap.put(hid, info);
        return info;
    }

    private void computeHierarchicalPathPattern(Hid hid, StringBuilder result, int depth) {
        if (hid == null || result == null) {
            return;
        }
        HidAccess parentAccess = hid.getParentAccess();
        if (depth == 2) {
            if (parentAccess == null || parentAccess.getAccessKind() == 3) {
                result.insert(0, hid.getName());
            } else {
                result.insert(0, "\\s*" + hid.getName());
            }
        } else if (depth == 1) {
            result.insert(0, String.valueOf(hid.getName()) + "\\s*");
        }
        if (parentAccess == null || parentAccess.getAccessKind() == 3) {
            return;
        }
        result.insert(0, ".");
        Hid parentHid = parentAccess.getParentHid();
        this.computeHierarchicalPathPattern(parentHid, result, depth - 1);
    }

    private static class MacroCallSearchStatus {
        private Matcher fMatcher;
        private String fMacroCallText;

        public MacroCallSearchStatus(Matcher matcher, String macroCallText) {
            this.fMatcher = matcher;
            this.fMacroCallText = macroCallText;
        }
    }

    private static class ModeCallInfo {
        HidOccurrence hit;
        IRfScopeElement scope;
        String mode;

        public ModeCallInfo(HidOccurrence hit, IRfScopeElement scope, String mode) {
            this.hit = hit;
            this.scope = scope;
            this.mode = mode;
        }
    }

    private static class TextOffset {
        private String text;
        private int offset;

        public TextOffset(String text, int offset) {
            this.text = text;
            this.offset = offset;
        }
    }
}

