/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.importpakcage;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.search.importpakcage.ImportSearchResult;
import ro.amiq.vlogdt.ui.search.text.FileMatch;

public class ImportOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private IRfScopeElement fScope;
    private ParserPath fParserPath;
    private RfPackage fPackage;
    private ImportSearchResult fResult;
    private RfProject fRfProject;

    public ImportOperatorVisitor(RfPackage pack, ImportSearchResult result) {
        this.fPackage = pack;
        this.fRfProject = pack.getEnclosingScope(RfProject.class);
        this.fResult = result;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_IMPORT)) {
            return true;
        }
        IHidObject pkgHidObject = hidOperator.getLHValue();
        if (!(pkgHidObject instanceof RfHidImplicit)) {
            return true;
        }
        List packages = this.fScope.getPackagesWithPrefix(((RfHidImplicit)pkgHidObject).getName(), 1);
        if (!packages.contains(this.fPackage)) {
            return true;
        }
        IFile file = DVTFileUtils.getInstance().findProjectFile(this.fRfProject.getProject(), this.fParserPath.path);
        if (file == null) {
            return true;
        }
        HidOperatorOccurrence firstImportOccurrence = hidOperator.getOccurrence(HidOperatorQualifier.IS_IMPORT.value());
        if (firstImportOccurrence == null) {
            return true;
        }
        int line = firstImportOccurrence.getLine();
        if (line == -1) {
            return true;
        }
        int lineStart = DVTFileUtils.getInstance().getLineOffset(file, line);
        if (lineStart == -1) {
            return true;
        }
        int lineLength = DVTFileUtils.getInstance().getLineLength(file, line);
        if (lineLength == -1) {
            return true;
        }
        String lineContents = DVTFileUtils.getInstance().getLineFromFile(file, line);
        LineElement lineEntry = new LineElement((IResource)file, line, lineStart, lineContents);
        FileMatch match = new FileMatch(file, firstImportOccurrence.getOffset() - this.fPackage.getName().length(), this.fPackage.getName().length(), false, lineEntry);
        this.fResult.addMatch((Match)match);
        return true;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setHolder(IHidHolder holder) {
        if (holder != null) {
            this.fScope = ((RfHidHolder)holder).getScope();
        }
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }
}

