/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.importpakcage;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import ro.amiq.dvt.ui.search.BaseSearchQuery;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.search.importpakcage.ImportOperatorVisitor;
import ro.amiq.vlogdt.ui.search.importpakcage.ImportSearchResult;

public class ImportSearchQuery
extends BaseSearchQuery {
    private RfPackage fRfPackage;
    private ImportSearchResult fSearchResult;
    private RfProject fRfProject;

    public ImportSearchQuery(RfPackage rfPackage) {
        this.fRfPackage = rfPackage;
        this.fRfProject = this.fRfPackage.getEnclosingScope(RfProject.class);
        this.fSearchResult = new ImportSearchResult((ISearchQuery)this);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.fSearchResult.removeAll();
        ImportOperatorVisitor visitor = new ImportOperatorVisitor(this.fRfPackage, this.fSearchResult);
        this.fRfProject.visitHidObject(null, visitor);
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return "Package imports - '" + this.fRfPackage.getName() + "' - " + this.fSearchResult.getMatchCount() + " matches in '" + this.fRfProject.getProject().getName() + "'";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fSearchResult;
    }
}

