/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class ForceHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private ParserPath fParserPath;
    private int fCheckForQueryInterruptionCounter = 0;
    private IProgressMonitor fProgressMonitor;
    private DocumentManager fDocumentManager;
    private IReportHitsListener<SearchHit> fListener;
    private IProject fProject;
    private FileSynchedAndAvailableManager fFileManager;

    public ForceHidOperatorVisitor(IProgressMonitor progressMonitor, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, IReportHitsListener<SearchHit> reportHitsListener, IProject project) {
        this.fProgressMonitor = progressMonitor;
        this.fDocumentManager = documentManager;
        this.fListener = reportHitsListener;
        this.fProject = project;
        this.fFileManager = fileManager;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        if (!hidOperator.hasOccurrence(HidQualifierCache.IS_PROCEDURAL_FORCE_ASSIGN_QUALIFIER)) {
            return true;
        }
        IHidObject lhHidObject = hidOperator.getLHValue();
        if (!HidUtils.isHid((IHidObject)lhHidObject)) {
            return true;
        }
        Hid hid = (Hid)lhHidObject;
        this.addMatch(hid);
        return true;
    }

    private void addMatch(Hid hid) {
        if (hid == null || hid.getOccurrence() == null) {
            return;
        }
        try {
            HidOccurrence occurrence = hid.getOccurrence();
            if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
                return;
            }
            IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
            if (document == null) {
                return;
            }
            int line = occurrence.getLine();
            int offset = occurrence.getOffset();
            IRegion lineInformation = document.getLineInformation(line - 1);
            if (lineInformation == null) {
                return;
            }
            String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
            int lineStart = lineInformation.getOffset();
            VlogSearchHit searchHit = new VlogSearchHit(this.fParserPath, line, offset, lineContents, hid.getName().length(), this.fProject, null);
            int counter = RfReferencesUtils.countStartWS((IDocument)document, (IRegion)lineInformation);
            if (counter >= 0) {
                searchHit.setSearchedElement(hid.getName(), offset - lineStart - counter, false);
            }
            this.fListener.addMatch((Object)searchHit);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }
}

