/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.new_engine.SignalReadWriteVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.VlogHidMatch;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class MultiReferenceHidSearchVisitor
extends RfHidVisitor {
    private static final String[] PREDEFINED_QUEUE_FUNCTIONS_STRING = new String[]{"push_back", "push_front", "insert"};
    private static final Set<String> PREDEFINED_QUEUE_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_QUEUE_FUNCTIONS_STRING));
    private static final String[] PREDEFINED_RW_QUEUE_FUNCTIONS_STRING = new String[]{"pop_back", "pop_front"};
    private static final Set<String> PREDEFINED_RW_QUEUE_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_RW_QUEUE_FUNCTIONS_STRING));
    public static final int BUFFER_SIZE = 524288;
    private List<IRfNamedElement> fRfElements;
    private boolean fIsStrictVirtualFunction;
    private IProject fProject;
    private RfProject fRfProject;
    private boolean fForRefactor;
    private Map<OffsetNamedElementFilePair, MacroCallHitsInfo> fMacroInfoMap;
    private DocumentManager fDocumentManager;
    private IProgressMonitor fProgressMonitor;
    private int fCheckForQueryInterruptionCounter;
    private boolean fIncludeDeclarations;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private boolean fSemanticSearch;
    private Map<RfFunction, LinkedHashSet<RfClass>> fFunctionClassFamily;
    private String fSearchedString;
    private Map<IRfScopeElement, List<VlogHidMatch>> fHitBuffer = new LinkedHashMap<IRfScopeElement, List<VlogHidMatch>>();
    private IRfScopeElement fHolderScope;
    private RfTypesResolver fResolver;
    private boolean fDisableHitInMacroArgument;

    public MultiReferenceHidSearchVisitor(IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, List<IRfNamedElement> elements, String searchedString, boolean semanticSearch, boolean isStrictVirtualFunction, IProject project, boolean forRefactor, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, DocumentManager documentManager, boolean includeDeclarations, IReportHitsListener<SearchHit> listener, Map<RfFunction, LinkedHashSet<RfClass>> functionClassFamily, RfTypesResolver resolver, boolean disableHitInMacroArgument) {
        this.fRfElements = elements;
        this.fSearchedString = searchedString;
        this.fSemanticSearch = semanticSearch;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        this.fIsStrictVirtualFunction = isStrictVirtualFunction;
        this.fForRefactor = forRefactor;
        this.fMacroInfoMap = macroInfoMap;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fFunctionClassFamily = functionClassFamily;
        this.fResolver = resolver;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
    }

    @Override
    public void setHolder(IHidHolder holder) {
        super.setHolder(holder);
        if (!(holder instanceof RfHidHolder)) {
            return;
        }
        RfHidHolder rfHidHolder = (RfHidHolder)holder;
        this.fHolderScope = rfHidHolder.getScope();
        if (this.fHitBuffer.isEmpty()) {
            return;
        }
        IRfScopeElement firstBufferedScope = this.fHitBuffer.keySet().iterator().next();
        if (this.isParentScope(firstBufferedScope, this.fHolderScope)) {
            return;
        }
        try {
            this.reportFromBuffer();
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isParentScope(IRfScopeElement parent, IRfScopeElement child) {
        while (child != parent) {
            if ((child = child.getEnclosingScope()) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(RfHid hid) {
        try {
            IRfNamedElement element;
            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException("Operation Canceled");
                }
                this.fCheckForQueryInterruptionCounter = 0;
            }
            if (hid.getParentAccess() != null && hid.getParentAccess().getAccessKind() == 4) {
                return true;
            }
            String hidName = hid.getName();
            if (hidName == null) {
                return true;
            }
            RfTypesResolver resolver = RfTypesResolver.create(this.fHolderScope, this.fRfProject, 8);
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)((IRfNamedElement)this.fHolderScope), null, (boolean)true, (ELManager)this.fRfProject.getELManager());
            resolver.resolveHidInContext((IHidObject)hid.upwardsCopy(true), guardian, false);
            Iterator<IRfNamedElement> iterator = this.fRfElements.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                element = iterator.next();
                if (this.fCheckForQueryInterruptionCounter++ == 10) {
                    if (this.fProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException("Operation Canceled");
                    }
                    this.fCheckForQueryInterruptionCounter = 0;
                }
                if (!hidName.equals(element.getName())) continue;
                IRfNamedElement foundElement = hid.getElement();
                if (foundElement == null) {
                    this.addReferenceMatch(true, hid, null, element);
                    return true;
                }
                if (VlogRfReferencesUtils.checkEquals(element, this.fResolver, foundElement, resolver, this.fIsStrictVirtualFunction, this.fFunctionClassFamily)) break;
            }
            this.addReferenceMatch(false, hid, null, element);
            return true;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void addMatch(boolean isPossibleMatch, IDocument openDocument, RfHid hid, SearchMatchKindsWrapper searchKindWrapper, IRfNamedElement element) {
        this.computeReadersWritersHits(isPossibleMatch, openDocument, hid, searchKindWrapper, element);
    }

    private void computeReadersWritersHits(boolean isPossibleMatch, IDocument openDocument, RfHid hid, SearchMatchKindsWrapper searchKindWrapper, IRfNamedElement element) {
        List<VlogHidMatch> scopeHits = this.fHitBuffer.get(this.fHolderScope);
        if (scopeHits == null) {
            scopeHits = new ArrayList<VlogHidMatch>();
            this.fHitBuffer.put(this.fHolderScope, scopeHits);
        }
        scopeHits.add(new VlogHidMatch(isPossibleMatch, openDocument, hid, searchKindWrapper, this.parserPath, element));
    }

    private void reportOccurences(HidMatch hidMatch, IRfScopeElement topScope) throws Exception {
        HidOccurrence occurence;
        boolean isPossibleMatch = hidMatch.isPossibleMatch();
        IDocument openDocument = hidMatch.getOpenDocument();
        Hid hid = hidMatch.getHid();
        RfFunction.FunctionCallKind functionCallType = null;
        RfField.TypeCompatibilityMatchKind classFieldType = null;
        if (hidMatch instanceof VlogHidMatch) {
            functionCallType = ((VlogHidMatch)hidMatch).getFunctionCallType();
            classFieldType = ((VlogHidMatch)hidMatch).getClassFieldType();
        }
        if ((occurence = hid.getOccurrence()) == null) {
            return;
        }
        if (occurence.hasQualifier(HidQualifierCache.CONSTRUCTOR_DECLARATION)) {
            return;
        }
        if (this.fCheckForQueryInterruptionCounter++ == 10) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        IRfNamedElement element = hidMatch.getRfElement();
        RWKind writeAccess = hidMatch.getAccess();
        if (virtualOffset == -1) {
            this.addHitOccurence(false, offset, openDocument, isPossibleMatch, functionCallType, classFieldType, occurence.getLine(), null, writeAccess, hidMatch.getParserPath(), hidMatch.isFromDefparam(), hid, topScope, element);
        } else {
            MacroCallHitsInfo computeMacroHit = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, element, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), hidMatch.getParserPath(), openDocument, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (computeMacroHit == null) {
                return;
            }
            if (computeMacroHit.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, offset, openDocument, isPossibleMatch, functionCallType, classFieldType, -1, computeMacroHit.getMacroCallText(), writeAccess, hidMatch.getParserPath(), hidMatch.isFromDefparam(), hid, topScope, element);
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = computeMacroHit.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallparameterHit : macroCallParameterHits) {
                if (macroCallparameterHit.getText().isEmpty()) continue;
                offset = macroCallparameterHit.getOffset();
                this.addHitOccurence(false, offset, openDocument, isPossibleMatch, functionCallType, classFieldType, -1, computeMacroHit.getMacroCallText(), writeAccess, hidMatch.getParserPath(), hidMatch.isFromDefparam(), hid, topScope, element);
            }
        }
    }

    private void addReferenceMatch(boolean isPossibleMatch, RfHid hid, SearchMatchKindsWrapper searchKindWrapper, IRfNamedElement element) {
        if (hid == null) {
            return;
        }
        if (!this.fFileManager.isSynchedFile(this.parserPath, this.fProject)) {
            return;
        }
        IDocument openDocument = this.fDocumentManager.getDocument(this.parserPath, this.fProject);
        if (openDocument == null) {
            return;
        }
        this.addMatch(isPossibleMatch, openDocument, hid, searchKindWrapper, element);
    }

    private boolean addHitOccurence(boolean isNonParameterHit, int offset, IDocument openDocument, boolean isPossibleMatch, RfFunction.FunctionCallKind type, RfField.TypeCompatibilityMatchKind classFieldType, int line, String macroCallText, RWKind written, ParserPath parserPath, boolean isFromDefparam, Hid hid, IRfScopeElement topScope, IRfNamedElement element) throws Exception {
        String highlightName;
        if (line == -1) {
            line = openDocument.getLineOfOffset(offset) + 1;
        }
        IRegion info = openDocument.getLineInformation(line - 1);
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int lineOffset = openDocument.getLineOffset(line - 1);
        int matchLength = isNonParameterHit ? lineContents.trim().length() : (!this.fIncludeDeclarations ? hid.getName().length() : element.getName().length());
        boolean isEscaped = offset - lineOffset >= 0 && offset - lineOffset < lineContents.length() && lineContents.charAt(offset - lineOffset) == '\\';
        String string = highlightName = this.fIncludeDeclarations ? element.getName() : hid.getName();
        if (isEscaped) {
            ++matchLength;
        }
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        if (VlogRfReferencesUtils.shouldSkipFunctionUsage(type, this.fIncludeDeclarations, hid, element.getEnclosingScope(), this.fHolderScope)) {
            return true;
        }
        VlogSearchHit lineEntry = new VlogSearchHit(parserPath, line, offset, lineContents, matchLength, new SearchMatchKindsWrapper(type, classFieldType), isNonParameterHit, true, null, element, this.fProject, hid);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)line, (int)offset, (boolean)isPossibleMatch));
        int highlightOffset = offset;
        if (isEscaped) {
            ++highlightOffset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, highlightOffset - lineOffset - counter, isPossibleMatch);
        }
        lineEntry.setIsEscaped(isEscaped);
        lineEntry.setSemanticScope(topScope);
        lineEntry.setVirtualOffset(hid == null ? -1 : hid.getVirtualOffset());
        lineEntry.setAccess(written);
        if (isFromDefparam) {
            lineEntry.setFromDefparam();
        }
        if (hid != null && hid.getParentAccess() != null) {
            lineEntry.setIsInsideHierarchicalAccess();
        }
        this.fListener.addMatch((Object)lineEntry);
        return true;
    }

    public void reportFromBuffer() throws Exception {
        if (this.fHitBuffer == null || this.fHitBuffer.isEmpty()) {
            return;
        }
        IRfScopeElement topScope = this.fHitBuffer.keySet().iterator().next();
        if (!(topScope instanceof RfNamedElement)) {
            return;
        }
        IdentityHashMap<Hid, HidMatch> rwMap = new IdentityHashMap<Hid, HidMatch>();
        this.fHitBuffer.values().forEach(x -> x.forEach(y -> {
            VlogHidMatch vlogHidMatch = rwMap.put(y.getHid(), (HidMatch)y);
        }));
        this.fHitBuffer.clear();
        ((IRfNamedElement)topScope).visitHidObject((IRfSingleLangProject)this.fRfProject, (IHidVisitor)new SignalReadWriteVisitor(rwMap));
        for (HidMatch hidMatch : rwMap.values()) {
            if (VlogRfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)hidMatch.getRfElement(), (IRfNamedElement)hidMatch.getHid().getElement()) && hidMatch.getAccess() == RWKind.NONE) {
                boolean shouldBeMarkedAsReadWrite = this.hasPredefinedOrUserDefinedReadWriteAPI(hidMatch);
                if (shouldBeMarkedAsReadWrite) {
                    hidMatch.addReadOccurence(hidMatch.getHid().getOccurrence());
                    hidMatch.addWriteOccurence(hidMatch.getHid().getOccurrence());
                } else {
                    boolean shouldBeMarkedAsWrite = this.hasPredefinedOrUserDefinedWriteAPI(hidMatch);
                    if (shouldBeMarkedAsWrite) {
                        hidMatch.addWriteOccurence(hidMatch.getHid().getOccurrence());
                    } else if (this.shouldMarkAsRead(hidMatch)) {
                        hidMatch.addReadOccurence(hidMatch.getHid().getOccurrence());
                    }
                }
            }
            this.reportOccurences(hidMatch, topScope);
        }
    }

    private boolean hasPredefinedOrUserDefinedWriteAPI(HidMatch hidMatch) {
        Hid hid = hidMatch.getHid();
        if (hid == null) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return false;
        }
        ListContainer accesses = hid.getAccesses();
        if (accesses == null || accesses.isEmpty()) {
            return false;
        }
        HidAccess hidAccess = (HidAccess)accesses.get(0);
        if (hidAccess == null) {
            return false;
        }
        boolean hasListType = false;
        ListContainer hidAccessHids = hidAccess.getHids();
        if (hidAccessHids != null) {
            for (Hid hidAccessHid : hidAccessHids) {
                IRfNamedElement hidAccessElement = hidAccessHid.getElement();
                if (!(hidAccessElement instanceof RfPredefinedFunction) || !PREDEFINED_QUEUE_FUNCTIONS.contains(hidAccessElement.getName())) continue;
                if (!hasListType) {
                    RfField field = (RfField)element;
                    IRfNamedElement associatedType = field.getAssociatedType();
                    while (associatedType instanceof RfTypeAlias) {
                        associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
                    }
                    hasListType = associatedType instanceof RfListType;
                }
                if (!hasListType) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPredefinedOrUserDefinedReadWriteAPI(HidMatch hidMatch) {
        Hid hid = hidMatch.getHid();
        if (hid == null) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return false;
        }
        ListContainer accesses = hid.getAccesses();
        if (accesses == null || accesses.isEmpty()) {
            return false;
        }
        HidAccess hidAccess = (HidAccess)accesses.get(0);
        if (hidAccess == null) {
            return false;
        }
        boolean hasListType = false;
        ListContainer hidAccessHids = hidAccess.getHids();
        if (hidAccessHids != null) {
            for (Hid hidAccessHid : hidAccessHids) {
                IRfNamedElement hidAccessElement = hidAccessHid.getElement();
                if (!(hidAccessElement instanceof RfPredefinedFunction) || !PREDEFINED_RW_QUEUE_FUNCTIONS.contains(hidAccessElement.getName())) continue;
                if (!hasListType) {
                    RfField field = (RfField)element;
                    IRfNamedElement associatedType = field.getAssociatedType();
                    while (associatedType instanceof RfTypeAlias) {
                        associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
                    }
                    hasListType = associatedType instanceof RfListType;
                }
                if (!hasListType) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldMarkAsRead(HidMatch hidMatch) {
        Collection declarations;
        boolean markAsRead = true;
        if (hidMatch.getRfElement() instanceof RfPort && (declarations = hidMatch.getRfElement().getDeclarations()) != null) {
            for (IRfDefElement declaration : declarations) {
                if (hidMatch.getHid().getOccurrence().getLine() != declaration.getStartLine()) continue;
                markAsRead = false;
                break;
            }
        }
        return markAsRead;
    }
}

