/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.FilesAndProjectsOfScopeCalculator;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.text.FileMatch;
import ro.amiq.vlogdt.ui.search.text.FileSearchQuery;

public class NewHidsSearchEngine
extends TextSearchEngine {
    public static final String LOG_NEW_MESSAGE_PREFIX = "[REFERENCES ENGINE BENCHMARK] VLOGDT - NEW SEARCH ENGINE - time for references of ";
    private boolean fIncludeDeclarations;
    private boolean fForRefactor;
    private String fSearchString;
    private String fSearchType;
    private IRfNamedElement fRfElement;
    private ElementPath fDesignContextPath;
    private AbstractTextSearchResult fResult;
    private HashSet<BaseFileMatch> fCachedMatches;
    private boolean fIsStrictVirtual;
    private IProgressMonitor fProgressMonitor;
    private ParserPath fCurrentParserPath;
    private IProject fProject;
    private FilesAndProjectsOfScopeCalculator fCalculator;
    private RWSearchTypeEnum fSearchRWType;
    private Set<RfFunction> fPotentialGetters;
    private Set<RfFunction> fPotentialSetters;
    private Map<LineElement, IRfNamedElement> fDesignContextPathMap;
    private FileSearchQuery fQuery;
    private boolean fDisableHitInMacroArgument;

    public NewHidsSearchEngine(boolean includeDeclarations, FileSearchQuery query, RWSearchTypeEnum searchRWType, IProject project) {
        this.fIncludeDeclarations = includeDeclarations;
        this.fSearchType = query.getSearchType();
        this.fQuery = query;
        this.fSearchString = query.getSearchString();
        this.fCurrentParserPath = null;
        this.fProject = project;
        this.fSearchRWType = searchRWType;
        this.fCachedMatches = new HashSet();
        this.fPotentialGetters = new LinkedHashSet<RfFunction>();
        this.fPotentialSetters = new LinkedHashSet<RfFunction>();
        this.fDesignContextPathMap = new HashMap<LineElement, IRfNamedElement>();
    }

    public IStatus search(TextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        return null;
    }

    public IStatus search(IFile[] scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        return null;
    }

    public IStatus search(IRfNamedElement namedElement, ElementPath designContextPath, RfTypesResolver resolver, FileTextSearchScope scope, Pattern searchPattern, IProgressMonitor monitor, boolean forRefactoring, boolean isStrictVirtualFunction, AbstractTextSearchResult result, String searchedString, BiPredicate<IHidObject, IRfClassElement> filterPredicate, boolean disableHitInMacroArgument) {
        this.fRfElement = namedElement;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
        this.fDesignContextPath = designContextPath;
        if (this.fRfElement instanceof RfForwardTypedef) {
            this.fRfElement = ((RfForwardTypedef)this.fRfElement).getResolvedType(true);
        }
        this.fCalculator = new FilesAndProjectsOfScopeCalculator((TextSearchScope)scope);
        this.fResult = result;
        this.fForRefactor = forRefactoring;
        this.fIsStrictVirtual = isStrictVirtualFunction;
        Object object = this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        if (namedElement == null) {
            return Status.OK_STATUS;
        }
        try {
            String patternText = this.fRfElement.getName();
            String type = this.fSearchType.toLowerCase();
            String taskName = MessageFormat.format(SearchMessages.TextSearchVisitor_hidssearch_task_label, type, patternText);
            HashSet<SearchHit> allMatches = new HashSet<SearchHit>();
            Map parserPathMap = this.fCalculator.getFilesMap();
            FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles((Map)parserPathMap), this.fProgressMonitor, false);
            IReportHitsListener<SearchHit> reportHitsListener = this.getReportMatchesListener(allMatches, filterPredicate);
            this.fProgressMonitor.beginTask(taskName, 100);
            long startTime = System.currentTimeMillis();
            this.computeSearch(reportHitsListener, resolver, searchPattern, parserPathMap, fileManager, searchedString);
            VlogRfReferencesUtils.findDesignContextForMatches(this.fDesignContextPathMap, designContextPath, this.fProject);
            VlogRfReferencesUtils.flushMatches(this.fCachedMatches, (AbstractTextSearchResult)this.fResult);
            VlogRfGUIReferencesUtils.logComputeReferencesTime(this.fRfElement, startTime);
            this.fQuery.setUnsynchedMatches(fileManager.getUnsynchedFiles());
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (RfNamedElementVisitorException e) {
            if (!(e.getCause() instanceof OperationCanceledException)) {
                DVTLogger.INSTANCE.logError(e.getCause());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            this.fProgressMonitor.done();
            VlogRfReferencesUtils.flushMatches(this.fCachedMatches, (AbstractTextSearchResult)this.fResult);
        }
        return Status.OK_STATUS;
    }

    private IReportHitsListener<SearchHit> getReportMatchesListener(final Set<SearchHit> allMatches, final BiPredicate<IHidObject, IRfClassElement> filterPredicate) {
        return new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                try {
                    IFile file;
                    ParserPath parserPath = match.getParserPath();
                    if (parserPath == null) {
                        return;
                    }
                    if (!parserPath.equals((Object)NewHidsSearchEngine.this.fCurrentParserPath)) {
                        NewHidsSearchEngine.this.fCurrentParserPath = parserPath;
                        VlogRfReferencesUtils.flushMatches(NewHidsSearchEngine.this.fCachedMatches, (AbstractTextSearchResult)NewHidsSearchEngine.this.fResult);
                    }
                    if ((file = DVTFileUtils.getInstance().findProjectFile(match.getProject(), parserPath.path)) == null) {
                        return;
                    }
                    if (!NewHidsSearchEngine.this.fIncludeDeclarations && !NewHidsSearchEngine.this.fForRefactor && NewHidsSearchEngine.this.fRfElement instanceof RfField && ((RfField)NewHidsSearchEngine.this.fRfElement).isField() && NewHidsSearchEngine.this.fRfElement.getEnclosingScope() instanceof RfClass) {
                        VlogRfReferencesUtils.computeGettersSetters(NewHidsSearchEngine.this.fSearchRWType, match, (RfClass)NewHidsSearchEngine.this.fRfElement.getEnclosingScope(), NewHidsSearchEngine.this.fRfElement, NewHidsSearchEngine.this.fPotentialGetters, NewHidsSearchEngine.this.fPotentialSetters);
                    }
                    LineElement element = VlogRfReferencesUtils.computeLineElementHit(file, match);
                    element.setExtraInfo(match.getExtraInfo());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    if (NewHidsSearchEngine.this.fSearchRWType == RWSearchTypeEnum.GETTERS) {
                        match.setAccess(RWKind.GETTER);
                    } else if (NewHidsSearchEngine.this.fSearchRWType == RWSearchTypeEnum.SETTERS) {
                        match.setAccess(RWKind.SETTER);
                    }
                    element.setWriteAccess(match.getAccess());
                    element.setElaborationHit(match.isElaborationHit());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                    fileMatch.setHitType(match.getHitType());
                    fileMatch.setInstance(match.getInstance());
                    fileMatch.setIsEscaped(match.isEscaped());
                    this.saveScopeToComputePath(match, element);
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    if (VlogRfReferencesUtils.shouldSkipReadersWritersUsages((RWSearchTypeEnum)NewHidsSearchEngine.this.fSearchRWType, (RWKind)match.getAccess())) {
                        return;
                    }
                    NewHidsSearchEngine.this.fCachedMatches.add(fileMatch);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            private void saveScopeToComputePath(SearchHit match, LineElement element) {
                if (NewHidsSearchEngine.this.fDesignContextPath == null) {
                    element.setOutsideCurrentDesignContext(false);
                    return;
                }
                IRfDefElement realScope = RfSearchUtils.getScope((IProject)NewHidsSearchEngine.this.fProject, (ParserPath)match.getParserPath(), (int)match.getLine(), (int)match.getOffset());
                if (realScope == null) {
                    element.setOutsideCurrentDesignContext(true);
                    return;
                }
                if (match.isInsideHierarchicalAccess() && !(realScope instanceof RfInstanceDef)) {
                    element.setOutsideCurrentDesignContext(false);
                    return;
                }
                if (!(realScope instanceof RfDefElement)) {
                    element.setOutsideCurrentDesignContext(false);
                    return;
                }
                IRfNamedElement namedElement = VlogRfReferencesUtils.getNamedElementWithDesignPath(realScope.getNamedElement());
                if (namedElement == null) {
                    element.setOutsideCurrentDesignContext(false);
                    return;
                }
                NewHidsSearchEngine.this.fDesignContextPathMap.put(element, namedElement);
            }

            public Set<SearchHit> getMatches() {
                return allMatches;
            }

            public boolean shouldFilterIHidObject(IHidObject hidObject, IRfClassElement enclosingScope) {
                if (filterPredicate == null) {
                    return false;
                }
                return filterPredicate.test(hidObject, enclosingScope);
            }
        };
    }

    private void computeSearch(IReportHitsListener<SearchHit> reportHitsListener, RfTypesResolver resolver, Pattern searchPattern, Map<IProject, Set<ParserPath>> hashMap, FileSynchedAndAvailableManager fileManager, String searchedString) {
        if (VlogRfGUIReferencesUtils.isSemanticSearch(this.fRfElement)) {
            VlogRfReferencesUtils.logDebug((String)("[SEARCH ENGINE TRIGGERED FROM VLOG FILE] Computing semantic search for " + this.fRfElement.getKindName() + " '" + this.fRfElement.getName() + "'"));
            this.computeSemanticSearchMatches(reportHitsListener, searchPattern, hashMap, fileManager);
        } else {
            VlogRfReferencesUtils.logDebug((String)("[SEARCH ENGINE TRIGGERED FROM VLOG FILE] Computing references for " + this.fRfElement.getKindName() + " '" + this.fRfElement.getName() + "'"));
            this.computeReferencesMatches(reportHitsListener, resolver, hashMap, fileManager, searchedString);
        }
    }

    private void computeReferencesMatches(IReportHitsListener<SearchHit> reportHitsListener, RfTypesResolver resolver, Map<IProject, Set<ParserPath>> hashMap, FileSynchedAndAvailableManager fileManager, String searchedString) {
        RfSearchUtils.computeReferences(reportHitsListener, (IProject)this.fProject, (IRfNamedElement)this.fRfElement, (IHidEvaluator)resolver, (String)searchedString, (IProgressMonitor)this.fProgressMonitor, hashMap, (FileSynchedAndAvailableManager)fileManager, (boolean)this.fIncludeDeclarations, (boolean)this.fForRefactor, (boolean)this.fIsStrictVirtual, (boolean)false, (boolean)this.fDisableHitInMacroArgument);
        RWSearchTypeEnum initialState = this.fSearchRWType;
        this.fSearchRWType = RWSearchTypeEnum.GETTERS;
        for (RfFunction function : this.fPotentialGetters) {
            RfSearchUtils.computeReferences(reportHitsListener, (IProject)this.fProject, (IRfNamedElement)function, (IHidEvaluator)resolver, (String)function.getName(), (IProgressMonitor)this.fProgressMonitor, hashMap, (FileSynchedAndAvailableManager)fileManager, (boolean)this.fIncludeDeclarations, (boolean)this.fForRefactor, (boolean)true, (boolean)false, (boolean)this.fDisableHitInMacroArgument);
        }
        this.fSearchRWType = RWSearchTypeEnum.SETTERS;
        for (RfFunction function : this.fPotentialSetters) {
            RfSearchUtils.computeReferences(reportHitsListener, (IProject)this.fProject, (IRfNamedElement)function, (IHidEvaluator)resolver, (String)function.getName(), (IProgressMonitor)this.fProgressMonitor, hashMap, (FileSynchedAndAvailableManager)fileManager, (boolean)this.fIncludeDeclarations, (boolean)this.fForRefactor, (boolean)true, (boolean)false, (boolean)this.fDisableHitInMacroArgument);
        }
        this.fSearchRWType = initialState;
    }

    private void computeSemanticSearchMatches(IReportHitsListener<SearchHit> reportHitsListener, Pattern searchPattern, Map<IProject, Set<ParserPath>> hashMap, FileSynchedAndAvailableManager fileManager) {
        Set projects = this.fCalculator.getProjects();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        for (IProject project : projects) {
            VlogRfGUIReferencesUtils.computeMatchesForSemanticSearch(reportHitsListener, searchPattern, project, this.fRfElement, this.fProgressMonitor, hashMap, fileManager, this.fIncludeDeclarations, this.fForRefactor, this.fIsStrictVirtual, this.fDisableHitInMacroArgument);
        }
    }
}

