/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;
import ro.amiq.vlogdt.utils.VlogLinkResolver;

public class ReferenceCommentDefElementVisitor
implements IRfDefElementVisitor {
    private static final String PATH = "path";
    private static final String PACKAGE_NAME = "packageName";
    private static final String ELEMENT_NAME = "elementName";
    private static final Pattern DOT = Pattern.compile("\\.");
    private Pattern pattern;
    private String elementName;
    private IRfNamedElement element;
    private IReportHitsListener<SearchHit> listener;
    private DocumentManager documentManager;
    private IProject project;
    private RfProject rfProject;
    private boolean isStrictVirtual;

    public ReferenceCommentDefElementVisitor(IRfNamedElement element, DocumentManager documentManager, RfProject rfProject, IReportHitsListener<SearchHit> listener, boolean isStrictVirtual) {
        this.listener = listener;
        this.element = element;
        this.elementName = element.getName();
        this.documentManager = documentManager;
        this.rfProject = rfProject;
        this.project = rfProject.getProject();
        this.isStrictVirtual = isStrictVirtual;
        StringBuilder builder = new StringBuilder();
        builder.append("(?<tag>(?:@see|@param|@link)\\h+)((?<");
        builder.append(PACKAGE_NAME);
        builder.append(">[\\w\\$]+)::)?(?<");
        builder.append(PATH);
        builder.append(">(?:[\\w\\$]+\\.)*(?<");
        builder.append(ELEMENT_NAME);
        builder.append(">");
        builder.append(this.elementName.replace("$", "\\$"));
        builder.append("\\b))");
        this.pattern = Pattern.compile(builder.toString());
    }

    @Override
    public boolean visit(RfDefElement defElement) throws Exception {
        return true;
    }

    @Override
    public void preVisit(RfDefElement defElement) throws Exception {
        CommentBlock commentBlock = defElement.getCommentBlock();
        if (commentBlock == null) {
            return;
        }
        String comment = commentBlock.getRawUntrimmedAboveComment();
        if (comment == null || comment.isEmpty()) {
            return;
        }
        if (comment.indexOf(64) < 0) {
            return;
        }
        Collection<IRfNamedElement> candidates = null;
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null) {
            return;
        }
        IDocument document = this.documentManager.getDocument(parserPath, this.project);
        if (document == null) {
            return;
        }
        int indexOfNameInComment = -1;
        int commentStartOffset = document.getLineOffset(commentBlock.getAboveCommentStartLine() - 1);
        while ((indexOfNameInComment = comment.indexOf(this.elementName, indexOfNameInComment + 1)) > 0) {
            String currentFullLine;
            int currentLineOffset;
            int nameStartOffset = commentStartOffset + indexOfNameInComment + 1;
            int currentLine = document.getLineOfOffset(nameStartOffset);
            IRegion info = document.getLineInformation(currentLine);
            if (info == null || (currentLineOffset = info.getOffset()) < 0 || (currentFullLine = document.get(currentLineOffset, info.getLength())) == null || currentFullLine.isEmpty()) break;
            Matcher m = this.pattern.matcher(currentFullLine);
            while (m.find()) {
                candidates = this.getScopeCandidates(m.group(PACKAGE_NAME), this.rfProject, defElement.getEnclosingScope());
                if (candidates == null || candidates.isEmpty()) continue;
                String[] types = DVTStringUtil.split((Pattern)DOT, (String)m.group(PATH));
                RfNamedElement namedElement = VlogLinkResolver.resolveNamedElementFromCandidates(candidates, types, nameStartOffset, document);
                if (!VlogRfReferencesUtils.checkEquals(this.element, RfTypesResolver.create(this.element.getEnclosingScope(), this.element.getRfProject(), 8), namedElement, RfTypesResolver.create(namedElement.getEnclosingScope(), namedElement.getRfProject(), 8), this.isStrictVirtual, null)) continue;
                VlogSearchHit match = new VlogSearchHit(parserPath, currentLine, currentLineOffset + m.start(ELEMENT_NAME), currentFullLine, this.elementName.length(), this.project, null);
                match.setIsCommentHit(true);
                this.listener.addMatch((Object)match);
            }
        }
    }

    private Collection<IRfNamedElement> getScopeCandidates(String packageName, RfProject project, IRfScopeElement scope) {
        if (scope == null || project == null) {
            return Collections.emptyList();
        }
        Collection<IRfNamedElement> candidates = VlogLinkResolver.getInitialCandidatesFromScope(scope);
        if (candidates == null || candidates.isEmpty()) {
            return Collections.emptyList();
        }
        if (packageName == null || packageName.isEmpty()) {
            return candidates;
        }
        List<IRfNamedElement> packCandidates = VlogLinkResolver.getPackageCandidatesFromProject(packageName, project);
        packCandidates.addAll(candidates);
        return packCandidates;
    }

    @Override
    public void postVisit(RfDefElement defElement) throws Exception {
    }
}

