/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.HitType;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.SearchHitConnectedElementInfo;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SMethodCallInfo;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.new_engine.IReferenceHidOperatorVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallHitsInfo;
import ro.amiq.vlogdt.ui.search.new_engine.MacroCallParameterHit;
import ro.amiq.vlogdt.ui.search.new_engine.OffsetNamedElementFilePair;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class ReferenceHidOperatorVisitor
implements IReferenceHidOperatorVisitor {
    private static final String DUMMY_CHAR_STRING = "c";
    private IProject fProject;
    private RfProject fRfProject;
    private boolean fForRefactor;
    private IRfNamedElement fRfElement;
    private Map<OffsetNamedElementFilePair, MacroCallHitsInfo> fMacroInfoMap;
    private FileSynchedAndAvailableManager fFileManager;
    private static final String DOT_STAR_CONNECTION = ".*";
    private ParserPath fParserPath;
    private IRfNamedElement fScope;
    private IProgressMonitor fProgressMonitor;
    private DocumentManager fDocumentManager;
    private int fCheckForQueryInterruptionCounter = 0;
    private boolean fIncludeDeclarations;
    private boolean fIsFunctionSearch;
    private IReportHitsListener<SearchHit> fListener;
    private boolean fSemanticSearch;
    private boolean fIsStrictVirtualFunction;
    private RWKind fSearchedPortElementWriteType;
    private SMethodCallInfo fCurrentMethodCall;
    private boolean fIsClassFieldOrFunctionArgumentSearch;
    private RenameAcrossHierarchyInfo fRenameAcrossHierarchyInfo;
    private String fCurrentConnectedElement;
    private Map<Integer, List<SearchedElementWrapper>> fSearchedElementsWithRelativeDepthsInfo;
    private SearchedElementWrapper fCurrentSearchedElementPair;
    private Map<RfFunction, LinkedHashSet<RfClass>> fFunctionClassFamily;
    private boolean assumeHitWhenSameNameAndType;
    private RfTypesResolver fResolver;
    private boolean fDisableHitInMacroArgument;

    public ReferenceHidOperatorVisitor(IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, boolean semanticSearch, boolean isStrictVirtualFunction, IProject project, boolean forRefactor, Map<OffsetNamedElementFilePair, MacroCallHitsInfo> macroInfoMap, DocumentManager documentManager, boolean includeDeclarations, IReportHitsListener<SearchHit> listener, Map<Integer, List<SearchedElementWrapper>> searchedElementsWithRelativeDepthsInfo, RenameAcrossHierarchyInfo renameAcrossHierarchyInfo, SearchedElementWrapper elementWrapper, Map<RfFunction, LinkedHashSet<RfClass>> functionsClassFamily, RfTypesResolver resolver, boolean disableHitInMacroArgument) {
        this.fRfElement = element;
        this.fSemanticSearch = semanticSearch;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        this.fForRefactor = forRefactor;
        this.fMacroInfoMap = macroInfoMap;
        this.fFileManager = fileManager;
        this.fIsStrictVirtualFunction = isStrictVirtualFunction;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fIsFunctionSearch = this.fRfElement instanceof RfFunction || this.fRfElement instanceof RfResultImplicitVariable;
        this.fIsClassFieldOrFunctionArgumentSearch = VlogRfReferencesUtils.isClassFieldOrFunctionArgument(this.fRfElement);
        this.fSearchedPortElementWriteType = VlogRfReferencesUtils.getPortElementWriteType((IRfNamedElement)element);
        this.fRenameAcrossHierarchyInfo = renameAcrossHierarchyInfo;
        this.fCurrentConnectedElement = null;
        this.fSearchedElementsWithRelativeDepthsInfo = searchedElementsWithRelativeDepthsInfo;
        this.fCurrentSearchedElementPair = elementWrapper;
        this.fFunctionClassFamily = functionsClassFamily;
        this.fResolver = resolver;
        this.fDisableHitInMacroArgument = disableHitInMacroArgument;
    }

    public boolean visit(RfHidOperator hidOperator) {
        IRfNamedElement[] currentOperatorLHElement;
        boolean isPortConnection;
        SearchMatchKindsWrapper searchMatchKind;
        IHidObject lhHidObject;
        ListContainer rhHidObjects;
        block15: {
            block14: {
                block13: {
                    boolean checkDotStarImplicitConnectionsReturnType;
                    block12: {
                        block11: {
                            RfClass enclosingScope;
                            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                                if (this.fProgressMonitor.isCanceled()) {
                                    throw new OperationCanceledException("Operation Canceled");
                                }
                                this.fCheckForQueryInterruptionCounter = 0;
                            }
                            if (!this.fListener.shouldFilterIHidObject((IHidObject)hidOperator, (IRfClassElement)(enclosingScope = (RfClass)this.fScope.getEnclosingScope(RfClass.class)))) break block11;
                            return true;
                        }
                        if (this.fListener.shouldSkipAssociationCheck() || hidOperator.isAssociation() || hidOperator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) break block12;
                        return true;
                    }
                    rhHidObjects = hidOperator.getRHValues();
                    lhHidObject = hidOperator.getLHValue();
                    searchMatchKind = SearchMatchKindsWrapper.getNoMatch();
                    this.fCurrentConnectedElement = null;
                    isPortConnection = hidOperator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value());
                    if (!(this.fRfElement instanceof IRfFieldElement) || !(this.fScope instanceof RfInstance) || !((RfInstance)this.fScope).hasDotStarConnection(true) || !(checkDotStarImplicitConnectionsReturnType = this.checkDotStarImplicitConnections(hidOperator))) break block13;
                    return true;
                }
                currentOperatorLHElement = new IRfNamedElement[]{null};
                if (!this.checkLeftHandSideOfOperator(lhHidObject, (ListContainer<IHidObject>)rhHidObjects, hidOperator, currentOperatorLHElement, searchMatchKind, isPortConnection)) break block14;
                return true;
            }
            if (rhHidObjects != null && !rhHidObjects.isEmpty()) break block15;
            return true;
        }
        try {
            for (IHidObject rhValue : rhHidObjects) {
                this.checkRighHandSideOfOperator(rhValue, lhHidObject, hidOperator, currentOperatorLHElement, searchMatchKind, isPortConnection, true);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void checkRighHandSideOfOperator(IHidObject rhValue, IHidObject lhHidObject, RfHidOperator hidOperator, IRfNamedElement[] lhElement, SearchMatchKindsWrapper searchMatchKind, boolean isPortConnection, boolean collectLeftElement) throws Exception {
        RfHidAccess hidAccess;
        Hid parentHid;
        if (HidUtils.isHid((IHidObject)rhValue)) {
            Hid hid = (Hid)rhValue;
            this.checkRightHandSideOfOperator(lhHidObject, hidOperator, hid, lhElement, searchMatchKind, isPortConnection, collectLeftElement);
            Hid parentHid2 = hid.getParentHid();
            while (parentHid2 != null) {
                if (VlogRfReferencesUtils.isStructField((IHid)parentHid2)) {
                    this.checkRightHandSideOfOperator(lhHidObject, hidOperator, parentHid2, lhElement, searchMatchKind, isPortConnection, collectLeftElement);
                }
                parentHid2 = parentHid2.getParentHid();
            }
        } else if (HidUtils.isOperator((IHidObject)rhValue)) {
            RfHidOperator operator = (RfHidOperator)rhValue;
            ListContainer operatorRHValues = operator.getRHValues();
            if (operatorRHValues == null || operatorRHValues.isEmpty()) {
                return;
            }
            for (IHidObject rhVal : operatorRHValues) {
                this.checkRighHandSideOfOperator(rhVal, lhHidObject, hidOperator, lhElement, searchMatchKind, isPortConnection, false);
            }
        } else if (HidUtils.isHidAccess((IHidObject)rhValue) && (parentHid = (hidAccess = (RfHidAccess)rhValue).getParentHid()) != null) {
            this.checkRightHandSideOfOperator(lhHidObject, hidOperator, parentHid, lhElement, searchMatchKind, isPortConnection, false);
        }
    }

    private boolean checkRightHandSideOfOperator(IHidObject lhHidObject, RfHidOperator hidOperator, Hid hid, IRfNamedElement[] lhElement, SearchMatchKindsWrapper searchMatchKind, boolean isPortConnection, boolean collectLeftElement) throws Exception {
        boolean isFieldClassSearch;
        IRfNamedElement rhHidElement = hid.getElement();
        String rhHidName = hid.getName();
        if (VlogRfReferencesUtils.matchesMethodArgumentForRefactoring(this.fRfElement, rhHidElement, this.fForRefactor) && this.fRfElement.getName().equals(rhHidName)) {
            this.addReferenceMatchOcc(false, (IHidObject)hid, HitType.REGULAR, searchMatchKind, this.fSearchedPortElementWriteType, LeftRightHandSideOfOperatorEnum.NEUTRAL_MATCH, new HashSet<SearchHitConnectedElementInfo>());
            return true;
        }
        boolean isPotentialMatch = this.fRfElement.getName().equals(rhHidName);
        boolean isMatch = false;
        boolean checkEquals = false;
        boolean isFunctionSearch = this.fIsFunctionSearch && (rhHidElement instanceof RfFunction || rhHidElement instanceof RfResultImplicitVariable);
        boolean bl = isFieldClassSearch = this.fIsClassFieldOrFunctionArgumentSearch && VlogRfReferencesUtils.isClassFieldOrFunctionArgument(rhHidElement);
        if (isFunctionSearch) {
            if (rhHidElement instanceof RfFunction) {
                LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)rhHidElement, this.fFunctionClassFamily);
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)(hid.getParentAccess() != null ? hid.getParentAccess().getAssociatedType() : this.fScope), this.fRfProject, 8);
                searchMatchKind = ((RfFunction)rhHidElement).computeEquals(resolver, this.fRfElement, this.fResolver, classFamily);
            }
            if (rhHidElement instanceof RfResultImplicitVariable) {
                searchMatchKind = ((RfResultImplicitVariable)rhHidElement).computeEquals(this.fRfElement);
            }
            if (searchMatchKind != null && searchMatchKind.getFunctionCallKind() != null) {
                isMatch = this.fIsStrictVirtualFunction ? searchMatchKind.getFunctionCallKind().ordinal() == RfFunction.FunctionCallKind.STRICT.ordinal() : searchMatchKind.isMatch();
            }
        } else if (isFieldClassSearch && !this.fRfElement.isPredefined()) {
            if (rhHidElement instanceof RfField) {
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, this.fRfProject, 8);
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)this.fRfProject.getELManager());
                resolver.resolveHidInContext((IHidObject)hid.upwardsCopy(true), guardian, false);
                searchMatchKind = ((RfField)rhHidElement).computeEqualsForField(resolver, this.fRfElement, this.fResolver);
            }
            if (searchMatchKind != null) {
                isMatch = searchMatchKind.isMatch();
            }
        } else {
            checkEquals = this.fRfElement.checkEquals((Object)rhHidElement);
            boolean bl2 = isMatch = isPotentialMatch && checkEquals;
        }
        if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && collectLeftElement && this.fCurrentSearchedElementPair != null && this.fScope instanceof RfInstance && VlogRfReferencesUtils.isElaboratedInstance((IRfSingleLangProject)this.fRfProject, (IRfInstanceElement)((RfInstance)this.fScope)) && isPortConnection && checkEquals) {
            this.collectLeftElement(lhHidObject);
        }
        if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && collectLeftElement && this.fScope instanceof RfInstance && checkEquals) {
            RfSearchUtils.addPreviewInfo((IRfNamedElement)((IRfNamedElement)rhHidElement.getEnclosingScope()), (IRfNamedElement)rhHidElement, (SearchedElementWrapper)this.fCurrentSearchedElementPair, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (LeftRightHandSideOfOperatorEnum)LeftRightHandSideOfOperatorEnum.RIGHT_HAND_MATCH, (boolean)false, (RenameConflictType)RenameConflictType.NO_CONFLICT, (this.fCurrentSearchedElementPair.getRelativeLevel() == 0 ? 1 : 0) != 0, (HidOperator)hidOperator);
        }
        if (isMatch || isPotentialMatch && rhHidElement == null) {
            if (VlogRfReferencesUtils.skipNonStrictMatchesInSemanticSearchMode(this.fSemanticSearch, searchMatchKind)) {
                return false;
            }
            RWKind writeAccess = RWKind.NONE;
            if (isMatch) {
                boolean isPortArgumentConnection;
                boolean bl3 = isPortArgumentConnection = hidOperator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value()) || hidOperator.hasQualifier(HidOperatorQualifier.IS_ARGUMENT_VALUE.value());
                if (lhHidObject != null && isPortArgumentConnection) {
                    writeAccess = RfSearchUtils.computePortArgumentConnectionWriteAccess((IRfNamedElement)lhElement[0], (IRfNamedElement)rhHidElement, (boolean)true, (RWKind)this.fSearchedPortElementWriteType);
                }
                if (this.isPredefinedSystemTaskWriteParameter()) {
                    writeAccess = RWKind.WRITE;
                }
                if (VlogRfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)this.fRfElement, (IRfNamedElement)rhHidElement) && writeAccess == RWKind.NONE) {
                    writeAccess = RWKind.READ;
                }
            }
            this.addReferenceMatchOcc(!isMatch, (IHidObject)hid, HitType.REGULAR, searchMatchKind, writeAccess, LeftRightHandSideOfOperatorEnum.RIGHT_HAND_MATCH, this.getConnectedElements(HidUtils.flattenToHids((IHidObject)lhHidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED)));
            return true;
        }
        return false;
    }

    private Set<SearchHitConnectedElementInfo> getConnectedElements(Set<IHid> lhHids) {
        LinkedHashSet<SearchHitConnectedElementInfo> connectedElements = new LinkedHashSet<SearchHitConnectedElementInfo>();
        for (IHid lhHid : lhHids) {
            IRfNamedElement element = lhHid.getElement();
            int line = lhHid.getLine();
            int offset = lhHid.getOffset();
            if (element == null) continue;
            connectedElements.add(new SearchHitConnectedElementInfo(element, line, offset, this.fParserPath));
        }
        return connectedElements;
    }

    private boolean checkLeftHandSideOfOperator(IHidObject lhHidObject, ListContainer<IHidObject> rhHidObjects, RfHidOperator hidOperator, IRfNamedElement[] lhElement, SearchMatchKindsWrapper searchMatchKind, boolean isPortConnection) throws Exception {
        boolean isPredefinedFunction;
        IRfNamedElement localMember;
        IHidObject lhValue;
        if (hidOperator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER) && (!(this.fScope instanceof RfStruct) || !((RfStruct)this.fScope).isEnum()) && (lhValue = hidOperator.getLHValue()) instanceof RfHidImplicit && this.fRfElement.checkEquals((Object)(localMember = this.fScope.getLocalMember(null, ((RfHidImplicit)lhValue).getName(), null)))) {
            this.addReferenceMatchOcc(false, lhValue, HitType.REGULAR, searchMatchKind, RWKind.WRITE, LeftRightHandSideOfOperatorEnum.NEUTRAL_MATCH, this.getConnectedElements(HidUtils.flattenToHids((List)OptimizedUtils.asList(rhHidObjects, (boolean)false), (Set)HidFlatteningOption.IMPLICITS_EXCLUDED)));
            return true;
        }
        if (!HidUtils.isHid((IHidObject)lhHidObject)) {
            return false;
        }
        Hid lhHid = (Hid)lhHidObject;
        IRfNamedElement lhHidElement = lhHid.getElement();
        String lhHidName = lhHid.getName();
        lhElement[0] = lhHidElement;
        if (VlogRfReferencesUtils.matchesMethodArgumentForRefactoring(this.fRfElement, lhHidElement, this.fForRefactor) && this.fRfElement.getName().equals(lhHidName)) {
            this.addReferenceMatchOcc(false, (IHidObject)lhHid, HitType.REGULAR, searchMatchKind, this.fSearchedPortElementWriteType, LeftRightHandSideOfOperatorEnum.NEUTRAL_MATCH, new HashSet<SearchHitConnectedElementInfo>());
        }
        boolean bl = isPredefinedFunction = lhHidElement instanceof IRfFieldElement && ((IRfFieldElement)lhHidElement).getEnclosingScope() instanceof RfPredefinedFunction;
        if (isPredefinedFunction) {
            boolean insidePredefinedFunctionWithClause;
            String functionName = lhHidElement.getEnclosingScope().getName();
            boolean bl2 = insidePredefinedFunctionWithClause = RfHid.ARRAY_REDUCTION_METHODS.contains(functionName) || RfHid.MANDATORY_WITH_CLAUSE_METHODS.contains(functionName) || RfHid.OPTIONAL_RELATIONAL_WITH_CLAUSE_METHODS.contains(functionName);
            if (insidePredefinedFunctionWithClause) {
                return true;
            }
        }
        boolean isPotentialMatch = this.fRfElement.getName().equals(lhHidName);
        boolean isFunctionSearch = this.fIsFunctionSearch && (lhHidElement instanceof RfFunction || lhHidElement instanceof RfResultImplicitVariable);
        boolean isFieldClassOrFunctionArgumentSearch = this.fIsClassFieldOrFunctionArgumentSearch && VlogRfReferencesUtils.isClassFieldOrFunctionArgument(lhHidElement);
        boolean isMatch = false;
        boolean checkEquals = false;
        if (isFunctionSearch && !this.fRfElement.isPredefined()) {
            if (lhHidElement instanceof RfFunction) {
                LinkedHashSet<RfClass> classFamily = VlogRfReferencesUtils.computeFunctionClassFamily((RfFunction)lhHidElement, this.fFunctionClassFamily);
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)(lhHid.getParentAccess() != null ? lhHid.getParentAccess().getAssociatedType() : this.fScope), this.fRfProject, 8);
                searchMatchKind = ((RfFunction)lhHidElement).computeEquals(resolver, this.fRfElement, this.fResolver, classFamily);
            }
            if (lhHidElement instanceof RfResultImplicitVariable) {
                searchMatchKind = ((RfResultImplicitVariable)lhHidElement).computeEquals(this.fRfElement);
            }
            if (searchMatchKind != null && searchMatchKind.getFunctionCallKind() != null) {
                isMatch = this.fIsStrictVirtualFunction ? searchMatchKind.getFunctionCallKind().ordinal() == RfFunction.FunctionCallKind.STRICT.ordinal() : searchMatchKind.isMatch();
            }
        } else if (isFieldClassOrFunctionArgumentSearch && !this.fRfElement.isPredefined()) {
            if (lhHidElement instanceof RfField) {
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fScope, this.fRfProject, 8);
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.fScope, null, (boolean)true, (ELManager)this.fRfProject.getELManager());
                resolver.resolveHidInContext((IHidObject)lhHid.upwardsCopy(true), guardian, false);
                if (hidOperator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER) && this.fCurrentMethodCall != null && this.fCurrentMethodCall.methodCallHid != null) {
                    Hid parentMethodCallCopy = this.fCurrentMethodCall.methodCallHid.upwardsCopy(true);
                    resolver.resolveHidInContext((IHidObject)parentMethodCallCopy, guardian, false);
                }
                searchMatchKind = ((RfField)lhHidElement).computeEqualsForField(resolver, this.fRfElement, this.fResolver);
            }
            if (searchMatchKind != null && searchMatchKind.getTypeCompatibleKind() != null && isPotentialMatch) {
                isMatch = searchMatchKind.isMatch();
            }
        } else {
            checkEquals = this.fRfElement.checkEquals((Object)lhHidElement);
            boolean isOrderedConnectionMatch = !this.fIncludeDeclarations && !this.fForRefactor && !RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && RfSearchUtils.allowOrderedConnections((IRfNamedElement)lhHidElement);
            boolean isNormalMatch = (isPotentialMatch || isOrderedConnectionMatch) && checkEquals;
            boolean isPostElaborationMatch = this.assumeHitWhenSameNameAndType && isPotentialMatch;
            isMatch = isNormalMatch || isPostElaborationMatch;
        }
        SearchedElementWrapper wrapper = null;
        if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && this.fCurrentSearchedElementPair != null && this.fScope instanceof RfInstance && isPortConnection && checkEquals) {
            wrapper = this.collectRightElement(rhHidObjects);
        }
        if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && this.fScope instanceof RfInstance && lhHidElement instanceof IRfPortElement && checkEquals) {
            RfSearchUtils.addPreviewInfo((IRfNamedElement)this.fScope, (IRfNamedElement)lhHidElement, (SearchedElementWrapper)this.fCurrentSearchedElementPair, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (LeftRightHandSideOfOperatorEnum)LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH, (wrapper != null && wrapper.shouldBeRenamed() ? 1 : 0) != 0, (RenameConflictType)RenameConflictType.NO_CONFLICT, (this.fCurrentSearchedElementPair.getRelativeLevel() == 0 ? 1 : 0) != 0, (HidOperator)hidOperator);
        }
        if (isMatch || isPotentialMatch && lhHidElement == null) {
            if (VlogRfReferencesUtils.skipNonStrictMatchesInSemanticSearchMode(this.fSemanticSearch, searchMatchKind)) {
                return false;
            }
            RWKind writeAccess = RWKind.NONE;
            if (isMatch) {
                writeAccess = this.computeWriteAccess(hidOperator);
                if (VlogRfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)this.fRfElement, (IRfNamedElement)lhHidElement) && writeAccess == RWKind.NONE) {
                    writeAccess = RWKind.READ;
                }
            }
            this.addReferenceMatchOcc(!isMatch, (IHidObject)(isPotentialMatch || this.assumeHitWhenSameNameAndType ? lhHid : hidOperator), HitType.REGULAR, searchMatchKind, writeAccess, LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH, this.getConnectedElements(HidUtils.flattenToHids((List)OptimizedUtils.asList(rhHidObjects, (boolean)false), (Set)HidFlatteningOption.IMPLICITS_EXCLUDED)));
            return true;
        }
        return false;
    }

    private SearchedElementWrapper collectRightElement(ListContainer<IHidObject> rhHidObjects) throws Exception {
        if (rhHidObjects == null) {
            return null;
        }
        int size = rhHidObjects.size();
        if (size <= 0 || size > 1) {
            return null;
        }
        return this.collectRecursiveRightElement((IHidObject)rhHidObjects.get(0));
    }

    private SearchedElementWrapper collectRecursiveRightElement(IHidObject hidObject) throws Exception {
        if (HidUtils.isHid((IHidObject)hidObject)) {
            boolean isNamingOk;
            RfHid rhHid = (RfHid)hidObject;
            IRfNamedElement rhHidElement = rhHid.getElement();
            if (!RfSearchUtils.scopeInsideDesignPath((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IRfNamedElement)this.fScope)) {
                int collectedRelativeLevel = this.fCurrentSearchedElementPair.getRelativeLevel() + 1;
                SearchedElementWrapper newSearchedElementWrapper = new SearchedElementWrapper(rhHidElement, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
                if (RfSearchUtils.containsSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (SearchedElementWrapper)newSearchedElementWrapper)) {
                    newSearchedElementWrapper.setShouldBeRenamed(true);
                    return newSearchedElementWrapper;
                }
                return null;
            }
            if (!RfSearchUtils.shouldCollectRightElement((IRfNamedElement)rhHidElement, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject)) {
                return null;
            }
            boolean bl = isNamingOk = !this.fRenameAcrossHierarchyInfo.isMatchingNames() || !this.fRfElement.getName().equals(rhHidElement.getName());
            if (!isNamingOk) {
                return null;
            }
            int collectedRelativeLevel = this.fCurrentSearchedElementPair.getRelativeLevel() + 1;
            SearchedElementWrapper newSearchedElementWrapper = new SearchedElementWrapper(rhHidElement, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
            if (RfSearchUtils.shouldContinueWithRefactoring((boolean)true, (SearchedElementWrapper)this.fCurrentSearchedElementPair)) {
                boolean shouldBeRenamed;
                boolean bl2 = shouldBeRenamed = !RfSearchUtils.isAlreadyRenamedElementInSameEnclosingScope((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject, this.fSearchedElementsWithRelativeDepthsInfo, (IRfNamedElement)rhHidElement, (IRfInstanceElement)((RfInstance)this.fScope));
                if (!RfSearchUtils.containsSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (SearchedElementWrapper)newSearchedElementWrapper)) {
                    newSearchedElementWrapper.setShouldBeRenamed(shouldBeRenamed);
                    RfSearchUtils.collectNewSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (int)collectedRelativeLevel, (SearchedElementWrapper)newSearchedElementWrapper);
                }
            }
            this.fCurrentConnectedElement = rhHid.getName();
            return newSearchedElementWrapper;
        }
        return null;
    }

    private void collectLeftElement(IHidObject lhHidObject) throws Exception {
        boolean isNamingOk;
        if (lhHidObject == null) {
            return;
        }
        if (HidUtils.isHidAccess((IHidObject)lhHidObject)) {
            lhHidObject = ((RfHidAccess)lhHidObject).getParentHid();
        }
        if (!HidUtils.isHid((IHidObject)lhHidObject)) {
            return;
        }
        RfHid lhHid = (RfHid)lhHidObject;
        IRfNamedElement lhHidElement = lhHid.getElement();
        if (!RfSearchUtils.shouldCollectLeftElement((IRfNamedElement)lhHidElement, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject)) {
            return;
        }
        boolean bl = isNamingOk = !this.fRenameAcrossHierarchyInfo.isMatchingNames() || !this.fRfElement.getName().equals(lhHidElement.getName());
        if (!isNamingOk) {
            return;
        }
        int collectedRelativeLevel = this.fCurrentSearchedElementPair.getRelativeLevel() - 1;
        SearchedElementWrapper newSearchedElementWrapper = new SearchedElementWrapper(lhHidElement, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
        if (RfSearchUtils.shouldContinueWithRefactoring((boolean)false, (SearchedElementWrapper)this.fCurrentSearchedElementPair)) {
            boolean shouldBeRenamed;
            boolean bl2 = shouldBeRenamed = !RfSearchUtils.isAlreadyRenamedElementInSameEnclosingScope((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject, this.fSearchedElementsWithRelativeDepthsInfo, (IRfNamedElement)lhHidElement, (IRfInstanceElement)((RfInstance)this.fScope));
            if (!RfSearchUtils.containsSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (SearchedElementWrapper)newSearchedElementWrapper)) {
                newSearchedElementWrapper.setShouldBeRenamed(shouldBeRenamed);
                RfSearchUtils.collectNewSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (int)collectedRelativeLevel, (SearchedElementWrapper)newSearchedElementWrapper);
            }
        }
        this.fCurrentConnectedElement = lhHid.getName();
    }

    private boolean checkDotStarImplicitConnections(RfHidOperator operator) throws Exception {
        if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
            return false;
        }
        IRfNamedElement enclosingDesign = ((RfInstance)this.fScope).isInstanceToBind() ? ((RfInstance)this.fScope).getBindInstanceScope() : ((RfInstance)this.fScope).getEnclosingScope();
        HashMap dummyPortCache = new HashMap();
        Map portsWithSignals = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)this.fScope), dummyPortCache, (Set)HidFlatteningOption.ALL_EXCLUDED);
        if (portsWithSignals == null || portsWithSignals.isEmpty()) {
            return false;
        }
        for (Map.Entry portWithSignals : portsWithSignals.entrySet()) {
            IRfPortElement port = (IRfPortElement)portWithSignals.getKey();
            Set signals = (Set)portWithSignals.getValue();
            if (signals == null || signals.isEmpty()) continue;
            for (TCConnSignal tcConnSignal : signals) {
                boolean isPortEquals;
                if (tcConnSignal.statement.cacheImplicitPortConnection == null) continue;
                IRfNamedElement signal = DesignUtils.resolveSignal((Object)tcConnSignal.signal, (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)enclosingDesign), null, dummyPortCache);
                boolean isSignalEquals = this.fRfElement.checkEquals((Object)signal);
                boolean isPostElaborationMatch = this.assumeHitWhenSameNameAndType && this.fRfElement.getName().equals(port.getName());
                boolean bl = isPortEquals = this.fRfElement.checkEquals((Object)port) || isPostElaborationMatch;
                if (!isSignalEquals && !isPortEquals) continue;
                boolean isDotStar = PortConnectionUtils.isDotStarConnected((IHidOperator)tcConnSignal.statement.cacheImplicitPortConnection);
                IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
                if (document == null) {
                    return false;
                }
                RWKind writeAccess = RfSearchUtils.computePortArgumentConnectionWriteAccess((IRfNamedElement)port, (IRfNamedElement)signal, (boolean)isSignalEquals, (RWKind)this.fSearchedPortElementWriteType);
                SearchedElementWrapper newSearchedElementWrapper = null;
                if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && isPortEquals && RfSearchUtils.shouldCollectRightElement((IRfNamedElement)signal, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject)) {
                    int collectedRelativeLevel = this.fCurrentSearchedElementPair.getRelativeLevel() + 1;
                    newSearchedElementWrapper = new SearchedElementWrapper(signal, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
                    if (RfSearchUtils.scopeInsideDesignPath((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IRfNamedElement)this.fScope) && RfSearchUtils.shouldContinueWithRefactoring((boolean)true, (SearchedElementWrapper)this.fCurrentSearchedElementPair)) {
                        boolean shouldBeRenamed;
                        boolean bl2 = shouldBeRenamed = !RfSearchUtils.isAlreadyRenamedElementInSameEnclosingScope((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject, this.fSearchedElementsWithRelativeDepthsInfo, (IRfNamedElement)signal, (IRfInstanceElement)((RfInstance)this.fScope));
                        if (!RfSearchUtils.containsSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (SearchedElementWrapper)newSearchedElementWrapper)) {
                            newSearchedElementWrapper.setShouldBeRenamed(shouldBeRenamed);
                            RfSearchUtils.collectNewSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (int)collectedRelativeLevel, (SearchedElementWrapper)newSearchedElementWrapper);
                        }
                    }
                    this.fCurrentConnectedElement = signal.getName();
                } else if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && isSignalEquals && RfSearchUtils.shouldCollectLeftElement((IRfNamedElement)port, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject) && this.fCurrentSearchedElementPair != null) {
                    int collectedRelativeLevel = this.fCurrentSearchedElementPair.getRelativeLevel() - 1;
                    newSearchedElementWrapper = new SearchedElementWrapper((IRfNamedElement)port, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
                    if (RfSearchUtils.shouldContinueWithRefactoring((boolean)false, (SearchedElementWrapper)this.fCurrentSearchedElementPair)) {
                        boolean shouldBeRenamed;
                        boolean bl3 = shouldBeRenamed = !RfSearchUtils.isAlreadyRenamedElementInSameEnclosingScope((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (IProject)this.fProject, this.fSearchedElementsWithRelativeDepthsInfo, (IRfNamedElement)port, (IRfInstanceElement)((RfInstance)this.fScope));
                        if (!RfSearchUtils.containsSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (SearchedElementWrapper)newSearchedElementWrapper)) {
                            newSearchedElementWrapper.setShouldBeRenamed(shouldBeRenamed);
                            RfSearchUtils.collectNewSearchedElement(this.fSearchedElementsWithRelativeDepthsInfo, (int)collectedRelativeLevel, (SearchedElementWrapper)newSearchedElementWrapper);
                        }
                    }
                    this.fCurrentConnectedElement = port.getName();
                }
                if (isPortEquals || this.assumeHitWhenSameNameAndType) {
                    this.addDotOrImplicitMatchOcc(false, document, tcConnSignal.statement.cacheImplicitPortConnection, isDotStar ? HitType.DOTSTAR : HitType.IMPLICIT, (RfInstance)this.fScope, writeAccess, LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH);
                    if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo)) {
                        RfSearchUtils.addPreviewInfo((IRfNamedElement)this.fScope, (IRfNamedElement)port, (SearchedElementWrapper)this.fCurrentSearchedElementPair, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (LeftRightHandSideOfOperatorEnum)LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH, (newSearchedElementWrapper != null && newSearchedElementWrapper.shouldBeRenamed() ? 1 : 0) != 0, (RenameConflictType)RenameConflictType.NO_CONFLICT, (this.fCurrentSearchedElementPair.getRelativeLevel() == 0 ? 1 : 0) != 0, (HidOperator)operator);
                    }
                }
                if (isSignalEquals) {
                    this.addDotOrImplicitMatchOcc(false, document, tcConnSignal.statement.cacheImplicitPortConnection, isDotStar ? HitType.DOTSTAR : HitType.IMPLICIT, (RfInstance)this.fScope, writeAccess, LeftRightHandSideOfOperatorEnum.RIGHT_HAND_MATCH);
                    if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo)) {
                        RfSearchUtils.addPreviewInfo((IRfNamedElement)((IRfNamedElement)signal.getEnclosingScope()), (IRfNamedElement)signal, (SearchedElementWrapper)this.fCurrentSearchedElementPair, (RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo, (LeftRightHandSideOfOperatorEnum)LeftRightHandSideOfOperatorEnum.RIGHT_HAND_MATCH, (newSearchedElementWrapper != null && newSearchedElementWrapper.shouldBeRenamed() ? 1 : 0) != 0, (RenameConflictType)RenameConflictType.NO_CONFLICT, (this.fCurrentSearchedElementPair.getRelativeLevel() == 0 ? 1 : 0) != 0, (HidOperator)operator);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isPredefinedSystemTaskWriteParameter() {
        if (this.fCurrentMethodCall == null || this.fCurrentMethodCall.methodCallHid == null || this.fCurrentMethodCall.methodCallHid.getName() == null) {
            return false;
        }
        String systemTaskName = this.fCurrentMethodCall.methodCallHid.getName();
        if (!systemTaskName.startsWith("$")) {
            return false;
        }
        int argumentPosition = this.fCurrentMethodCall.position;
        if ("$sscanf".equals(systemTaskName)) {
            return argumentPosition >= 2;
        }
        if ("$fscanf".equals(systemTaskName)) {
            return argumentPosition >= 2;
        }
        if ("$fgets".equals(systemTaskName)) {
            return argumentPosition >= 1;
        }
        if (systemTaskName.startsWith("$swrite")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.startsWith("$sformat")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.startsWith("$fdisplay") || systemTaskName.startsWith("$fwrite") || systemTaskName.startsWith("$fread")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.startsWith("$readmem")) {
            return argumentPosition == 1;
        }
        if (systemTaskName.startsWith("$sreadmem")) {
            return argumentPosition == 1;
        }
        if (systemTaskName.equals("$disable_signal_spy") || systemTaskName.equals("$enable_signal_spy") || systemTaskName.equals("$init_signal_driver") || systemTaskName.equals("$init_signal_spy")) {
            return argumentPosition == 1;
        }
        if (systemTaskName.equals("$signal_force") || systemTaskName.equals("$signal_release")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$coverage_save_mti")) {
            return argumentPosition == 2;
        }
        if (systemTaskName.equals("$messagelog")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$add_relation")) {
            return argumentPosition == 1;
        }
        if (systemTaskName.equals("$deposit")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$hdl_xmr_release")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$hdl_xmr_force")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$fs_fapply")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$fs_loadStimFile")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$nc_mirror") || systemTaskName.equals("$nc_deposit") || systemTaskName.equals("$nc_force") || systemTaskName.equals("$nc_release")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$cast")) {
            return argumentPosition == 0;
        }
        if (systemTaskName.equals("$value$plusargs")) {
            return argumentPosition == 1;
        }
        return false;
    }

    private RWKind computeWriteAccess(RfHidOperator operator) {
        boolean isPortArgumentConnection = operator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value()) || operator.hasQualifier(HidOperatorQualifier.IS_ARGUMENT_VALUE.value());
        boolean isPatternOperator = operator.hasOccurrence(HidOperatorQualifier.IS_PATTERN_VALUE);
        boolean isDeclarationAssign = operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN);
        return isPatternOperator || isDeclarationAssign ? RWKind.WRITE : (isPortArgumentConnection ? this.fSearchedPortElementWriteType : RWKind.NONE);
    }

    private void addDotOrImplicitMatchOcc(boolean isPossibleMatch, IDocument document, IHidOperator hidOperator, HitType type, RfInstance instance, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection) throws Exception {
        int line = hidOperator.getOccurrence().getLine();
        int offset = hidOperator.getOccurrence().getOffset();
        int virtualOffset = hidOperator.getOccurrence().getVirtualOffset();
        String matchString = DOT_STAR_CONNECTION;
        if (type == HitType.IMPLICIT) {
            matchString = this.fRfElement.getName();
        }
        if (virtualOffset == -1) {
            IRegion startLineInfo = document.getLineInformation(line - 1);
            String lineContents = document.get(startLineInfo.getOffset(), startLineInfo.getLength());
            int lineStart = startLineInfo.getOffset();
            VlogSearchHit lineEntry = new VlogSearchHit(this.fParserPath, line, offset, lineContents, matchString.length(), false, this.fCurrentSearchedElementPair == null ? true : this.fCurrentSearchedElementPair.shouldBeRenamed(), this.fProject, null);
            lineEntry.setLeftRightHandSideOfConnection(leftRightHandSideOfConnection);
            lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)line, (int)offset, (boolean)isPossibleMatch));
            lineEntry.setHitType(type);
            lineEntry.setInstance(instance);
            lineEntry.setAccess(writeAccess);
            int counter = VlogRfReferencesUtils.countStartWS((IDocument)document, (IRegion)startLineInfo);
            if (counter >= 0) {
                lineEntry.setSearchedElement(matchString, offset - lineStart - counter, isPossibleMatch);
            }
            this.fListener.addMatch((Object)lineEntry);
        } else {
            MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, offset, this.fParserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (macroCallHitInfo == null) {
                return;
            }
            if (macroCallHitInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, offset, -1, document, isPossibleMatch, type, SearchMatchKindsWrapper.getNoMatch(), macroCallHitInfo.getMacroCallText(), writeAccess, leftRightHandSideOfConnection, null, new HashSet<SearchHitConnectedElementInfo>());
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                if (!macroCallParameterHit.getText().isEmpty() && this.addHitOccurence(false, offset = macroCallParameterHit.getOffset(), -1, document, isPossibleMatch, type, SearchMatchKindsWrapper.getNoMatch(), macroCallHitInfo.getMacroCallText(), writeAccess, leftRightHandSideOfConnection, null, new HashSet<SearchHitConnectedElementInfo>())) continue;
            }
        }
    }

    private void addReferenceMatchOcc(boolean isPossibleMatch, IHidObject hidObject, HitType type, SearchMatchKindsWrapper searchMatchKindWrapper, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperator, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
            return;
        }
        if (!RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameAcrossHierarchyInfo) && this.isHiddenHit(hidObject)) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
        if (document == null) {
            return;
        }
        if (HidUtils.isHid((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, document, (Hid)hidObject, type, searchMatchKindWrapper, writeAccess, leftRightHandSideOfOperator, elements);
        } else if (HidUtils.isOperator((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, document, (HidOperator)hidObject, type, searchMatchKindWrapper, writeAccess, leftRightHandSideOfOperator, elements);
        } else if (HidUtils.isHidImplicit((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, document, this.fRfElement, type, searchMatchKindWrapper, writeAccess, leftRightHandSideOfOperator, elements);
        }
    }

    private boolean isHiddenHit(IHidObject hid) {
        return AssociationUtils.isConnectedType((IHidObject)hid) || AssociationUtils.isUnconnectedType((IHidObject)hid);
    }

    private void addMatchOcc(boolean isPossibleMatch, IDocument document, Hid hid, HitType type, SearchMatchKindsWrapper searchMatchKindWrapper, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperator, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        HidOccurrence occurence = hid.getOccurrence();
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            ++this.fCheckForQueryInterruptionCounter;
        }
        if (occurence.hasQualifier(HidQualifierCache.CONSTRUCTOR_DECLARATION)) {
            return;
        }
        if (virtualOffset == -1) {
            this.addHitOccurence(false, offset, occurence.getLine(), document, isPossibleMatch, type, searchMatchKindWrapper, null, writeAccess, leftRightHandSideOfOperator, hid, elements);
        } else {
            MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), this.fParserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (macroCallHitInfo == null) {
                return;
            }
            if (macroCallHitInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, offset, -1, document, isPossibleMatch, type, searchMatchKindWrapper, macroCallHitInfo.getMacroCallText(), writeAccess, leftRightHandSideOfOperator, hid, elements);
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
            for (MacroCallParameterHit macroCallParameterHit : macroCallParameterHits) {
                if (!macroCallParameterHit.getText().isEmpty() && this.addHitOccurence(false, offset = macroCallParameterHit.getOffset(), -1, document, isPossibleMatch, type, searchMatchKindWrapper, macroCallHitInfo.getMacroCallText(), writeAccess, leftRightHandSideOfOperator, hid, elements)) continue;
            }
        }
    }

    private void addMatchOcc(boolean isPossibleMatch, IDocument document, IRfNamedElement element, HitType type, SearchMatchKindsWrapper searchMatchKindWrapper, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperator, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        int offset = element.getOffset();
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            ++this.fCheckForQueryInterruptionCounter;
        }
        this.addHitOccurence(false, offset, element.getLine(), document, isPossibleMatch, type, searchMatchKindWrapper, null, writeAccess, leftRightHandSideOfOperator, null, elements);
    }

    private void addMatchOcc(boolean isPossibleMatch, IDocument document, HidOperator operator, HitType type, SearchMatchKindsWrapper searchMatchKindWrapper, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperator, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        HidOperatorOccurrence occurence = operator.getOccurrence();
        int virtualOffset = occurence.getVirtualOffset();
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            ++this.fCheckForQueryInterruptionCounter;
        }
        if (occurence.hasQualifier(HidQualifierCache.CONSTRUCTOR_DECLARATION)) {
            return;
        }
        if (virtualOffset == -1) {
            this.addHitOccurence(false, operator.getOpenBoundary(), operator.getCloseBoundary(), occurence.getLine(), document, isPossibleMatch, type, searchMatchKindWrapper, null, writeAccess, leftRightHandSideOfOperator, elements);
        } else {
            MacroCallHitsInfo macroCallHitInfo = VlogRfReferencesUtils.computeMacroHit(isPossibleMatch, this.fRfElement, this.fResolver, this.fRfProject, this.fMacroInfoMap, occurence.getOffset(), this.fParserPath, document, this.fFunctionClassFamily, this.fDisableHitInMacroArgument);
            if (macroCallHitInfo == null) {
                return;
            }
            if (macroCallHitInfo.hasHitsInsideMacroCall()) {
                this.addHitOccurence(true, operator.getOpenBoundary(), operator.getCloseBoundary(), -1, document, isPossibleMatch, type, searchMatchKindWrapper, macroCallHitInfo.getMacroCallText(), writeAccess, leftRightHandSideOfOperator, elements);
                return;
            }
            List<MacroCallParameterHit> macroCallParameterHits = macroCallHitInfo.getMacroCallParameterHits();
            if (macroCallParameterHits == null || macroCallParameterHits.isEmpty()) {
                return;
            }
        }
    }

    private boolean addHitOccurence(boolean isNonParameterHit, int offset, int line, IDocument document, boolean isPossibleMatch, HitType type, SearchMatchKindsWrapper searchMatchKindWrapper, String macroCallText, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperator, Hid hid, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        boolean isEscapedMatch;
        if (line == -1) {
            line = document.getLineOfOffset(offset) + 1;
        }
        IRegion info = document.getLineInformation(line - 1);
        String lineContents = document.get(info.getOffset(), info.getLength());
        int lineOffset = document.getLineOffset(line - 1);
        int matchLength = this.fRfElement.getName().length();
        String highlightName = this.fRfElement.getName();
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)document, (IRegion)info);
        if (type == HitType.DOTSTAR) {
            matchLength = 2;
        }
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        boolean bl = isEscapedMatch = offset - lineOffset >= 0 && offset - lineOffset < lineContents.length() && lineContents.charAt(offset - lineOffset) == '\\';
        if (isEscapedMatch) {
            ++matchLength;
        }
        if (VlogRfReferencesUtils.shouldSkipFunctionUsage(searchMatchKindWrapper.getFunctionCallKind(), this.fIncludeDeclarations, hid, this.fRfElement.getEnclosingScope(), (IRfScopeElement)this.fScope)) {
            return true;
        }
        VlogSearchHit lineEntry = new VlogSearchHit(this.fParserPath, line, offset, lineContents, matchLength, searchMatchKindWrapper, isNonParameterHit, this.fCurrentSearchedElementPair == null ? true : this.fCurrentSearchedElementPair.shouldBeRenamed(), this.fCurrentConnectedElement, this.fRfElement, this.fProject, hid);
        lineEntry.setLeftRightHandSideOfConnection(leftRightHandSideOfOperator);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)line, (int)offset, (boolean)isPossibleMatch));
        lineEntry.setConnectedElement(elements);
        int highlightOffset = offset;
        if (isEscapedMatch) {
            ++highlightOffset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, highlightOffset - lineOffset - counter, isPossibleMatch);
        }
        if (this.fScope instanceof RfInstance) {
            lineEntry.setInstance((RfInstance)this.fScope);
        }
        if (hid != null && hid.getParentAccess() != null) {
            lineEntry.setIsInsideHierarchicalAccess();
        }
        if (leftRightHandSideOfOperator == LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH) {
            lineEntry.setIsInsideHierarchicalAccess();
        }
        lineEntry.setAccess(writeAccess);
        lineEntry.setHitType(type);
        lineEntry.setIsEscaped(isEscapedMatch);
        lineEntry.setSemanticScope((IRfScopeElement)this.fScope);
        lineEntry.setVirtualOffset(hid == null ? -1 : hid.getVirtualOffset());
        this.fListener.addMatch((Object)lineEntry);
        return true;
    }

    private boolean addHitOccurence(boolean isNonParameterHit, int startOffset, int endOffset, int line, IDocument document, boolean isPossibleMatch, HitType type, SearchMatchKindsWrapper searchMatchKindWrapper, String macroCallText, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfOperator, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        if (line == -1) {
            line = document.getLineOfOffset(startOffset) + 1;
        }
        IRegion info = document.getLineInformation(line - 1);
        String lineContents = document.get(info.getOffset(), info.getLength());
        int lineOffset = document.getLineOffset(line - 1);
        int endJumpOffset = Math.min(endOffset, lineOffset + lineContents.length());
        StringBuilder str = new StringBuilder();
        int i = startOffset;
        while (i < endJumpOffset) {
            str.append(DUMMY_CHAR_STRING);
            ++i;
        }
        int matchLength = str.toString().length();
        String highlightName = str.toString().trim();
        int counter = VlogRfReferencesUtils.countStartWS((IDocument)document, (IRegion)info);
        if (type == HitType.DOTSTAR) {
            matchLength = 2;
        }
        if (isNonParameterHit && counter >= 0) {
            highlightName = macroCallText;
            matchLength = macroCallText.length();
        }
        if (VlogRfReferencesUtils.shouldSkipFunctionUsage(searchMatchKindWrapper.getFunctionCallKind(), this.fIncludeDeclarations, null, this.fRfElement.getEnclosingScope(), (IRfScopeElement)this.fScope)) {
            return true;
        }
        VlogSearchHit lineEntry = new VlogSearchHit(this.fParserPath, line, startOffset, lineContents, matchLength, searchMatchKindWrapper, isNonParameterHit, this.fCurrentSearchedElementPair == null ? true : this.fCurrentSearchedElementPair.shouldBeRenamed(), this.fCurrentConnectedElement, this.fRfElement, this.fProject, null);
        lineEntry.setLeftRightHandSideOfConnection(leftRightHandSideOfOperator);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)line, (int)startOffset, (boolean)isPossibleMatch));
        lineEntry.setConnectedElement(elements);
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, startOffset - lineOffset - counter, isPossibleMatch);
        }
        if (this.fScope instanceof RfInstance) {
            lineEntry.setInstance((RfInstance)this.fScope);
            VlogRfReferencesUtils.changeToPostConfigHit((IProject)this.fProject, (IRfInstanceElement)((RfInstance)this.fScope), (SearchHit)lineEntry);
        }
        lineEntry.setAccess(writeAccess);
        lineEntry.setHitType(type);
        lineEntry.setIsEscaped(false);
        if (this.assumeHitWhenSameNameAndType) {
            lineEntry.setIsElaborationHit();
        }
        this.fListener.addMatch((Object)lineEntry);
        return true;
    }

    public void setHolder(IHidHolder holder) {
        if (holder instanceof RfHidHolder) {
            this.fScope = ((RfHidHolder)holder).getScope();
        }
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }

    @Override
    public void setInfo(SMethodCallInfo methodCall) {
        this.fCurrentMethodCall = methodCall;
    }

    public void setAssumeHitWhenSameNameAndType() {
        this.assumeHitWhenSameNameAndType = true;
    }
}

