/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.search.new_engine;

import java.text.MessageFormat;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.RfSearchQueryElement;
import ro.amiq.vlogdt.ui.search.new_engine.NewHidsSearchEngine;
import ro.amiq.vlogdt.ui.search.new_engine.ReadersFileSearchResult;
import ro.amiq.vlogdt.ui.search.new_engine.WritersFileSearchResult;
import ro.amiq.vlogdt.ui.search.text.FileSearchQuery;
import ro.amiq.vlogdt.ui.search.text.FileSearchResult;

public class ReferenceHidSearchQuery
extends FileSearchQuery
implements IBuildDoneListener {
    private IRfNamedElement fRfElement;
    private IRfScopeElement fScopeElement;
    private ElementPath fDesignContextPath;
    private IProject fProject;
    private RfElementPath fRfElementPath;
    private boolean fProjectRebuilt;
    private RWSearchTypeEnum fSearchRWType;
    private String fSearchedString;
    private BiPredicate<IHidObject, IRfClassElement> fFilterPredicate;
    private RfTypesResolver fResolver;

    public ReferenceHidSearchQuery(IProject project, String searchType, IRfNamedElement element, RfTypesResolver resolver, IRfScopeElement scopeElement, ElementPath designContextPath, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, int searchFor, boolean forRefactoring, boolean isStrictVirtualFunction, RWSearchTypeEnum searchRWType, String searchedString, BiPredicate<IHidObject, IRfClassElement> filterPredicate) {
        super(searchType, element.getName(), searchLabel, isRegEx, isCaseSensitive, isWholeWord, scope, limitTo, false, false, searchFor, forRefactoring, isStrictVirtualFunction);
        this.fRfElement = element;
        this.fScopeElement = scopeElement;
        this.fSearchedString = searchedString;
        this.fRfElementPath = RfElementPath.path((IRfNamedElement)element);
        this.fIncludeDeclarations = includeDeclarations;
        this.fProject = project;
        this.fSearchRWType = searchRWType;
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
        this.fFilterPredicate = filterPredicate;
        this.fResolver = resolver;
        this.fDesignContextPath = designContextPath;
        PrefConst.setSearchViewVlogdtHideReferencesOutsideDesignContext((this.fDesignContextPath != null ? 1 : 0) != 0);
    }

    public boolean hasDesignContextPath() {
        return this.fDesignContextPath != null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IRfNamedElement getRfElement() {
        if (!this.fProjectRebuilt || this.fRfElement instanceof RfSearchQueryElement) {
            return this.fRfElement;
        }
        this.fRfElement = this.fRfElementPath.toNamedElement(this.fProject);
        if (this.fRfElement == null) {
            return null;
        }
        this.fProjectRebuilt = false;
        return this.fRfElement;
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        try {
            Pattern searchPattern;
            IRfNamedElement rfElement = this.getRfElement();
            if (rfElement == null) {
                return Status.OK_STATUS;
            }
            AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
            if (!this.isAccumulateResults()) {
                textResult.removeAll();
            }
            if ((searchPattern = this.getSearchPattern()) == null) {
                return Status.CANCEL_STATUS;
            }
            return new NewHidsSearchEngine(this.fIncludeDeclarations, this, this.fSearchRWType, this.fProject).search(rfElement, this.fDesignContextPath, this.fResolver, this.getScope(), searchPattern, monitor, this.fForRefactor, this.fIsStrictVirtualFunction, textResult, this.fSearchedString, this.fFilterPredicate, ro.amiq.vlogdt.ui.preferences.PrefConst.getSearchVlogDisableMacroCallArgumentDetection());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    public String getResultLabel(int nMatches) {
        String readersWritersType;
        if (this.fProject == null) {
            return super.getResultLabel(nMatches);
        }
        if (this.fRfElement == null) {
            String string = this.getSearchLabel();
        }
        String searchString = PrefConst.getSearchViewVlogdtHideReferencesOutsideDesignContext() ? VlogRfReferencesUtils.getFullNameLabel(this.fRfElement, this.fResolver, this.fDesignContextPath) : VlogRfReferencesUtils.getFullNameLabel(this.fRfElement, this.fResolver, null);
        String searchType = this.getSearchType();
        String projectName = this.fProject.getName();
        String searchTypeField = this.getSearchedElementKind().toLowerCase();
        if (searchString.isEmpty()) {
            return super.getResultLabel(nMatches);
        }
        Set unsynchedFiles = this.getUnsynchedFiles();
        if (this.fSearchRWType == RWSearchTypeEnum.USAGES) {
            if (nMatches == 1) {
                Object[] objectArray = new Object[4];
                objectArray[0] = searchType;
                objectArray[1] = searchString;
                objectArray[3] = projectName;
                Object[] args = objectArray;
                return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_singularLabel, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
            }
            Object[] objectArray = new Object[5];
            objectArray[0] = searchType;
            objectArray[1] = searchString;
            objectArray[2] = nMatches;
            objectArray[4] = projectName;
            Object[] args = objectArray;
            return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_pluralPattern, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
        }
        String string = readersWritersType = this.fSearchRWType == RWSearchTypeEnum.WRITERS ? "Writers" : "Readers";
        if (nMatches == 1) {
            Object[] args = new Object[]{readersWritersType, searchTypeField, searchString, projectName};
            return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_readersWriters_singularLabel, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
        }
        Object[] args = new Object[]{readersWritersType, searchTypeField, searchString, nMatches, projectName};
        return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_readersWriters_pluralPattern, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
    }

    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
            return;
        }
        if (this.fProject == null) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }

    @Override
    protected BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery baseSearchQuery) {
        if (this.fSearchRWType == RWSearchTypeEnum.READERS) {
            return new ReadersFileSearchResult((BaseTextSearchQuery)this);
        }
        if (this.fSearchRWType == RWSearchTypeEnum.WRITERS) {
            return new WritersFileSearchResult((BaseTextSearchQuery)this);
        }
        return new FileSearchResult((BaseTextSearchQuery)this);
    }

    public String getLabelForHyperlink(String message, boolean seeAllMatchesLabel) {
        String searchType = this.fSearchRWType == RWSearchTypeEnum.READERS ? "readers" : (this.fSearchRWType == RWSearchTypeEnum.WRITERS ? "writers" : "references");
        if (seeAllMatchesLabel) {
            return MessageFormat.format(message, searchType);
        }
        return MessageFormat.format(message, searchType, this.fDesignContextPath);
    }
}

